/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class KeyBasedLargeFileProcessor {
    private static void decryptFile(String string, String string2, char[] cArray, String string3) throws IOException, NoSuchProviderException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string2));
        KeyBasedLargeFileProcessor.decryptFile(bufferedInputStream, bufferedInputStream2, cArray, string3);
        ((InputStream)bufferedInputStream2).close();
        ((InputStream)bufferedInputStream).close();
    }

    private static void decryptFile(InputStream inputStream, InputStream inputStream2, char[] cArray, String string) throws IOException, NoSuchProviderException {
        block12: {
            inputStream = PGPUtil.getDecoderStream(inputStream);
            try {
                String string2;
                PGPLiteralData pGPLiteralData;
                JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
                Object object = jcaPGPObjectFactory.nextObject();
                PGPEncryptedDataList pGPEncryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
                Iterator<PGPEncryptedData> iterator = pGPEncryptedDataList.getEncryptedDataObjects();
                PGPPrivateKey pGPPrivateKey = null;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
                PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                while (pGPPrivateKey == null && iterator.hasNext()) {
                    pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)iterator.next();
                    pGPPrivateKey = PGPExampleUtil.findSecretKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), cArray);
                }
                if (pGPPrivateKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream inputStream3 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
                JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream3);
                PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory2.nextObject();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(pGPCompressedData.getDataStream());
                JcaPGPObjectFactory jcaPGPObjectFactory3 = new JcaPGPObjectFactory(bufferedInputStream);
                Object object2 = jcaPGPObjectFactory3.nextObject();
                if (object2 instanceof PGPLiteralData) {
                    pGPLiteralData = (PGPLiteralData)object2;
                    string2 = pGPLiteralData.getFileName();
                    if (string2.length() == 0) {
                        string2 = string;
                    }
                } else {
                    if (object2 instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                InputStream inputStream4 = pGPLiteralData.getInputStream();
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                Streams.pipeAll((InputStream)inputStream4, (OutputStream)fileOutputStream, (int)8192);
                ((OutputStream)fileOutputStream).close();
                if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
                    if (!pGPPublicKeyEncryptedData.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block12;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, NoSuchProviderException, PGPException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        PGPPublicKey pGPPublicKey = PGPExampleUtil.readPublicKey(string3);
        KeyBasedLargeFileProcessor.encryptFile(bufferedOutputStream, string2, pGPPublicKey, bl, bl2);
        ((OutputStream)bufferedOutputStream).close();
    }

    private static void encryptFile(OutputStream outputStream, String string, PGPPublicKey pGPPublicKey, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        block4: {
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
            }
            try {
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(bl2).setSecureRandom(new SecureRandom()).setProvider("BC"));
                pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
                OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[65536]);
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
                PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(outputStream2), 'b', new File(string), new byte[65536]);
                pGPCompressedDataGenerator.close();
                outputStream2.close();
                if (bl) {
                    outputStream.close();
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block4;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray.length == 0) {
            System.err.println("usage: KeyBasedLargeFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                KeyBasedLargeFileProcessor.encryptFile(stringArray[2] + ".asc", stringArray[2], stringArray[3], true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                KeyBasedLargeFileProcessor.encryptFile(stringArray[2] + ".bpg", stringArray[2], stringArray[3], false, true);
            } else {
                KeyBasedLargeFileProcessor.encryptFile(stringArray[1] + ".bpg", stringArray[1], stringArray[2], false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            KeyBasedLargeFileProcessor.decryptFile(stringArray[1], stringArray[2], stringArray[3].toCharArray(), new File(stringArray[1]).getName() + ".out");
        } else {
            System.err.println("usage: KeyBasedLargeFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

