/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.authenticator;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.internal.core.IUserAuthenticator;
import org.eclipse.jsch.internal.core.IUserInfo;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.jsch.internal.ui.authenticator.KeyboardInteractiveDialog;
import org.eclipse.jsch.internal.ui.authenticator.UserValidationDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class WorkbenchUserAuthenticator
implements IUserAuthenticator {
    public void promptForUserInfo(IJSchLocation location, IUserInfo userinfo, String message) {
        String[] result = new String[2];
        Display display = Display.getCurrent();
        boolean[] allowCaching = new boolean[1];
        if (display != null) {
            allowCaching[0] = this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
        } else {
            Display.getDefault().syncExec(() -> {
                boolean bl = this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Messages.WorkbenchUserAuthenticator_cancelled);
        }
        if (userinfo.isUsernameMutable()) {
            userinfo.setUsername(result[0]);
        }
        userinfo.setPassword(result[1]);
        if (location != null) {
            if (userinfo.isUsernameMutable()) {
                location.setUsername(result[0]);
            }
            location.setPassword(result[1]);
            if (location.getPasswordStore() != null) {
                if (allowCaching[0]) {
                    location.getPasswordStore().update(location);
                } else {
                    location.getPasswordStore().clear(location);
                }
            }
        }
    }

    protected boolean promptForPassword(IJSchLocation location, String username, String message, boolean userMutable, String[] result) {
        String comment = location == null ? null : location.getComment();
        UserValidationDialog dialog = new UserValidationDialog(null, comment, username == null ? "" : username, message, location != null && location.getPasswordStore() != null);
        dialog.setUsernameMutable(userMutable);
        dialog.open();
        result[0] = dialog.getUsername();
        result[1] = dialog.getPassword();
        return dialog.getAllowCaching();
    }

    public String[] promptForKeyboradInteractive(IJSchLocation location, String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        String[][] result = new String[1][];
        boolean[] allowCaching = new boolean[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
        } else {
            Display.getDefault().syncExec(() -> {
                String[] stringArray3 = this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
            });
        }
        if (result[0] != null && location != null && prompt != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
            location.setPassword(result[0][0]);
            if (location.getPasswordStore() != null) {
                if (allowCaching[0]) {
                    location.getPasswordStore().update(location);
                } else {
                    location.getPasswordStore().clear(location);
                }
            }
        }
        return result[0];
    }

    protected String[] _promptForUserInteractive(IJSchLocation location, String destination, String name, String instruction, String[] prompt, boolean[] echo, boolean[] allowCaching) {
        String comment = location == null ? null : location.getComment();
        String username = location == null ? "" : location.getUsername();
        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, comment, destination, name, username, instruction, prompt, echo);
        dialog.setUsernameMutable(false);
        dialog.open();
        String[] _result = dialog.getResult();
        if (_result != null) {
            allowCaching[0] = dialog.getAllowCaching();
        }
        return _result;
    }

    public int prompt(IJSchLocation location, int promptType, String title, String message, int[] promptResponses, int defaultResponse) {
        Display display = this.getStandardDisplay();
        int[] retval = new int[1];
        String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(() -> {
            IShellProvider shellProvider;
            Shell shell = null;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (shellProvider = workbench.getModalDialogShellProvider()) != null) {
                shell = shellProvider.getShell();
            }
            if (shell == null) {
                shell = new Shell(display);
            }
            MessageDialog dialog = new MessageDialog(shell, title, null, message, promptType, buttons, 1);
            nArray[0] = dialog.open();
        });
        return retval[0];
    }

    public boolean promptForHostKeyChange(IJSchLocation location) {
        boolean[] openConfirm = new boolean[1];
        Display display = this.getStandardDisplay();
        display.syncExec(() -> {
            boolean bl = MessageDialog.openConfirm(null, (String)Messages.WorkbenchUserAuthenticator_1, (String)NLS.bind((String)Messages.WorkbenchUserAuthenticator_2, (Object[])new String[]{location.getHost()}));
        });
        if (!openConfirm[0]) {
            throw new OperationCanceledException();
        }
        return openConfirm[0];
    }

    private Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

