/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties;

import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GradientBackgroundListener
implements Listener {
    private static Map<Control, GradientBackgroundListener> handlers = new HashMap<Control, GradientBackgroundListener>();
    private Gradient grad;
    private final Control control;
    private boolean radialGradient;
    Image gradientImage;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            GradientBackgroundListener.remove(GradientBackgroundListener.this.control);
        }
    };

    private GradientBackgroundListener(Control control, Gradient grad) {
        this.grad = grad;
        this.control = control;
        control.addListener(11, (Listener)this);
        control.addDisposeListener(this.disposeListener);
    }

    public void dispose() {
        this.grad = null;
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(11, (Listener)this);
            this.control.removeDisposeListener(this.disposeListener);
            if (this.control.getBackgroundImage() == this.gradientImage) {
                this.control.setBackgroundImage(null);
            }
        }
        if (this.gradientImage != null && !this.gradientImage.isDisposed()) {
            this.gradientImage.dispose();
        }
        this.gradientImage = null;
    }

    public static void handle(Control control, Gradient grad) {
        GradientBackgroundListener handler = handlers.get(control);
        if (handler == null) {
            handler = new GradientBackgroundListener(control, grad);
            handlers.put(control, handler);
            handler.handleEvent(null);
        } else {
            handler.grad = grad;
            handler.handleEvent(null);
        }
    }

    public static void remove(Control control) {
        GradientBackgroundListener handler = handlers.remove(control);
        if (handler != null) {
            handler.dispose();
        }
    }

    public void handleEvent(Event event) {
        Point size = this.control.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        Image oldImage = this.control.getBackgroundImage();
        if (oldImage != this.gradientImage) {
            oldImage = null;
        }
        if (this.grad.isRadial()) {
            ArrayList<java.awt.Color> colors = new ArrayList<java.awt.Color>();
            for (Object rgbObj : this.grad.getRGBs()) {
                java.awt.Color color;
                if (rgbObj instanceof RGBA) {
                    RGBA rgba = (RGBA)rgbObj;
                    color = new java.awt.Color(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
                    colors.add(color);
                    continue;
                }
                if (!(rgbObj instanceof RGB)) continue;
                RGB rgb = (RGB)rgbObj;
                color = new java.awt.Color(rgb.red, rgb.green, rgb.blue);
                colors.add(color);
            }
            BufferedImage image = this.getBufferedImage(size.x, size.y, colors, CSSSWTColorHelper.getPercents(this.grad));
            ImageData imagedata = this.convertToSWT(image);
            this.gradientImage = new Image((Device)this.control.getDisplay(), imagedata);
            this.radialGradient = true;
        } else if (oldImage == null || oldImage.isDisposed() || oldImage.getBounds().height != size.y || this.radialGradient || event == null) {
            this.radialGradient = false;
            boolean verticalGradient = this.grad.getVerticalGradient();
            int x = verticalGradient ? 2 : size.x;
            int y = verticalGradient ? size.y : 2;
            this.gradientImage = new Image((Device)this.control.getDisplay(), x, y);
            GC gc = new GC((Drawable)this.gradientImage);
            ArrayList<Color> colors = new ArrayList<Color>();
            for (Object rgbObj : this.grad.getRGBs()) {
                Color color;
                if (rgbObj instanceof RGBA) {
                    RGBA rgba = (RGBA)rgbObj;
                    color = new Color((Device)this.control.getDisplay(), rgba);
                    colors.add(color);
                    continue;
                }
                if (!(rgbObj instanceof RGB)) continue;
                RGB rgb = (RGB)rgbObj;
                color = new Color((Device)this.control.getDisplay(), rgb);
                colors.add(color);
            }
            GradientBackgroundListener.fillGradient(gc, new Rectangle(0, 0, x, y), colors, CSSSWTColorHelper.getPercents(this.grad), this.grad.getVerticalGradient());
            gc.dispose();
        }
        if (this.gradientImage != null) {
            this.control.setBackgroundImage(this.gradientImage);
        }
        if (oldImage != null && oldImage != this.gradientImage) {
            oldImage.dispose();
        }
    }

    private static void fillGradient(GC gc, Rectangle rect, List<Color> gradientColors, int[] gradientPercents, boolean gradientVertical) {
        Color background = gradientColors.get(gradientColors.size() - 1);
        if (gradientColors.size() == 1) {
            if (gradientColors.get(0) != null) {
                gc.setBackground(gradientColors.get(0));
            }
            gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        } else {
            Color lastColor = gradientColors.get(0);
            int pos = gradientVertical ? rect.y : rect.x;
            int loopCount = Math.min(gradientColors.size() - 1, gradientPercents.length);
            int i = 0;
            while (i < loopCount) {
                gc.setForeground(lastColor);
                lastColor = gradientColors.get(i + 1);
                if (lastColor == null) {
                    lastColor = background;
                }
                gc.setBackground(lastColor);
                int grpercent = gradientPercents[i];
                if (gradientVertical) {
                    int gradientHeight = grpercent * rect.height / 100 - (pos - rect.y);
                    gc.fillGradientRectangle(rect.x, pos, rect.width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = grpercent * rect.width / 100 - (pos - rect.x);
                    gc.fillGradientRectangle(pos, rect.y, gradientWidth, rect.height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (gradientVertical && pos < rect.height) {
                gc.setBackground(background);
                gc.fillRectangle(rect.x, pos, rect.width, rect.height - pos);
            }
            if (!gradientVertical && pos < rect.width) {
                gc.setBackground(background);
                gc.fillRectangle(pos, rect.y, rect.width - pos, rect.height);
            }
        }
    }

    private BufferedImage getBufferedImage(int width, int height, List<java.awt.Color> colors, int[] percents) {
        java.awt.Color[] colorArray = colors.toArray(new java.awt.Color[0]);
        float[] fractions = new float[percents.length + 1];
        fractions[0] = 0.0f;
        int i = 1;
        while (i <= percents.length) {
            fractions[i] = (float)percents[i - 1] / 100.0f;
            ++i;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(new Point2D.Double((double)width / 2.0, 0.0), (float)width, new Point2D.Double((double)width / 2.0, 0.0), fractions, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2.setPaint(radialGradientPaint);
        g2.fillRect(0, 0, width, height);
        return image;
    }

    private ImageData convertToSWT(BufferedImage bufferedImage) {
        int[] bufferedImageData = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, bufferedImageData.length, bufferedImageData, 0);
        return imageData;
    }
}

