/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;

public class BeanValueProperty<S, T>
extends SimpleValueProperty<S, T> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<T> valueType;

    public BeanValueProperty(PropertyDescriptor propertyDescriptor, Class<T> valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.valueType = valueType == null ? propertyDescriptor.getPropertyType() : valueType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected T doGetValue(S source) {
        return (T)BeanPropertyHelper.readProperty(source, this.propertyDescriptor);
    }

    protected void doSetValue(S source, T value) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, value);
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
        return new BeanPropertyListener<S, T, ValueDiff<? extends T>>((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected ValueDiff<T> computeDiff(T oldValue, T newValue) {
                return Diffs.createValueDiff(oldValue, newValue);
            }
        };
    }

    public String toString() {
        String s = BeanPropertyHelper.propertyName(this.propertyDescriptor);
        if (this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

