/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.e4.ui.internal.workbench.E4XMISave;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class E4XMIResource
extends XMIResourceImpl {
    private Map<EObject, String> objectMap = new WeakHashMap<EObject, String>();
    private Set<String> knownIds = new HashSet<String>();
    static final Map<String, ObjectCreator> deprecatedTypeMappings = new HashMap<String, ObjectCreator>();

    static {
        deprecatedTypeMappings.put("OpaqueMenu", OpaqueElementUtil::createOpaqueMenu);
        deprecatedTypeMappings.put("OpaqueMenuItem", OpaqueElementUtil::createOpaqueMenuItem);
        deprecatedTypeMappings.put("OpaqueMenuSeparator", OpaqueElementUtil::createOpaqueMenuSeparator);
        deprecatedTypeMappings.put("OpaqueToolItem", OpaqueElementUtil::createOpaqueToolItem);
        deprecatedTypeMappings.put("RenderedMenu", RenderedElementUtil::createRenderedMenu);
        deprecatedTypeMappings.put("RenderedMenuItem", RenderedElementUtil::createRenderedMenuItem);
        deprecatedTypeMappings.put("RenderedToolBar", RenderedElementUtil::createRenderedToolBar);
    }

    public E4XMIResource() {
    }

    public E4XMIResource(URI uri) {
        super(uri);
    }

    public void setInternalId(EObject object, String id) {
        this.objectMap.put(object, id);
        this.knownIds.add(id);
    }

    public String getInternalId(EObject object) {
        return this.objectMap.get(object);
    }

    protected boolean useIDs() {
        return true;
    }

    private String createId() {
        return EcoreUtil.generateUUID();
    }

    private String getUniqueId() {
        String id = this.createId();
        while (this.knownIds.contains(id)) {
            id = this.createId();
        }
        return id;
    }

    public void setID(EObject eObject, String id) {
        if (id != null) {
            String internalId = this.objectMap.get(eObject);
            if (internalId != null) {
                super.setID(eObject, internalId);
            }
            this.objectMap.put(eObject, id);
            this.knownIds.add(id);
        }
        super.setID(eObject, id);
    }

    public String getID(EObject eObject) {
        if (eObject instanceof Map.Entry) {
            return null;
        }
        String id = super.getID(eObject);
        if (id != null) {
            return id;
        }
        id = this.objectMap.get(eObject);
        if (id != null) {
            this.setID(eObject, id);
            return id;
        }
        id = this.getUniqueId();
        this.setID(eObject, id);
        return id;
    }

    protected XMLHelper createXMLHelper() {
        return new XMIHelperImpl((XMLResource)this){

            public EObject createObject(EFactory eFactory, EClassifier type) {
                ObjectCreator objectCreator;
                if (MMenuFactory.INSTANCE == eFactory && type != null && type.getName() != null && (objectCreator = deprecatedTypeMappings.get(type.getName())) != null) {
                    return (EObject)objectCreator.create();
                }
                return super.createObject(eFactory, type);
            }

            public EClassifier getType(EFactory eFactory, String typeName) {
                if (deprecatedTypeMappings.containsKey(typeName)) {
                    EClass tempEClass = EcoreFactory.eINSTANCE.createEClass();
                    tempEClass.setName(typeName);
                    return tempEClass;
                }
                return super.getType(eFactory, typeName);
            }
        };
    }

    protected XMLSave createXMLSave() {
        return new E4XMISave(this.createXMLHelper());
    }

    private static interface ObjectCreator {
        public MApplicationElement create();
    }
}

