/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMarkerHelpContextProvider;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQuery;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;
import org.eclipse.ui.statushandlers.StatusManager;

public class MarkerHelpRegistry
implements IMarkerHelpRegistry {
    private Map<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> helpQueries = new HashMap<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>>();
    private List<MarkerQuery> sortedHelpQueries;
    private Map<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> resolutionQueries = new LinkedHashMap<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>>();
    private static final String ATT_HELP = "helpContextId";
    private static final String ATT_PROVIDER = "helpContextProvider";
    private static final String ATT_CLASS = "class";

    @Override
    public String getHelp(IMarker marker) {
        if (this.sortedHelpQueries == null) {
            Set<MarkerQuery> set = this.helpQueries.keySet();
            this.sortedHelpQueries = new ArrayList<MarkerQuery>(set.size());
            this.sortedHelpQueries.addAll(set);
            Collections.sort(this.sortedHelpQueries, new QueryComparator());
        }
        for (MarkerQuery query : this.sortedHelpQueries) {
            Map<MarkerQueryResult, Collection<IConfigurationElement>> resultsTable;
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = this.helpQueries.get(query)).containsKey(result)) continue;
            for (IConfigurationElement element : resultsTable.get(result)) {
                String helpContextProvider = element.getAttribute(ATT_PROVIDER);
                if (helpContextProvider == null) {
                    return element.getAttribute(ATT_HELP);
                }
                try {
                    String res;
                    IMarkerHelpContextProvider provider = (IMarkerHelpContextProvider)element.createExecutableExtension(ATT_PROVIDER);
                    if (!provider.hasHelpContextForMarker(marker) || (res = provider.getHelpContextForMarker(marker)) == null) continue;
                    return res;
                }
                catch (CoreException e) {
                    Policy.handle(e);
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasResolutions(IMarker marker) {
        for (Map.Entry<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> entry : this.resolutionQueries.entrySet()) {
            Map<MarkerQueryResult, Collection<IConfigurationElement>> resultsTable;
            MarkerQuery query = entry.getKey();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = entry.getValue()).containsKey(result)) continue;
            for (IConfigurationElement element : resultsTable.get(result)) {
                if (!this.hasResolution(marker, element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasResolution(IMarker marker, IConfigurationElement element) {
        IMarkerResolutionGenerator generator = null;
        if (Platform.getBundle((String)element.getContributor().getName()).getState() == 32) {
            try {
                generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
            if (generator != null) {
                if (generator instanceof IMarkerResolutionGenerator2) {
                    if (((IMarkerResolutionGenerator2)generator).hasResolutions(marker)) {
                        return true;
                    }
                } else {
                    IMarkerResolution[] resolutions = generator.getResolutions(marker);
                    if (resolutions == null) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Failure in " + generator.getClass().getName() + " from plugin " + element.getContributor().getName() + ": getResolutions(IMarker) must not return null", null), 1);
                        return false;
                    }
                    if (resolutions.length > 0) {
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        for (Map.Entry<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> resolutionQueryEntry : this.resolutionQueries.entrySet()) {
            Map<MarkerQueryResult, Collection<IConfigurationElement>> resultsTable;
            Map.Entry<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> entry = resolutionQueryEntry;
            MarkerQuery query = entry.getKey();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = entry.getValue()).containsKey(result)) continue;
            for (IConfigurationElement element : resultsTable.get(result)) {
                IMarkerResolutionGenerator generator = null;
                try {
                    generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
                    IMarkerResolution[] res = generator.getResolutions(marker);
                    if (res != null) {
                        IMarkerResolution[] iMarkerResolutionArray = res;
                        int n = res.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarkerResolution generatedResolution = iMarkerResolutionArray[n2];
                            resolutions.add(generatedResolution);
                            ++n2;
                        }
                        continue;
                    }
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Failure in " + generator.getClass().getName() + " from plugin " + element.getContributor().getName() + ": getResolutions(IMarker) must not return null", null), 1);
                }
                catch (CoreException e) {
                    Policy.handle(e);
                }
            }
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    public void addHelpQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.helpQueries, query, result, element);
    }

    public void addResolutionQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.resolutionQueries, query, result, element);
    }

    private void addQuery(Map<MarkerQuery, Map<MarkerQueryResult, Collection<IConfigurationElement>>> table, MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        Map<MarkerQueryResult, Collection<IConfigurationElement>> results = table.get(query);
        if (results == null) {
            results = new HashMap<MarkerQueryResult, Collection<IConfigurationElement>>();
            table.put(query, results);
        }
        if (results.containsKey(result)) {
            Collection<IConfigurationElement> currentElements = results.get(result);
            currentElements.add(element);
        } else {
            HashSet<IConfigurationElement> elements = new HashSet<IConfigurationElement>();
            elements.add(element);
            results.put(result, elements);
        }
    }

    private static class QueryComparator
    implements Comparator<MarkerQuery> {
        private QueryComparator() {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof QueryComparator;
        }

        @Override
        public int compare(MarkerQuery q1, MarkerQuery q2) {
            int size2;
            int size1 = q1.getAttributes().length;
            if (size1 > (size2 = q2.getAttributes().length)) {
                return -1;
            }
            if (size1 == size2) {
                return 0;
            }
            return 1;
        }
    }
}

