/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.variables;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.util.internal.pde.TargetPlatformClasspathFile;

public class TargletContainerClasspath
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String containerID) throws CoreException {
        return TargletContainerClasspath.getClasspath(containerID);
    }

    public static String getClasspath(String containerID) throws CoreException {
        Profile profile;
        StringBuilder builder = new StringBuilder();
        TargletContainerDescriptor descriptor = TargletContainerDescriptorManager.getInstance().getDescriptor(containerID, (IProgressMonitor)new NullProgressMonitor());
        if (descriptor != null && (profile = descriptor.getWorkingProfile()) != null) {
            IFileArtifactRepository artifactRepository = profile.getBundlePool().getFileArtifactRepository();
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()))) {
                for (IArtifactKey artifactKey : iu.getArtifacts()) {
                    if (!"osgi.bundle".equals(artifactKey.getClassifier()) || artifactKey.getId().endsWith(".source")) continue;
                    File file = artifactRepository.getArtifactFile(artifactKey);
                    TargetPlatformClasspathFile.appendBundleClasspath((StringBuilder)builder, (File)file);
                }
            }
        }
        return builder.toString();
    }
}

