/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IResourceID;
import org.eclipse.ecf.core.identity.Namespace;

public class URIID
extends BaseID
implements IResourceID {
    private static final long serialVersionUID = 7328962407044918278L;
    private final URI uri;

    public URIID(Namespace namespace, URI uri) {
        super(namespace);
        Assert.isNotNull((Object)uri);
        this.uri = uri;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (this == o) {
            return 0;
        }
        if (!this.getClass().equals(o.getClass())) {
            return Integer.MIN_VALUE;
        }
        return this.uri.compareTo(((URIID)o).uri);
    }

    protected boolean namespaceEquals(BaseID o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.uri.equals(((URIID)o).uri);
    }

    protected String namespaceGetName() {
        return this.uri.toString();
    }

    protected int namespaceHashCode() {
        return this.uri.hashCode();
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return "URIID [uri=" + this.uri + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class URIIDNamespace
    extends Namespace {
        private static final long serialVersionUID = 115165512542491014L;

        public URIIDNamespace(String name, String desc) {
            super(name, desc);
        }

        public URIIDNamespace() {
            super(URIID.class.getName(), "URIID Namespace");
        }

        @Override
        public ID createInstance(Object[] parameters) throws IDCreateException {
            try {
                String init = this.getInitStringFromExternalForm(parameters);
                if (init != null) {
                    return new URIID(this, new URI(init));
                }
                if (parameters[0] instanceof URI) {
                    return new URIID(this, (URI)parameters[0]);
                }
                if (parameters[0] instanceof String) {
                    return new URIID(this, new URI((String)parameters[0]));
                }
                throw new IDCreateException("Cannot create URIID");
            }
            catch (Exception e) {
                throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", e);
            }
        }

        @Override
        public String getScheme() {
            return "uri";
        }

        @Override
        public Class<?>[][] getSupportedParameterTypes() {
            return new Class[][]{{String.class}, {URI.class}};
        }
    }
}

