/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.eclipse.ui.internal.ide.misc.StringFileInfoMatcher;

class FilterTypeUtil {
    static String ID = "id";
    static String TARGET = "target";
    static String MODE = "mode";
    static String ARGUMENTS = "arguments";
    static String INHERITABLE = "inheritable";
    static String[] columnNames = new String[]{MODE, TARGET, INHERITABLE};

    static String[] getModes() {
        return new String[]{NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_includeOnly, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_excludeAll, null)};
    }

    public static void setValue(FilterCopy filter, String property, Object value) {
        int type;
        if (property.equals(ID)) {
            IFilterMatcherDescriptor descriptor;
            if (value instanceof Integer) {
                int selection = (Integer)value;
                descriptor = FilterTypeUtil.getDescriptorFromIndex(selection);
            } else {
                descriptor = FilterTypeUtil.getDescriptorByName((String)value);
            }
            if (descriptor != null) {
                filter.setId(descriptor.getId());
            }
        }
        if (property.equals(MODE)) {
            int selection = (Integer)value;
            type = filter.getType() & 0xFFFFFFFC;
            if (selection == 0) {
                filter.setType(type | 1);
            } else {
                filter.setType(type | 2);
            }
        }
        if (property.equals(TARGET)) {
            int selection = (Integer)value;
            type = filter.getType() & 0xFFFFFFF3;
            if (selection == 0) {
                filter.setType(type | 4);
            }
            if (selection == 1) {
                filter.setType(type | 8);
            }
            if (selection == 2) {
                filter.setType(type | 4 | 8);
            }
        }
        if (property.equals(INHERITABLE)) {
            int type2 = filter.getType() & 0xFFFFFFEF;
            if (((Boolean)value).booleanValue()) {
                filter.setType(type2 | 0x10);
            } else {
                filter.setType(type2);
            }
        }
        if (property.equals(ARGUMENTS)) {
            filter.setArguments(value.equals("") ? null : value);
        }
    }

    static IFilterMatcherDescriptor getDescriptor(String id) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(id)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    static int getDescriptorIndex(String id) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static Object getValue(UIResourceFilterDescription filter, String property) {
        if (property.equals(ID)) {
            String id = filter.getFileInfoMatcherDescription().getId();
            int index = FilterTypeUtil.getDescriptorIndex(id);
            return new Integer(index);
        }
        if (property.equals(MODE)) {
            if ((filter.getType() & 1) != 0) {
                return new Integer(0);
            }
            return new Integer(1);
        }
        if (property.equals(TARGET)) {
            boolean includeFolders;
            boolean includeFiles = (filter.getType() & 4) != 0;
            boolean bl = includeFolders = (filter.getType() & 8) != 0;
            if (includeFiles && includeFolders) {
                return new Integer(2);
            }
            if (includeFiles) {
                return new Integer(0);
            }
            if (includeFolders) {
                return new Integer(1);
            }
        }
        if (property.equals(INHERITABLE)) {
            return new Boolean((filter.getType() & 0x10) != 0);
        }
        if (property.equals(ARGUMENTS)) {
            return filter.getFileInfoMatcherDescription().getArguments() != null ? filter.getFileInfoMatcherDescription().getArguments() : "";
        }
        return null;
    }

    static String[] getTargets() {
        return new String[]{NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_files, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_folders, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_filesAndFolders, null)};
    }

    static String[] getFilterNames(boolean groupOnly) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        FilterTypeUtil.sortDescriptors(descriptors);
        LinkedList<String> names = new LinkedList<String>();
        int i = 0;
        while (i < descriptors.length) {
            if (!descriptors[i].getId().equals("org.eclipse.core.resources.regexFilterMatcher") && !descriptors[i].getId().equals(StringFileInfoMatcher.ID)) {
                boolean isGroup;
                boolean bl = isGroup = descriptors[i].getArgumentType().equals("filterMatcher") || descriptors[i].getArgumentType().equals("filterMatchers");
                if (isGroup == groupOnly) {
                    names.add(descriptors[i].getName());
                }
            }
            ++i;
        }
        return names.toArray(new String[0]);
    }

    private static void sortDescriptors(IFilterMatcherDescriptor[] descriptors) {
        Arrays.sort(descriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (((IFilterMatcherDescriptor)arg0).getId().equals(FileInfoAttributesMatcher.ID)) {
                    return -1;
                }
                if (((IFilterMatcherDescriptor)arg1).getId().equals(FileInfoAttributesMatcher.ID)) {
                    return 1;
                }
                return ((IFilterMatcherDescriptor)arg0).getId().compareTo(((IFilterMatcherDescriptor)arg1).getId());
            }
        });
    }

    static String getDefaultFilterID() {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        FilterTypeUtil.sortDescriptors(descriptors);
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getArgumentType().equals("string")) {
                return descriptors[i].getId();
            }
            ++i;
        }
        return descriptors[0].getId();
    }

    static IFilterMatcherDescriptor getDescriptorFromIndex(int index) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        return descriptors[index];
    }

    static IFilterMatcherDescriptor getDescriptorByName(String name) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(name)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    FilterTypeUtil() {
    }
}

