/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserURIHandlerImpl
extends URIHandlerImpl {
    private static final String FEATURE_PATTERN_SUFFIX = "='([^']*)'";
    private static final Pattern CLASS_PATTERN = Pattern.compile("class='([^']*)'");

    public boolean canHandle(URI uri) {
        return SetupContext.isUserScheme(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.createInputStream(normalizedURI, options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.createOutputStream(normalizedURI, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        uriConverter.delete(normalizedURI, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.contentDescription(normalizedURI, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.exists(normalizedURI, options) || this.create(uri, normalizedURI);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.getAttributes(normalizedURI, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        uriConverter.setAttributes(normalizedURI, attributes, options);
    }

    private boolean create(URI uri, URI normalizedURI) {
        String query = uri.query();
        if (query != null) {
            EObject instance;
            Resource resource = SetupCoreUtil.createResourceSet().createResource(normalizedURI);
            String decodedQuery = URI.decode((String)query);
            Matcher classMatcher = CLASS_PATTERN.matcher(decodedQuery);
            URI classURI = URI.createURI((String)(classMatcher.find() ? classMatcher.group(1) : "http://www.eclipse.org/oomph/setup/1.0#//Project"));
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(classURI.trimFragment().toString());
            if (ePackage == null) {
                throw new IllegalArgumentException("No package registered for " + classURI);
            }
            EObject eObject = ePackage.eResource().getEObject(classURI.fragment());
            if (eObject instanceof EClass) {
                EClass eClass = (EClass)eObject;
                instance = EcoreUtil.create((EClass)eClass);
                for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                    Pattern pattern;
                    Matcher matcher;
                    if (eAttribute.isMany() || !(matcher = (pattern = Pattern.compile(String.valueOf(eAttribute.getName()) + FEATURE_PATTERN_SUFFIX)).matcher(decodedQuery)).find()) continue;
                    String value = matcher.group(1);
                    instance.eSet((EStructuralFeature)eAttribute, EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)value));
                }
                if (instance instanceof ProductCatalog) {
                    ProductCatalog productCatalog = (ProductCatalog)instance;
                    EList setupTasks = productCatalog.getSetupTasks();
                    InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
                    installationTask.setID("installation");
                    setupTasks.add((Object)installationTask);
                }
            } else {
                throw new IllegalArgumentException("No class registered for " + classURI);
            }
            resource.getContents().add((Object)instance);
            return UserURIHandlerImpl.saveResource(resource);
        }
        if (SetupContext.USER_SETUP_URI.equals(uri)) {
            User user = SetupContext.createUser();
            Resource resource = SetupCoreUtil.createResourceSet().createResource(normalizedURI);
            resource.getContents().add((Object)user);
            return UserURIHandlerImpl.saveResource(resource);
        }
        return false;
    }

    private static boolean saveResource(Resource resource) {
        try {
            resource.save(null);
            return true;
        }
        catch (IOException ex) {
            SetupCorePlugin.INSTANCE.log(ex);
            return false;
        }
    }
}

