/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.NetworkConnectionsDialog;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleSearchField;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.SpriteAnimator;
import org.eclipse.oomph.ui.StackComposite;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.ToolBar;

public class SimpleProductPage
extends SimpleInstallerPage
implements SearchField.FilterHandler {
    private static final int MAX_DESCRIPTION_LENGTH = 120;
    private static final String PRODUCT_PREFIX = "product://";
    private final SetupWizard.SelectionMemento selectionMemento;
    private SimpleSearchField searchField;
    private ToolBar buttonBar;
    private CatalogSelector catalogSelector;
    private StackComposite stackComposite;
    private SpriteIndexLoader indexLoader;
    private ProductList productList;

    public SimpleProductPage(Composite parent, SimpleInstallerDialog dialog, SetupWizard.SelectionMemento selectionMemento) {
        super(parent, dialog, false);
        this.selectionMemento = selectionMemento;
    }

    protected void createContent(final Composite container) {
        GridLayout searchLayout = UIUtil.createGridLayout((int)2);
        searchLayout.horizontalSpacing = 0;
        Composite searchComposite = new Composite(container, 0);
        searchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchComposite.setLayout((Layout)searchLayout);
        this.searchField = new SimpleSearchField(searchComposite, this){

            protected void finishFilter() {
                SimpleProductPage.this.setFocus();
            }
        };
        Point defaultSearchFieldSize = this.searchField.computeSize(-1, -1);
        this.searchField.setLayoutData(GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(-1, defaultSearchFieldSize.y + 10).create());
        this.buttonBar = new ToolBar(searchComposite, 0x820000);
        this.buttonBar.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).exclude(true).create());
        CatalogManager catalogManager = this.installer.getCatalogManager();
        this.catalogSelector = new CatalogSelector(catalogManager, true);
        this.stackComposite = new StackComposite(container, 0);
        this.stackComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(0, 4).create());
        this.stackComposite.setBackgroundMode(2);
        this.stackComposite.setBackground(AbstractSimpleDialog.COLOR_WHITE);
        this.indexLoader = new SpriteIndexLoader((Composite)this.stackComposite);
        this.productList = UIUtil.isBrowserAvailable() && "browser".equals(PropertiesUtil.getProperty((String)"oomph.product.list")) ? new ProductList.BrowserProductList(this, this.stackComposite, this.catalogSelector) : new ProductList.CompositeProductList(this, this.stackComposite);
        this.stackComposite.setTopControl((Control)this.indexLoader.getAnimator());
        this.installer.setIndexLoader(this.indexLoader);
        this.installer.setIndexLoadedAction(new Runnable(){
            private final AtomicBoolean selectionMementoTried = new AtomicBoolean();

            public void run() {
                SimpleProductPage.this.handleFilter("");
                UIUtil.asyncExec((Control)container, (Runnable)new Runnable(){

                    public void run() {
                        if (!selectionMementoTried.getAndSet(true) && SimpleProductPage.this.applySelectionMemento()) {
                            return;
                        }
                    }
                });
            }
        });
    }

    public void aboutToHide() {
        super.aboutToHide();
        this.productList.reset();
        this.setFocus();
    }

    public boolean setFocus() {
        return this.productList.getControl().setFocus();
    }

    public void handleFilter(String filter) {
        boolean noFilter;
        String filterText = this.searchField.getFilterText();
        if (filterText.length() != 0) {
            filter = filterText;
        }
        if (!(noFilter = StringUtil.isEmpty((String)filter))) {
            filter = filter.toLowerCase();
        }
        ArrayList<Product> products = new ArrayList<Product>();
        for (Scope scope : this.catalogSelector.getSelectedCatalogs()) {
            ProductCatalog productCatalog;
            if (!(scope instanceof ProductCatalog) || !SimpleProductPage.isIncluded(productCatalog = (ProductCatalog)scope)) continue;
            for (Product product : productCatalog.getProducts()) {
                if (!SimpleProductPage.isIncluded(product) || !noFilter && !SimpleProductPage.isFiltered(product.getName(), filter) && !SimpleProductPage.isFiltered(product.getLabel(), filter) && !SimpleProductPage.isFiltered(product.getDescription(), filter)) continue;
                products.add(product);
            }
        }
        this.productList.setInput(products);
    }

    private boolean applySelectionMemento() {
        ResourceSet resourceSet;
        EObject object;
        URI uri = this.selectionMemento.getProductVersion();
        if (uri != null && (object = (resourceSet = this.getResourceSet()).getEObject(uri, true)) instanceof ProductVersion) {
            ProductVersion productVersion = (ProductVersion)object;
            Product product = productVersion.getProduct();
            this.productSelected(product);
            return true;
        }
        return false;
    }

    protected final void productSelected(Product product) {
        this.indexLoader.awaitIndexLoad();
        this.dialog.productSelected(product);
    }

    private static String removeLinks(String description) {
        return description.replaceAll("</?a[^>]*>", "");
    }

    private static int findFirstDot(String description) {
        boolean inElement = false;
        int i = 0;
        while (i < description.length()) {
            char c = description.charAt(i);
            if (inElement) {
                if (c == '>') {
                    inElement = false;
                }
            } else if (c == '<') {
                inElement = true;
            } else if (c == '.') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isFiltered(String string, String filter) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(filter);
    }

    public static String renderProduct(Product product, boolean large) {
        String productHtml;
        int dot;
        String description;
        String imageURI = SetupWizard.getImageURI((Product)product);
        String label = product.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = product.getName();
        }
        description = (description = product.getDescription()) != null ? ((dot = SimpleProductPage.findFirstDot(description)) == -1 ? String.valueOf(description) + "." : description.substring(0, dot + 1)) : "";
        String string = productHtml = large ? SimpleInstallerDialog.getProductTemplateLarge() : SimpleInstallerDialog.getProductTemplate();
        if (!large) {
            description = StringUtil.shorten((String)description, (int)120, (boolean)true);
            description = SimpleProductPage.removeLinks(description);
            String productLink = PRODUCT_PREFIX + product.getProductCatalog().getName() + "/" + product.getName();
            productHtml = productHtml.replace("%PRODUCT_LINK%", productLink);
        }
        productHtml = productHtml.replace("%PRODUCT_ICON_SRC%", imageURI);
        productHtml = productHtml.replace("%PRODUCT_TITLE%", label);
        productHtml = productHtml.replace("%PRODUCT_DESCRIPTION%", description);
        return productHtml;
    }

    public static final class ProductComposite
    extends Composite
    implements MouseTrackListener,
    MouseListener {
        public static final int BORDER = 17;
        private static final int VERTICAL_SPACE = 10;
        private static final Color COLOR_WHITE = UIUtil.getDisplay().getSystemColor(1);
        private static final Color COLOR_TITLE = UIUtil.getEclipseThemeColor();
        private static final Color COLOR_DESCRIPTION = SetupInstallerPlugin.getColor((int)85, (int)85, (int)85);
        private static final Color COLOR_SELECTION = SetupInstallerPlugin.getColor((int)174, (int)187, (int)221);
        private static final Font FONT_TITLE = SetupInstallerPlugin.getFont((Font)SimpleInstallerDialog.getDefaultFont(), (Object)URI.createURI((String)"font:///+4/bold"));
        private static final Font FONT_DESCRIPTION = SimpleInstallerDialog.getFont(1, "normal");
        private final ProductList.CompositeProductList list;
        private Product product;
        private Logo logo;
        private Label title;
        private Label description;
        private int contentHeight;

        public ProductComposite(Composite parent, ProductList.CompositeProductList list, final Product product) {
            super(parent, 0);
            this.list = list;
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 17;
            gridLayout.marginHeight = 17;
            gridLayout.horizontalSpacing = 17;
            gridLayout.verticalSpacing = 10;
            this.setLayout((Layout)gridLayout);
            this.setBackground(this.getDisplay().getSystemColor(1));
            this.listenToMouse((Control)this);
            this.logo = new Logo(this);
            this.logo.setLayoutData(new GridData(16384, 128, false, false, 1, 2));
            this.listenToMouse((Control)this.logo);
            this.title = new Label((Composite)this, 0);
            this.title.setForeground(COLOR_TITLE);
            this.title.setFont(FONT_TITLE);
            this.title.setLayoutData((Object)new GridData(4, 128, true, false));
            this.listenToMouse((Control)this.title);
            this.description = new Label((Composite)this, 64);
            this.description.setForeground(COLOR_DESCRIPTION);
            this.description.setFont(FONT_DESCRIPTION);
            this.description.setLayoutData((Object)new GridData(4, 128, true, false));
            this.listenToMouse((Control)this.description);
            this.description.addControlListener((ControlListener)new ControlAdapter(){
                private boolean settingProduct;

                public void controlResized(ControlEvent e) {
                    if (!this.settingProduct) {
                        try {
                            this.settingProduct = true;
                            ProductComposite.this.setProduct(product);
                        }
                        finally {
                            this.settingProduct = false;
                        }
                    }
                }
            });
            this.title.setText("Ag");
            int titleHeight = this.title.computeSize((int)-1, (int)-1).y;
            this.description.setText("Ag\nAg");
            int descriptionHeight = this.description.computeSize((int)-1, (int)-1).y;
            this.contentHeight = titleHeight + 10 + descriptionHeight;
        }

        public Product getProduct() {
            return this.product;
        }

        public void setProduct(Product product) {
            this.product = product;
            if (product != null) {
                Image image = SetupWizard.getImage((Product)product);
                this.logo.setImage(image);
                this.title.setText(product.getLabel());
                GC gc = new GC((Drawable)this.description);
                try {
                    int width = this.description.getSize().x - 8;
                    int lines = this.list != null ? 2 : 8;
                    String text = ProductComposite.shorten(gc, width, lines, product.getDescription());
                    this.description.setText(text);
                    this.description.getParent().layout();
                }
                finally {
                    gc.dispose();
                }
            }
        }

        public int getTotalHeight() {
            return this.contentHeight + 34;
        }

        public void mouseEnter(MouseEvent e) {
            if (this.list != null) {
                this.setBackground(COLOR_SELECTION);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (this.list != null) {
                this.setBackground(COLOR_WHITE);
            }
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (this.list != null && this.product != null && this.getClientArea().contains(e.x, e.y)) {
                this.list.productSelected(this.product);
            }
        }

        private void listenToMouse(Control control) {
            control.addMouseTrackListener((MouseTrackListener)this);
            control.addMouseListener((MouseListener)this);
        }

        private static String shorten(GC gc, int width, int lines, String html) {
            String[] words;
            String plain = StringUtil.isEmpty((String)html) ? "No description available." : UIUtil.stripHTML((String)html);
            StringBuilder builder = new StringBuilder();
            int lineWidth = 0;
            int lineCount = 1;
            String[] stringArray = words = plain.split(" ");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                int wordWidth = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)word)).append((String)" ").toString()).x;
                if ((lineWidth += wordWidth) > width) {
                    if (++lineCount > lines) {
                        int length = builder.length();
                        builder.replace(length - 1, length, "...");
                        break;
                    }
                    lineWidth = wordWidth;
                }
                builder.append(word);
                builder.append(" ");
                ++n2;
            }
            return builder.toString();
        }

        public static final class Logo
        extends Composite
        implements PaintListener {
            private static final int HEIGHT = 64;
            private Image image;
            private int imageX;
            private int imageY;

            public Logo(Composite parent) {
                super(parent, 0x20000000);
                this.addPaintListener(this);
                this.setSize(64, 64);
            }

            public Image getImage() {
                return this.image;
            }

            public void setImage(Image image) {
                this.image = image;
                ImageData imageData = image.getImageData();
                this.imageX = (64 - imageData.width) / 2;
                this.imageY = (64 - imageData.height) / 2;
            }

            public void paintControl(PaintEvent e) {
                Rectangle rect = this.getClientArea();
                GC gc = e.gc;
                int oldAntialias = gc.getAntialias();
                gc.setAntialias(1);
                Color oldBackground = gc.getBackground();
                gc.setBackground(COLOR_PAGE_BORDER);
                gc.fillOval(0, 0, rect.width, rect.height);
                gc.drawImage(this.image, this.imageX, this.imageY);
                gc.setBackground(oldBackground);
                gc.setAntialias(oldAntialias);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ProductList {
        private final SimpleProductPage page;

        public ProductList(SimpleProductPage page) {
            this.page = page;
        }

        public abstract Control getControl();

        public abstract void setInput(List<Product> var1);

        public abstract void reset();

        protected final void productSelected(Product product) {
            this.page.productSelected(product);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BrowserProductList
        extends ProductList {
            private final Browser browser;

            public BrowserProductList(SimpleProductPage page, StackComposite stackComposite, final CatalogSelector catalogSelector) {
                super(page);
                this.browser = new Browser((Composite)stackComposite, 0);
                this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                    public void changing(LocationEvent event) {
                        String url = event.location;
                        if (!"about:blank".equals(url)) {
                            if (url.startsWith(SimpleProductPage.PRODUCT_PREFIX)) {
                                url = url.substring(SimpleProductPage.PRODUCT_PREFIX.length());
                                BrowserProductList.this.productSelected(url, catalogSelector);
                            } else {
                                OS.INSTANCE.openSystemBrowser(url);
                            }
                            event.doit = false;
                        }
                    }
                });
            }

            @Override
            public Control getControl() {
                return this.browser;
            }

            @Override
            public void setInput(List<Product> products) {
                StringBuilder productsBuilder = new StringBuilder();
                for (Product product : products) {
                    productsBuilder.append(SimpleProductPage.renderProduct(product, false));
                }
                String productPageHTML = SimpleInstallerDialog.getProductTemplate();
                String simpleInstallerHTML = SimpleInstallerDialog.getPageTemplate();
                productPageHTML = simpleInstallerHTML.replace("%CONTENT%", productsBuilder.toString());
                this.browser.setText(productPageHTML, true);
            }

            @Override
            public void reset() {
                this.browser.setText(this.browser.getText());
            }

            private void productSelected(String url, CatalogSelector catalogSelector) {
                int lastSlash = url.lastIndexOf(47);
                String catalogName = url.substring(0, lastSlash);
                String productName = url.substring(lastSlash + 1);
                for (Scope scope : catalogSelector.getSelectedCatalogs()) {
                    ProductCatalog productCatalog;
                    if (!(scope instanceof ProductCatalog) || !catalogName.equals((productCatalog = (ProductCatalog)scope).getName())) continue;
                    for (Product product : productCatalog.getProducts()) {
                        if (!productName.equals(product.getName())) continue;
                        this.productSelected(product);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class CompositeProductList
        extends ProductList {
            public static final int SPACE = 3;
            private final ScrolledComposite scrolledComposite;
            private final Composite scrolledContent;
            private List<Product> products;

            public CompositeProductList(SimpleProductPage page, StackComposite stackComposite) {
                super(page);
                this.scrolledComposite = new ScrolledComposite((Composite)stackComposite, 512);
                this.scrolledComposite.setExpandHorizontal(true);
                this.scrolledComposite.setExpandVertical(true);
                GridLayout gridLayout = new GridLayout(1, false);
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                gridLayout.verticalSpacing = 3;
                this.scrolledContent = new Composite((Composite)this.scrolledComposite, 0);
                this.scrolledContent.setLayout((Layout)gridLayout);
                this.scrolledContent.setBackground(COLOR_PAGE_BORDER);
                this.scrolledContent.addListener(37, new Listener(){

                    public void handleEvent(Event event) {
                        Listener[] selectionListeners;
                        int value = event.count * 8;
                        ScrollBar vbar = CompositeProductList.this.scrolledComposite.getVerticalBar();
                        vbar.setSelection(vbar.getSelection() - value);
                        Listener[] listenerArray = selectionListeners = vbar.getListeners(13);
                        int n = selectionListeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Listener listener = listenerArray[n2];
                            listener.handleEvent(event);
                            ++n2;
                        }
                    }
                });
                this.scrolledComposite.setContent((Control)this.scrolledContent);
            }

            @Override
            public Control getControl() {
                return this.scrolledComposite;
            }

            @Override
            public void setInput(List<Product> products) {
                this.products = products;
                Control[] children = this.scrolledContent.getChildren();
                int i = children.length - 1;
                while (i >= 0) {
                    children[i].dispose();
                    --i;
                }
                int listHeight = 0;
                if (products != null) {
                    Cursor handCursor = this.scrolledContent.getDisplay().getSystemCursor(21);
                    for (Product product : products) {
                        ProductComposite productComposite = new ProductComposite(this.scrolledContent, this, product);
                        int height = productComposite.getTotalHeight();
                        if (listHeight != 0) {
                            listHeight += 3;
                        }
                        listHeight += height;
                        GridData gridData = new GridData(4, 4, true, false);
                        gridData.minimumHeight = height;
                        gridData.heightHint = height;
                        productComposite.setLayoutData(gridData);
                        productComposite.setCursor(handCursor);
                    }
                }
                this.scrolledComposite.setMinHeight(listHeight);
                this.scrolledContent.layout();
            }

            @Override
            public void reset() {
                this.setInput(this.products);
            }
        }
    }

    private final class SpriteIndexLoader
    extends SetupWizard.IndexLoader {
        private final SpriteAnimator animator;

        public SpriteIndexLoader(Composite parent) {
            this.animator = new SpriteAnimator(parent, 0, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/progress_sprite.png"), 8, 4, 20L);
        }

        public SpriteAnimator getAnimator() {
            return this.animator;
        }

        public void loadIndex(final ResourceSet resourceSet, final URI ... uris) {
            SimpleProductPage.this.searchField.setEnabled(false);
            SimpleProductPage.this.productList.reset();
            SimpleProductPage.this.stackComposite.setTopControl((Control)this.animator);
            this.animator.start(1, this.animator.getImages().length - 1);
            NullProgressMonitor monitor = new NullProgressMonitor();
            Thread thread = new Thread((IProgressMonitor)monitor){
                private final /* synthetic */ IProgressMonitor val$monitor;
                {
                    this.val$monitor = iProgressMonitor;
                }

                public void run() {
                    block7: {
                        try {
                            SpriteIndexLoader.this.loadIndex(resourceSet, uris, this.val$monitor);
                        }
                        catch (InvocationTargetException ex) {
                            if (!SpriteIndexLoader.this.animator.isDisposed()) {
                                SetupInstallerPlugin.INSTANCE.log(ex.getCause());
                            }
                            UIUtil.asyncExec((Runnable)new Runnable(){

                                public void run() {
                                    SimpleProductPage.this.stackComposite.setTopControl(SimpleProductPage.this.productList.getControl());
                                    SimpleProductPage.this.setFocus();
                                    CatalogManager catalogManager = SimpleProductPage.this.catalogSelector.getCatalogManager();
                                    Index index = catalogManager.getIndex();
                                    if (index == null) {
                                        int answer = new MessageDialog(SimpleProductPage.this.getShell(), "Network Problem", null, "The catalog could not be loaded. Please ensure that you have network access and, if needed, have configured your network proxy.", 1, new String[]{"Retry", "Configure Network Proxy" + StringUtil.HORIZONTAL_ELLIPSIS, "Exit"}, 0).open();
                                        switch (answer) {
                                            case 0: {
                                                ((SpriteIndexLoader)(this).SpriteIndexLoader.this).SimpleProductPage.this.installer.reloadIndex();
                                                return;
                                            }
                                            case 1: {
                                                new NetworkConnectionsDialog(SimpleProductPage.this.getShell()).open();
                                                ((SpriteIndexLoader)(this).SpriteIndexLoader.this).SimpleProductPage.this.installer.reloadIndex();
                                                return;
                                            }
                                        }
                                        ((SpriteIndexLoader)(this).SpriteIndexLoader.this).SimpleProductPage.this.dialog.exitSelected();
                                        return;
                                    }
                                    SimpleProductPage.this.searchField.setEnabled(true);
                                }
                            });
                            SpriteIndexLoader.this.animator.stop();
                            break block7;
                        }
                        catch (InterruptedException interruptedException) {
                            try {}
                            catch (Throwable throwable) {
                                UIUtil.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                                SpriteIndexLoader.this.animator.stop();
                                throw throwable;
                            }
                            UIUtil.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                            SpriteIndexLoader.this.animator.stop();
                            break block7;
                        }
                        UIUtil.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                        SpriteIndexLoader.this.animator.stop();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }

        protected void waiting() {
            SimpleProductPage.this.stackComposite.setTopControl((Control)this.animator);
            this.animator.start(1, this.animator.getImages().length - 1);
        }

        protected void finishedWaiting() {
            Control control = SimpleProductPage.this.productList.getControl();
            SimpleProductPage.this.stackComposite.setTopControl(control);
        }

        protected boolean shouldReload(EClass eClass) {
            return eClass == SetupPackage.Literals.INDEX || eClass == SetupPackage.Literals.PRODUCT_CATALOG || eClass == SetupPackage.Literals.PRODUCT;
        }
    }
}

