/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.ui.ToggleCommandHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class PersistentButton
extends Button {
    private final Persistence persistence;

    public PersistentButton(Composite parent, int style, boolean defaultSelection, Persistence persistence) {
        super(parent, style);
        this.persistence = persistence;
        super.setSelection(persistence != null ? persistence.load(defaultSelection) : defaultSelection);
    }

    public void setSelection(boolean selection) {
        super.setSelection(selection);
        if (this.persistence != null) {
            this.persistence.save(selection);
        }
    }

    protected void checkSubclass() {
    }

    public static final class DialogSettingsPersistence
    extends Persistence {
        private final IDialogSettings dialogSettings;
        private final String key;

        public DialogSettingsPersistence(IDialogSettings dialogSettings, String key) {
            this.dialogSettings = dialogSettings;
            this.key = key;
        }

        public IDialogSettings getDialogSettings() {
            return this.dialogSettings;
        }

        public String getKey() {
            return this.key;
        }

        protected boolean load(boolean defaultSelection) {
            String value = this.dialogSettings.get(this.key);
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return defaultSelection;
        }

        protected void save(boolean selection) {
            this.dialogSettings.put(this.key, selection);
        }
    }

    public static abstract class Persistence {
        protected abstract boolean load(boolean var1);

        protected abstract void save(boolean var1);
    }

    public static final class ToggleCommandPersistence
    extends Persistence {
        private final String commandID;

        public ToggleCommandPersistence(String commandID) {
            this.commandID = commandID;
        }

        public String getCommandID() {
            return this.commandID;
        }

        protected boolean load(boolean defaultSelection) {
            return ToggleCommandHandler.getToggleState(this.commandID);
        }

        protected void save(boolean selection) {
            ToggleCommandHandler.setToggleState(this.commandID, selection);
        }
    }
}

