/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;

public class Adapters {
    public static <T> T getAdapter(Object sourceObject, Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        Object result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            Assert.isTrue(adapter.isInstance(result));
            return result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        result = Adapters.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result != null) {
            Assert.isTrue(adapter.isInstance(result));
            return result;
        }
        return null;
    }

    private static Object queryAdapterManager(Object sourceObject, String adapterId, boolean allowActivation) {
        Object result = allowActivation ? AdapterManager.getDefault().loadAdapter(sourceObject, adapterId) : AdapterManager.getDefault().getAdapter(sourceObject, adapterId);
        return result;
    }
}

