/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccessibleObject {
    long handle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Hashtable<LONG, AccessibleObject> AccessibleObjects = new Hashtable(9);
    static final boolean DEBUG = Device.DEBUG;
    static final int ROW_ROLE = OS.GTK_VERSION >= OS.VERSION(3, 2, 0) ? 88 : ATK.atk_role_register(Converter.wcsToMbcs(null, "row", true));

    AccessibleObject(long type, long widget, Accessible accessible, boolean isLightweight) {
        this.handle = ATK.g_object_new(type, 0L);
        ATK.atk_object_initialize(this.handle, widget);
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            AccessibleObject.print("new AccessibleObject: " + this.handle + " control=" + accessible.control + " lw=" + isLightweight);
        }
    }

    static void print(String str) {
        System.out.println(str);
    }

    static int size(Collection<?> listeners) {
        return listeners == null ? 0 : listeners.size();
    }

    static AtkActionIface getActionIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface iface = new AtkActionIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkAction_do_action(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_do_action");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.doAction(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.do_action != 0L) {
            parentResult = ATK.call(iface.do_action, atkObject, index);
        }
        return parentResult;
    }

    static long atkAction_get_n_actions(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_n_actions");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getActionCount(event);
                    ++i;
                }
                return event.count;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_n_actions != 0L) {
            parentResult = ATK.call(iface.get_n_actions, atkObject);
        }
        return parentResult;
    }

    static long atkAction_get_description(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_description");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getDescription(event);
                    ++i;
                }
                if (event.result == null) {
                    return 0L;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_description != 0L) {
            parentResult = ATK.call(iface.get_description, atkObject, index);
        }
        return parentResult;
    }

    static long atkAction_get_keybinding(long atkObject, long index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_keybinding");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_keybinding != 0L) {
            parentResult = ATK.call(iface.get_keybinding, atkObject, index);
        }
        if (object != null) {
            List<AccessibleListener> listeners2;
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getKeyBinding(event);
                    ++i;
                }
                if (event.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(event.result);
                    return keybindingPtr;
                }
            }
            if ((length = AccessibleObject.size(listeners2 = accessible.accessibleListeners)) > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleListener listener = listeners2.get(i);
                    listener.getKeyboardShortcut(event);
                    ++i;
                }
                if (event.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(event.result);
                    return keybindingPtr;
                }
            }
        }
        return parentResult;
    }

    static long atkAction_get_name(long atkObject, long index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_name");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_name != 0L) {
            parentResult = ATK.call(iface.get_name, atkObject, index);
        }
        if (object != null) {
            List<AccessibleControlListener> listeners2;
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getName(event);
                    ++i;
                }
                if (event.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(event.result);
                    return actionNamePtr;
                }
            }
            if (index == 0L && (length = AccessibleObject.size(listeners2 = accessible.accessibleControlListeners)) > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners2.get(i);
                    listener.getDefaultAction(event);
                    ++i;
                }
                if (event.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(event.result);
                    return actionNamePtr;
                }
            }
        }
        return parentResult;
    }

    static AtkComponentIface getComponentIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface iface = new AtkComponentIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkComponent_get_extents(long atkObject, long x, long y, long width, long height, long coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_extents: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(x, new int[1], 4L);
        OS.memmove(y, new int[1], 4L);
        OS.memmove(width, new int[1], 4L);
        OS.memmove(height, new int[1], 4L);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_extents != 0L) {
            ATK.call(iface.get_extents, atkObject, x, y, width, height, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                OS.memmove(parentX, x, 4L);
                OS.memmove(parentY, y, 4L);
                OS.memmove(parentWidth, width, 4L);
                OS.memmove(parentHeight, height, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                    ++i;
                }
                if (coord_type == 1L) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4L);
                OS.memmove(y, new int[]{event.y}, 4L);
                OS.memmove(width, new int[]{event.width}, 4L);
                OS.memmove(height, new int[]{event.height}, 4L);
                if (DEBUG) {
                    AccessibleObject.print("--->" + event.x + "," + event.y + "," + event.width + "x" + event.height);
                }
            }
        }
        return 0L;
    }

    static long atkComponent_get_position(long atkObject, long x, long y, long coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_position, object: " + atkObject + " x: " + x + " y: " + y + " coord: " + coord_type);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(x, new int[1], 4L);
        OS.memmove(y, new int[1], 4L);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_position != 0L) {
            ATK.call(iface.get_position, atkObject, x, y, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                OS.memmove(parentX, x, 4L);
                OS.memmove(parentY, y, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                    ++i;
                }
                if (coord_type == 1L) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4L);
                OS.memmove(y, new int[]{event.y}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_get_size(long atkObject, long width, long height, long coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_size");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(width, new int[1], 4L);
        OS.memmove(height, new int[1], 4L);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_size != 0L) {
            ATK.call(iface.get_size, atkObject, width, height, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                OS.memmove(parentWidth, width, 4L);
                OS.memmove(parentHeight, height, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                    ++i;
                }
                OS.memmove(width, new int[]{event.width}, 4L);
                OS.memmove(height, new int[]{event.height}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long atkObject, long x, long y, long coord_type) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_ref_accessible_at_point: " + atkObject + " " + x + "," + y);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Accessible result;
                AccessibleObject accObj;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = (int)x;
                event.y = (int)y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChildAtPoint(event);
                    ++i;
                }
                if (event.childID == object.id) {
                    event.childID = -1;
                }
                AccessibleObject accessibleObject = accObj = (result = event.accessible) != null ? result.getAccessibleObject() : object.getChildByID(event.childID);
                if (accObj != null) {
                    return OS.g_object_ref(accObj.handle);
                }
            }
        }
        long parentResult = 0L;
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.ref_accessible_at_point != 0L) {
            parentResult = ATK.call(iface.ref_accessible_at_point, atkObject, x, y, coord_type);
        }
        return parentResult;
    }

    static AtkEditableTextIface getEditableTextIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_EDITABLE_TEXT())) {
            AtkEditableTextIface iface = new AtkEditableTextIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_EDITABLE_TEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkEditableText_set_run_attributes(long atkObject, long attrib_set, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_run_attributes");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Display display = accessible.control.getDisplay();
                long fontDesc = OS.pango_font_description_new();
                boolean createFont = false;
                TextStyle style = new TextStyle();
                String[] attributes = new String[]{};
                long current = attrib_set;
                int listLength = OS.g_slist_length(attrib_set);
                int i = 0;
                while (i < listLength) {
                    long attrPtr = OS.g_slist_data(current);
                    if (attrPtr != 0L) {
                        AtkAttribute attr = new AtkAttribute();
                        ATK.memmove(attr, attrPtr, AtkAttribute.sizeof);
                        String name = AccessibleObject.getString(attr.name);
                        String value = AccessibleObject.getString(attr.value);
                        OS.g_free(attrPtr);
                        if (DEBUG) {
                            AccessibleObject.print("name=" + name + ", value=" + value);
                        }
                        String[] newAttributes = new String[attributes.length + 2];
                        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
                        newAttributes[attributes.length] = name;
                        newAttributes[attributes.length + 1] = value;
                        attributes = newAttributes;
                        try {
                            if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(10)))) {
                                style.rise = Integer.parseInt(value);
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(11)))) {
                                if (value.equals("single") || value.equals("low")) {
                                    style.underline = true;
                                    style.underlineStyle = 0;
                                } else if (value.equals("double")) {
                                    style.underline = true;
                                    style.underlineStyle = 1;
                                } else if (value.equals("error")) {
                                    style.underline = true;
                                    style.underlineStyle = 2;
                                } else if (value.equals("squiggle")) {
                                    style.underline = true;
                                    style.underlineStyle = 3;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(12)))) {
                                if (value.equals("true") || value.equals("1") || value.equals("single")) {
                                    style.strikeout = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(17)))) {
                                byte[] buffer = Converter.wcsToMbcs(null, value, true);
                                OS.pango_font_description_set_family(fontDesc, buffer);
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(13)))) {
                                float size = Float.parseFloat(value);
                                OS.pango_font_description_set_size(fontDesc, (int)(size * 1024.0f));
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(27)))) {
                                int fontStyle = -1;
                                if (value.equals("normal")) {
                                    fontStyle = 0;
                                } else if (value.equals("italic")) {
                                    fontStyle = 2;
                                } else if (value.equals("oblique")) {
                                    fontStyle = 1;
                                }
                                if (fontStyle != -1) {
                                    OS.pango_font_description_set_style(fontDesc, fontStyle);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(26)))) {
                                int variant = -1;
                                if (value.equals("normal")) {
                                    variant = 0;
                                } else if (value.equals("small_caps")) {
                                    variant = 1;
                                }
                                if (variant != -1) {
                                    OS.pango_font_description_set_variant(fontDesc, variant);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(25)))) {
                                int stretch = -1;
                                if (value.equals("ultra_condensed")) {
                                    stretch = 0;
                                } else if (value.equals("extra_condensed")) {
                                    stretch = 1;
                                } else if (value.equals("condensed")) {
                                    stretch = 2;
                                } else if (value.equals("semi_condensed")) {
                                    stretch = 3;
                                } else if (value.equals("normal")) {
                                    stretch = 4;
                                } else if (value.equals("semi_expanded")) {
                                    stretch = 5;
                                } else if (value.equals("expanded")) {
                                    stretch = 6;
                                } else if (value.equals("extra_expanded")) {
                                    stretch = 7;
                                } else if (value.equals("ultra_expanded")) {
                                    stretch = 8;
                                }
                                if (stretch != -1) {
                                    OS.pango_font_description_set_stretch(fontDesc, stretch);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(15)))) {
                                int weight = Integer.parseInt(value);
                                OS.pango_font_description_set_weight(fontDesc, weight);
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(19)))) {
                                style.foreground = AccessibleObject.colorFromString(display, value);
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(18)))) {
                                style.background = AccessibleObject.colorFromString(display, value);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    current = OS.g_slist_next(current);
                    ++i;
                }
                if (createFont) {
                    style.font = Font.gtk_new(display, fontDesc);
                }
                AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                event.textStyle = style;
                event.attributes = attributes;
                int i2 = 0;
                while (i2 < length) {
                    AccessibleEditableTextListener listener = listeners.get(i2);
                    listener.setTextAttributes(event);
                    ++i2;
                }
                if (style.font != null) {
                    style.font.dispose();
                }
                if (style.foreground != null) {
                    style.foreground.dispose();
                }
                if (style.background != null) {
                    style.background.dispose();
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.set_run_attributes != 0L) {
            parentResult = ATK.call(iface.set_run_attributes, atkObject, attrib_set, start_offset, end_offset);
        }
        return parentResult;
    }

    static Color colorFromString(Display display, String rgbString) {
        try {
            int comma1 = rgbString.indexOf(44);
            int comma2 = rgbString.indexOf(44, comma1 + 1);
            int r = Integer.parseInt(rgbString.substring(0, comma1));
            int g = Integer.parseInt(rgbString.substring(comma1 + 1, comma2));
            int b = Integer.parseInt(rgbString.substring(comma2 + 1, rgbString.length()));
            return new Color(display, r, g, b);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static long atkEditableText_set_text_contents(long atkObject, long string) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_text_contents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = 0;
                String text = object.getText();
                event.end = text == null ? 0 : text.length();
                event.string = AccessibleObject.getString(string);
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.set_text_contents != 0L) {
            parentResult = ATK.call(iface.set_text_contents, atkObject, string);
        }
        return parentResult;
    }

    static long atkEditableText_insert_text(long atkObject, long string, long string_length, long position) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_insert_text");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                int[] pos = new int[1];
                OS.memmove(pos, position, (long)OS.PTR_SIZEOF);
                event.start = event.end = pos[0];
                event.string = AccessibleObject.getString(string);
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.insert_text != 0L) {
            parentResult = ATK.call(iface.insert_text, atkObject, string, string_length, position);
        }
        return parentResult;
    }

    static long atkEditableText_copy_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_copy_text");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.copyText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.copy_text != 0L) {
            parentResult = ATK.call(iface.copy_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_cut_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_cut_text");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.cutText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.cut_text != 0L) {
            parentResult = ATK.call(iface.cut_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_delete_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_delete_text");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                event.string = "";
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.delete_text != 0L) {
            parentResult = ATK.call(iface.delete_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_paste_text(long atkObject, long position) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_paste_text");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)position;
                int i = 0;
                while (i < length) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.pasteText(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getEditableTextIface(atkObject);
        if (iface != null && iface.paste_text != 0L) {
            parentResult = ATK.call(iface.paste_text, atkObject, position);
        }
        return parentResult;
    }

    static AtkHypertextIface getHypertextIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface iface = new AtkHypertextIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkHypertext_get_link(long atkObject, long link_index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)link_index;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlink(event);
                    ++i;
                }
                Accessible result = event.accessible;
                return result != null ? result.getAccessibleObject().handle : 0L;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_link != 0L) {
            parentResult = ATK.call(iface.get_link, atkObject, link_index);
        }
        return parentResult;
    }

    static long atkHypertext_get_n_links(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_n_links");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlinkCount(event);
                    ++i;
                }
                return event.count;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_n_links != 0L) {
            parentResult = ATK.call(iface.get_n_links, atkObject);
        }
        return parentResult;
    }

    static long atkHypertext_get_link_index(long atkObject, long char_index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link_index");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.offset = (int)char_index;
                event.index = -1;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlinkIndex(event);
                    ++i;
                }
                return event.index;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_link_index != 0L) {
            parentResult = ATK.call(iface.get_link_index, atkObject, char_index);
        }
        return parentResult;
    }

    static AtkObjectClass getObjectClass(long atkObject) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, ATK.g_type_class_peek(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject))));
        return objectClass;
    }

    static long atkObject_get_description(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_description: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_description != 0L) {
            parentResult = ATK.call(objectClass.get_description, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleListener> listeners = accessible.accessibleListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleListener listener = listeners.get(i);
                    listener.getDescription(event);
                    ++i;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + event.result);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkObject_get_attributes(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_attributes: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_attributes != 0L) {
            parentResult = ATK.call(objectClass.get_attributes, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleAttributeListener> listeners = accessible.accessibleAttributeListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Control control;
                int posinset;
                AccessibleAttributeEvent event = new AccessibleAttributeEvent(accessible);
                event.groupIndex = -1;
                event.groupCount = -1;
                event.groupLevel = -1;
                event.indent = -1;
                event.alignment = -1;
                event.rightMargin = -1;
                event.leftMargin = -1;
                event.bottomMargin = -1;
                event.topMargin = -1;
                int i = 0;
                while (i < length) {
                    AccessibleAttributeListener listener = listeners.get(i);
                    listener.getAttributes(event);
                    ++i;
                }
                AtkAttribute attr = new AtkAttribute();
                if (event.leftMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(1));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.leftMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.rightMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(2));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.rightMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.topMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("top-margin");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.topMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.bottomMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("bottom-margin");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.bottomMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.indent != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(3));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.indent));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.justify) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    attr.value = AccessibleObject.getStringPtr("fill");
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                } else if (event.alignment != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    String str = "left";
                    switch (event.alignment) {
                        case 16384: {
                            str = "left";
                            break;
                        }
                        case 131072: {
                            str = "right";
                            break;
                        }
                        case 0x1000000: {
                            str = "center";
                        }
                    }
                    attr.value = AccessibleObject.getStringPtr(str);
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                int level = event.groupLevel != -1 ? event.groupLevel : 0;
                int setsize = event.groupCount != -1 ? event.groupCount : 0;
                int n = posinset = event.groupIndex != -1 ? event.groupIndex : 0;
                if (setsize == 0 && posinset == 0 && (control = accessible.control) instanceof Button && (control.getStyle() & 0x10) != 0) {
                    Control[] children = control.getParent().getChildren();
                    posinset = 1;
                    setsize = 1;
                    int i2 = 0;
                    while (i2 < children.length) {
                        Control child = children[i2];
                        if (child instanceof Button && (child.getStyle() & 0x10) != 0) {
                            if (child == control) {
                                posinset = setsize;
                            } else {
                                ++setsize;
                            }
                        }
                        ++i2;
                    }
                }
                if (level != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("level");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(level));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (setsize != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("setsize");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(setsize));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (posinset != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("posinset");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(posinset));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.attributes != null) {
                    int end = event.attributes.length / 2 * 2;
                    int i3 = 0;
                    while (i3 < end) {
                        long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = AccessibleObject.getStringPtr(event.attributes[i3]);
                        attr.value = AccessibleObject.getStringPtr(event.attributes[i3 + 1]);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        parentResult = OS.g_slist_append(parentResult, attrPtr);
                        i3 += 2;
                    }
                }
            }
        }
        return parentResult;
    }

    static long atkObject_get_name(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_name: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_name != 0L) {
            parentResult = ATK.call(objectClass.get_name, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleListener> listeners = accessible.accessibleListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleListener listener = listeners.get(i);
                    listener.getName(event);
                    ++i;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + event.result);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (namePtr != -1L) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(event.result);
                return namePtr;
            }
        }
        return parentResult;
    }

    static long atkObject_get_n_children(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_n_children: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_n_children != 0L) {
            parentResult = ATK.call(objectClass.get_n_children, atkObject);
        }
        if (object != null && object.id == -1) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = (int)parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChildCount(event);
                    ++i;
                }
                if (DEBUG) {
                    AccessibleObject.print("--->" + event.detail);
                }
                return event.detail;
            }
        }
        return parentResult;
    }

    static long atkObject_get_index_in_parent(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_index_in_parent: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            AccessibleControlEvent event = new AccessibleControlEvent(accessible);
            event.childID = -5;
            event.detail = -1;
            int i = 0;
            while (i < AccessibleObject.size(listeners)) {
                AccessibleControlListener listener = listeners.get(i);
                listener.getChild(event);
                ++i;
            }
            if (event.detail != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + object.index);
                }
                return event.detail;
            }
            if (object.index != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + object.index);
                }
                return object.index;
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_index_in_parent == 0L) {
            return 0L;
        }
        long result = ATK.call(objectClass.get_index_in_parent, atkObject);
        if (DEBUG) {
            AccessibleObject.print("---*> " + result);
        }
        return result;
    }

    static long atkObject_get_parent(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_parent: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null && object.parent != null) {
            if (DEBUG) {
                AccessibleObject.print("---> " + object.parent.accessible.accessibleObject.handle);
            }
            return object.parent.handle;
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_parent == 0L) {
            return 0L;
        }
        long parentResult = ATK.call(objectClass.get_parent, atkObject);
        if (DEBUG) {
            AccessibleObject.print("---> " + parentResult);
        }
        return parentResult;
    }

    static long atkObject_get_role(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_role: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = -1;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getRole(event);
                    ++i;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + event.detail);
                }
                if (event.detail != -1) {
                    switch (event.detail) {
                        case 44: {
                            return 7L;
                        }
                        case 10: {
                            return 18L;
                        }
                        case 46: {
                            return 11L;
                        }
                        case 18: {
                            return 16L;
                        }
                        case 41: {
                            return 28L;
                        }
                        case 30: {
                            return 60L;
                        }
                        case 33: {
                            return 30L;
                        }
                        case 34: {
                            return 31L;
                        }
                        case 11: {
                            return 32L;
                        }
                        case 2: {
                            return 33L;
                        }
                        case 12: {
                            return 34L;
                        }
                        case 48: {
                            return 41L;
                        }
                        case 43: {
                            return 42L;
                        }
                        case 3: {
                            return 47L;
                        }
                        case 21: {
                            return 49L;
                        }
                        case 51: {
                            return 50L;
                        }
                        case 24: {
                            return 54L;
                        }
                        case 29: {
                            return 55L;
                        }
                        case 25: {
                            return 56L;
                        }
                        case 26: {
                            return 57L;
                        }
                        case 60: {
                            return 37L;
                        }
                        case 37: {
                            return 36L;
                        }
                        case 42: {
                            return 60L;
                        }
                        case 22: {
                            return 62L;
                        }
                        case 13: {
                            return 63L;
                        }
                        case 35: {
                            return 64L;
                        }
                        case 36: {
                            return 31L;
                        }
                        case 45: {
                            return 43L;
                        }
                        case 62: {
                            return 42L;
                        }
                        case 9: {
                            return 68L;
                        }
                        case 28: {
                            return ROW_ROLE;
                        }
                        case 27: {
                            return 66L;
                        }
                        case 8: {
                            return 2L;
                        }
                        case 54: {
                            return 3L;
                        }
                        case 1025: {
                            return 6L;
                        }
                        case 20: {
                            return 38L;
                        }
                        case 52: {
                            return 52L;
                        }
                        case 23: {
                            return 53L;
                        }
                        case 1027: {
                            return 8L;
                        }
                        case 1073: {
                            return 44L;
                        }
                        case 61: {
                            return 66L;
                        }
                        case 47: {
                            return 4L;
                        }
                        case 1029: {
                            return 12L;
                        }
                        case 1038: {
                            return 70L;
                        }
                        case 1040: {
                            return 85L;
                        }
                        case 1043: {
                            return 69L;
                        }
                        case 1044: {
                            return 81L;
                        }
                        case 1053: {
                            return 82L;
                        }
                        case 1054: {
                            return 71L;
                        }
                        case 1060: {
                            return 83L;
                        }
                        case 15: {
                            return 80L;
                        }
                        case 40: {
                            return 26L;
                        }
                    }
                }
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_role == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.get_role, atkObject);
    }

    static long atkObject_ref_child(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_child: " + index + " of: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null && object.id == -1) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleObject accObject;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = -4;
                event.detail = (int)index;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChild(event);
                    ++i;
                }
                if (event.accessible != null && (accObject = event.accessible.getAccessibleObject()) != null) {
                    return OS.g_object_ref(accObject.handle);
                }
            }
            object.updateChildren();
            AccessibleObject accObject = object.getChildByIndex((int)index);
            if (accObject != null) {
                return OS.g_object_ref(accObject.handle);
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.ref_child == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.ref_child, atkObject, index);
    }

    static long atkObject_ref_state_set(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_state_set: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.ref_state_set != 0L) {
            parentResult = ATK.call(objectClass.ref_state_set, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long set = parentResult;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = -1;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getState(event);
                    ++i;
                }
                if (event.detail != -1) {
                    int state = event.detail;
                    if ((state & 0x800) != 0) {
                        ATK.atk_state_set_add_state(set, 3);
                    }
                    if ((state & 0x10) != 0) {
                        ATK.atk_state_set_add_state(set, 4);
                    }
                    if ((state & 0x200) != 0) {
                        ATK.atk_state_set_add_state(set, 9);
                    }
                    if ((state & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(set, 10);
                    }
                    if ((state & 4) != 0) {
                        ATK.atk_state_set_add_state(set, 11);
                    }
                    if ((state & 0x80) != 0) {
                        ATK.atk_state_set_add_state(set, 2);
                    }
                    if ((state & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(set, 28);
                    }
                    if ((state & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(set, 16);
                    }
                    if ((state & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(set, 23);
                    }
                    if ((state & 8) != 0) {
                        ATK.atk_state_set_add_state(set, 18);
                    }
                    if ((state & 0x40) == 0) {
                        ATK.atk_state_set_add_state(set, 6);
                    }
                    if ((state & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(set, 20);
                    }
                    if ((state & 2) != 0) {
                        ATK.atk_state_set_add_state(set, 21);
                    }
                    if ((state & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(set, 19);
                    }
                    if ((state & 1) == 0) {
                        ATK.atk_state_set_add_state(set, 7);
                    }
                    if ((state & 0x4000000) != 0) {
                        ATK.atk_state_set_add_state(set, 1);
                    }
                    if ((state & 0x8000000) != 0) {
                        ATK.atk_state_set_add_state(set, 24);
                    }
                    if ((state & 0x10000000) != 0) {
                        ATK.atk_state_set_add_state(set, 15);
                    }
                    if ((state & 0x2000000) != 0) {
                        ATK.atk_state_set_add_state(set, 32);
                    }
                    if ((state & 0x20000000) != 0) {
                        ATK.atk_state_set_add_state(set, 33);
                    }
                    if ((state & 0x40000000) != 0) {
                        ATK.atk_state_set_add_state(set, 34);
                    }
                }
                return set;
            }
        }
        return parentResult;
    }

    static AtkSelectionIface getSelectionIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface iface = new AtkSelectionIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkSelection_is_child_selected(long atkObject, long index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_is_child_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkSelectionIface iface = AccessibleObject.getSelectionIface(atkObject);
        if (iface != null && iface.is_child_selected != 0L) {
            parentResult = ATK.call(iface.is_child_selected, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleObject accessibleObject;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getSelection(event);
                    ++i;
                }
                Accessible result = event.accessible;
                AccessibleObject accessibleObject2 = accessibleObject = result != null ? result.getAccessibleObject() : object.getChildByID(event.childID);
                if (accessibleObject != null) {
                    return (long)accessibleObject.index == index ? 1 : 0;
                }
            }
        }
        return parentResult;
    }

    static long atkSelection_ref_selection(long atkObject, long index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_ref_selection");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkSelectionIface iface = AccessibleObject.getSelectionIface(atkObject);
        if (iface != null && iface.ref_selection != 0L) {
            parentResult = ATK.call(iface.ref_selection, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getSelection(event);
                    ++i;
                }
                AccessibleObject accObj = object.getChildByID(event.childID);
                if (accObj != null) {
                    if (parentResult != 0L) {
                        OS.g_object_unref(parentResult);
                    }
                    OS.g_object_ref(accObj.handle);
                    return accObj.handle;
                }
            }
        }
        return parentResult;
    }

    static AtkTableIface getTableIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface iface = new AtkTableIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkTable_ref_at(long atkObject, long row, long column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_ref_at");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null) {
                    AccessibleObject accessibleObject = result.getAccessibleObject();
                    OS.g_object_ref(accessibleObject.handle);
                    return accessibleObject.handle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.ref_at != 0L) {
            parentResult = ATK.call(iface.ref_at, atkObject, row, column);
        }
        return parentResult;
    }

    static long atkTable_get_index_at(long atkObject, long row, long column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_index_at");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result == null) {
                    return -1L;
                }
                event = new AccessibleTableEvent(accessible);
                int i2 = 0;
                while (i2 < length) {
                    AccessibleTableListener listener = listeners.get(i2);
                    listener.getColumnCount(event);
                    ++i2;
                }
                return row * (long)event.count + column;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_index_at != 0L) {
            parentResult = ATK.call(iface.get_index_at, atkObject, row, column);
        }
        return parentResult;
    }

    static long atkTable_get_column_at_index(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_at_index: " + atkObject + " " + index);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long result;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                    ++i;
                }
                long l = result = event.count == 0 ? -1L : index % (long)event.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + result);
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_at_index != 0L) {
            parentResult = ATK.call(iface.get_column_at_index, atkObject, index);
        }
        return parentResult;
    }

    static long atkTable_get_row_at_index(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_at_index: " + atkObject + " " + index);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long result;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                    ++i;
                }
                long l = result = event.count == 0 ? -1L : index / (long)event.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + result);
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_at_index != 0L) {
            parentResult = ATK.call(iface.get_row_at_index, atkObject, index);
        }
        return parentResult;
    }

    static long atkTable_get_n_columns(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_columns");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_n_columns != 0L) {
            parentResult = ATK.call(iface.get_n_columns, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.count = (int)parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                    parentResult = event.count;
                    ++i;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_n_rows(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_rows");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_n_rows != 0L) {
            parentResult = ATK.call(iface.get_n_rows, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.count = (int)parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowCount(event);
                    parentResult = event.count;
                    ++i;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_column_extent_at(long atkObject, long row, long column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_extent_at");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_extent_at != 0L) {
            parentResult = ATK.call(iface.get_column_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.count = (int)parentResult;
                    int i2 = 0;
                    while (i2 < length) {
                        AccessibleTableCellListener listener = listeners2.get(i2);
                        listener.getColumnSpan(cellEvent);
                        ++i2;
                    }
                    return cellEvent.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_row_extent_at(long atkObject, long row, long column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_extent_at");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_extent_at != 0L) {
            parentResult = ATK.call(iface.get_row_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.count = (int)parentResult;
                    int i2 = 0;
                    while (i2 < length) {
                        AccessibleTableCellListener listener = listeners2.get(i2);
                        listener.getRowSpan(cellEvent);
                        ++i2;
                    }
                    return cellEvent.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_caption(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_caption");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCaption(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().handle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_caption != 0L) {
            parentResult = ATK.call(iface.get_caption, atkObject);
        }
        return parentResult;
    }

    static long atkTable_get_summary(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_summary");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSummary(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().handle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_summary != 0L) {
            parentResult = ATK.call(iface.get_summary, atkObject);
        }
        return parentResult;
    }

    static long atkTable_get_column_description(long atkObject, long column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_description");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_description != 0L) {
            parentResult = ATK.call(iface.get_column_description, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnDescription(event);
                    ++i;
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkTable_get_column_header(long atkObject, long column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_header");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowHeaderCells(event);
                    ++i;
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && 0L <= column && column < (long)accessibles.length) {
                    return accessibles[(int)column].getAccessibleObject().handle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_header != 0L) {
            parentResult = ATK.call(iface.get_column_header, atkObject, column);
        }
        return parentResult;
    }

    static long atkTable_get_row_description(long atkObject, long row) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_description");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_description != 0L) {
            parentResult = ATK.call(iface.get_row_description, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowDescription(event);
                    ++i;
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkTable_get_row_header(long atkObject, long row) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_header");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowHeaderCells(event);
                    ++i;
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && 0L <= row && row < (long)accessibles.length) {
                    return accessibles[(int)row].getAccessibleObject().handle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_header != 0L) {
            parentResult = ATK.call(iface.get_row_header, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_get_selected_columns(long atkObject, long selected) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_columns");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSelectedColumns(event);
                    ++i;
                }
                int count = event.selected != null ? event.selected.length : 0;
                long result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    OS.memmove(result, event.selected, (long)(count * 4));
                }
                if (selected != 0L) {
                    OS.memmove(selected, new long[]{result}, (long)C.PTR_SIZEOF);
                }
                return count;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_selected_columns != 0L) {
            parentResult = ATK.call(iface.get_selected_columns, atkObject, selected);
        }
        return parentResult;
    }

    static long atkTable_get_selected_rows(long atkObject, long selected) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_rows");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSelectedRows(event);
                    ++i;
                }
                int count = event.selected != null ? event.selected.length : 0;
                long result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    OS.memmove(result, event.selected, (long)(count * 4));
                }
                if (selected != 0L) {
                    OS.memmove(selected, new long[]{result}, (long)C.PTR_SIZEOF);
                }
                return count;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_selected_rows != 0L) {
            parentResult = ATK.call(iface.get_selected_rows, atkObject, selected);
        }
        return parentResult;
    }

    static long atkTable_is_column_selected(long atkObject, long column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_column_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_column_selected != 0L) {
            parentResult = ATK.call(iface.is_column_selected, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0L;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.isColumnSelected(event);
                    ++i;
                }
                return event.isSelected ? 1 : 0;
            }
        }
        return parentResult;
    }

    static long atkTable_is_row_selected(long atkObject, long row) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_row_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_row_selected != 0L) {
            parentResult = ATK.call(iface.is_row_selected, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0L;
                event.row = (int)row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.isRowSelected(event);
                    ++i;
                }
                return event.isSelected ? 1 : 0;
            }
        }
        return parentResult;
    }

    static long atkTable_is_selected(long atkObject, long row, long column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_selected != 0L) {
            parentResult = ATK.call(iface.is_selected, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.isSelected = parentResult != 0L;
                    int i2 = 0;
                    while (i2 < length) {
                        AccessibleTableCellListener listener = listeners2.get(i2);
                        listener.isSelected(cellEvent);
                        ++i2;
                    }
                    return cellEvent.isSelected ? 1 : 0;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_add_row_selection(long atkObject, long row) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_row_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.selectRow(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.add_row_selection != 0L) {
            parentResult = ATK.call(iface.add_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_remove_row_selection(long atkObject, long row) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_row_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.deselectRow(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.remove_row_selection != 0L) {
            parentResult = ATK.call(iface.remove_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_add_column_selection(long atkObject, long column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_column_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.selectColumn(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.add_column_selection != 0L) {
            parentResult = ATK.call(iface.add_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static long atkTable_remove_column_selection(long atkObject, long column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_column_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.deselectColumn(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.remove_column_selection != 0L) {
            parentResult = ATK.call(iface.remove_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static AtkTextIface getTextIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface iface = new AtkTextIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkText_get_character_extents(long atkObject, long offset, long x, long y, long width, long height, long coords) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)offset;
                event.end = (int)(offset + 1L);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getTextBounds(event);
                    ++i;
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4L);
                OS.memmove(y, new int[]{event.y}, 4L);
                OS.memmove(width, new int[]{event.width}, 4L);
                OS.memmove(height, new int[]{event.height}, 4L);
                return 0L;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_extents != 0L) {
            ATK.call(iface.get_character_extents, atkObject, offset, x, y, width, height, coords);
        }
        return 0L;
    }

    static String getString(long strPtr) {
        int length = OS.strlen(strPtr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, strPtr, (long)length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    static long getStringPtr(String str) {
        byte[] buffer = Converter.wcsToMbcs(null, str != null ? str : "", true);
        long ptr = OS.g_malloc(buffer.length);
        OS.memmove(ptr, buffer, (long)buffer.length);
        return ptr;
    }

    static long atkText_get_range_extents(long atkObject, long start_offset, long end_offset, long coord_type, long rect) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_range_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getTextBounds(event);
                    ++i;
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                AtkTextRectangle atkRect = new AtkTextRectangle();
                atkRect.x = event.x;
                atkRect.y = event.y;
                atkRect.width = event.width;
                atkRect.height = event.height;
                ATK.memmove(rect, atkRect, AtkTextRectangle.sizeof);
                return 0L;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_range_extents != 0L) {
            ATK.call(iface.get_range_extents, atkObject, start_offset, end_offset, coord_type, rect);
        }
        return 0L;
    }

    static long atkText_get_run_attributes(long atkObject, long offset, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_run_attributes");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleAttributeListener> listeners = accessible.accessibleAttributeListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(accessible);
                event.offset = (int)offset;
                int i = 0;
                while (i < length) {
                    AccessibleAttributeListener listener = listeners.get(i);
                    listener.getTextAttributes(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4L);
                OS.memmove(end_offset, new int[]{event.end}, 4L);
                TextStyle style = event.textStyle;
                long result = 0L;
                AtkAttribute attr = new AtkAttribute();
                if (style != null) {
                    Color color;
                    Font font;
                    long attrPtr;
                    if (style.rise != 0) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(10));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(style.rise));
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if (style.underline) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(11));
                        String str = "none";
                        switch (style.underlineStyle) {
                            case 1: {
                                str = "double";
                                break;
                            }
                            case 0: {
                                str = "single";
                                break;
                            }
                            case 2: {
                                str = "error";
                                break;
                            }
                            case 3: {
                                str = "squiggle";
                            }
                        }
                        attr.value = AccessibleObject.getStringPtr(str);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if (style.strikeout) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(12));
                        attr.value = AccessibleObject.getStringPtr("1");
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if ((font = style.font) != null && !font.isDisposed()) {
                        long attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(17));
                        attr.value = ATK.g_strdup(OS.pango_font_description_get_family(font.handle));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(13));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(27));
                        attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(26));
                        attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(25));
                        attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(15));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                    }
                    if ((color = style.foreground) != null && !color.isDisposed()) {
                        long attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(19));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr3);
                    }
                    if ((color = style.background) != null && !color.isDisposed()) {
                        long attrPtr4 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(18));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(attrPtr4, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr4);
                    }
                }
                if (event.attributes != null) {
                    int end = event.attributes.length / 2 * 2;
                    int i2 = 0;
                    while (i2 < end) {
                        long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = AccessibleObject.getStringPtr(event.attributes[i2]);
                        attr.value = AccessibleObject.getStringPtr(event.attributes[i2 + 1]);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                        i2 += 2;
                    }
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_run_attributes != 0L) {
            parentResult = ATK.call(iface.get_run_attributes, atkObject, offset, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_get_offset_at_point(long atkObject, long x, long y, long coords) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_offset_at_point");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.x = (int)x;
                event.y = (int)y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getOffsetAtPoint(event);
                    ++i;
                }
                return event.offset;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_offset_at_point != 0L) {
            parentResult = ATK.call(iface.get_offset_at_point, atkObject, x, y, coords);
        }
        return parentResult;
    }

    static long atkText_add_selection(long atkObject, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_add_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.addSelection(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.add_selection != 0L) {
            parentResult = ATK.call(iface.add_selection, atkObject, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_remove_selection(long atkObject, long selection_num) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_remove_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.removeSelection(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.remove_selection != 0L) {
            parentResult = ATK.call(iface.remove_selection, atkObject, selection_num);
        }
        return parentResult;
    }

    static long atkText_set_caret_offset(long atkObject, long offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_caret_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.offset = (int)offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.setCaretOffset(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.set_caret_offset != 0L) {
            return ATK.call(iface.set_caret_offset, atkObject, offset);
        }
        return 0L;
    }

    static long atkText_set_selection(long atkObject, long selection_num, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.setSelection(event);
                    ++i;
                }
                return "OK".equals(event.result) ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.set_selection != 0L) {
            parentResult = ATK.call(iface.set_selection, atkObject, selection_num, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_get_caret_offset(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_caret_offset");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_caret_offset != 0L) {
            parentResult = ATK.call(iface.get_caret_offset, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getCaretOffset(event);
                    ++i;
                }
                return event.offset;
            }
            List<AccessibleTextListener> listeners2 = accessible.accessibleTextListeners;
            length = AccessibleObject.size(listeners2);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                event.offset = (int)parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getCaretOffset(event);
                    ++i;
                }
                return event.offset;
            }
        }
        return parentResult;
    }

    static long atkText_get_bounded_ranges(long atkObject, long rect, long coord_type, long x_clip_type, long y_clip_type) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_bounded_ranges");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                AtkTextRectangle atkRect = new AtkTextRectangle();
                ATK.memmove(atkRect, rect, AtkTextRectangle.sizeof);
                event.x = atkRect.x;
                event.y = atkRect.y;
                event.width = atkRect.width;
                event.height = atkRect.height;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getRanges(event);
                    ++i;
                }
                int[] ranges = event.ranges;
                int size = ranges == null ? 1 : ranges.length / 2;
                long result = OS.malloc(size * AtkTextRange.sizeof);
                AtkTextRange range = new AtkTextRange();
                int j = 0;
                int end = ranges != null ? ranges.length / 2 : 1;
                while (j < end) {
                    AccessibleTextExtendedListener listener;
                    if (ranges != null) {
                        int index = j * 2;
                        event.start = ranges[index];
                        event.end = ranges[index + 1];
                    }
                    event.count = 0;
                    event.type = 5;
                    int i2 = 0;
                    while (i2 < length) {
                        listener = listeners.get(i2);
                        listener.getText(event);
                        ++i2;
                    }
                    range.start_offset = event.start;
                    range.end_offset = event.end;
                    range.content = AccessibleObject.getStringPtr(event.result);
                    event.result = null;
                    event.height = 0;
                    event.width = 0;
                    event.y = 0;
                    event.x = 0;
                    event.type = 0;
                    event.count = 0;
                    i2 = 0;
                    while (i2 < length) {
                        listener = listeners.get(i2);
                        listener.getTextBounds(event);
                        ++i2;
                    }
                    range.bounds.x = event.x;
                    range.bounds.y = event.y;
                    range.bounds.width = event.width;
                    range.bounds.height = event.height;
                    ATK.memmove(result + (long)(j * AtkTextRange.sizeof), range, AtkTextRange.sizeof);
                    ++j;
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_bounded_ranges != 0L) {
            parentResult = ATK.call(iface.get_bounded_ranges, atkObject);
        }
        return parentResult;
    }

    static long atkText_get_character_at_offset(long atkObject, long offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_at_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)offset;
                event.end = (int)(offset + 1L);
                event.type = 0;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                String text = event.result;
                return text != null && text.length() > 0 ? (int)text.charAt(0) : 0;
            }
            String text = object.getText();
            if (text != null && (long)text.length() > offset) {
                return text.charAt((int)offset);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_at_offset != 0L) {
            return ATK.call(iface.get_character_at_offset, atkObject, offset);
        }
        return 0L;
    }

    static long atkText_get_character_count(long atkObject) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_count");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getCharacterCount(event);
                    ++i;
                }
                return event.count;
            }
            String text = object.getText();
            if (text != null) {
                return text.length();
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_count != 0L) {
            return ATK.call(iface.get_character_count, atkObject);
        }
        return 0L;
    }

    static long atkText_get_n_selections(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_n_selections");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getSelectionCount(event);
                    ++i;
                }
                return event.count;
            }
            List<AccessibleTextListener> listeners2 = accessible.accessibleTextListeners;
            length = AccessibleObject.size(listeners2);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getSelectionRange(event);
                    ++i;
                }
                if (event.length > 0) {
                    return 1L;
                }
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_n_selections != 0L) {
            parentResult = ATK.call(iface.get_n_selections, atkObject);
        }
        return parentResult;
    }

    static long atkText_get_selection(long atkObject, long selection_num, long start_offset, long end_offset) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_selection");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        OS.memmove(start_offset, new int[1], 4L);
        OS.memmove(end_offset, new int[1], 4L);
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_selection != 0L) {
            parentResult = ATK.call(iface.get_selection, atkObject, selection_num, start_offset, end_offset);
        }
        if (object != null) {
            List<AccessibleTextListener> listeners2;
            int[] parentStart = new int[1];
            int[] parentEnd = new int[1];
            OS.memmove(parentStart, start_offset, 4L);
            OS.memmove(parentEnd, end_offset, 4L);
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextExtendedListener listener;
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                event.start = parentStart[0];
                event.end = parentEnd[0];
                int i = 0;
                while (i < length) {
                    listener = listeners.get(i);
                    listener.getSelection(event);
                    ++i;
                }
                parentStart[0] = event.start;
                parentEnd[0] = event.end;
                OS.memmove(start_offset, parentStart, 4L);
                OS.memmove(end_offset, parentEnd, 4L);
                event.index = 0;
                event.count = 0;
                event.type = 5;
                i = 0;
                while (i < length) {
                    listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                if (parentResult != 0L) {
                    OS.g_free(parentResult);
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            if (selection_num == 0L && (length = AccessibleObject.size(listeners2 = accessible.accessibleTextListeners)) > 0) {
                String text;
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.childID = object.id;
                event.offset = parentStart[0];
                event.length = parentEnd[0] - parentStart[0];
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getSelectionRange(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.offset}, 4L);
                OS.memmove(end_offset, new int[]{event.offset + event.length}, 4L);
                if (parentResult != 0L) {
                    OS.g_free(parentResult);
                }
                if ((text = object.getText()) != null && text.length() > event.offset && text.length() >= event.offset + event.length) {
                    return AccessibleObject.getStringPtr(text.substring(event.offset, event.offset + event.length));
                }
                if (iface != null && iface.get_text != 0L) {
                    return ATK.call(iface.get_text, atkObject, event.offset, event.offset + event.length);
                }
                return 0L;
            }
        }
        return parentResult;
    }

    static long atkText_get_text(long atkObject, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text: " + atkObject + " " + start_offset + "," + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                event.type = 5;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            String text = object.getText();
            if (text != null && text.length() > 0) {
                end_offset = end_offset == -1L ? (long)text.length() : Math.min(end_offset, (long)text.length());
                start_offset = Math.min(start_offset, end_offset);
                text = text.substring((int)start_offset, (int)end_offset);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_text != 0L) {
            return ATK.call(iface.get_text, atkObject, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_after_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = 1;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 2;
                        int i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        if (event.start <= 0) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 0;
                        int i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        break;
                    }
                }
                OS.memmove(start_offset, new int[]{event.start}, 4L);
                OS.memmove(end_offset, new int[]{event.end}, 4L);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int previousWordEnd = AccessibleObject.previousIndexOfNotChar(text, " \n", offset);
                        if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                            offset = AccessibleObject.nextIndexOfNotChar(text, " \n", offset);
                        }
                        if (offset == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        int wordEnd1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordEnd1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", wordEnd1);
                        if (wordEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int previousSentenceEnd = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        int previousText = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        int sentenceStart1 = 0;
                        if (previousSentenceEnd >= previousText) {
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", offset);
                        } else {
                            sentenceStart1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                            if (sentenceStart1 == -1) {
                                startBounds = endBounds = length;
                                break;
                            }
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                        }
                        if (sentenceStart1 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceStart1;
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceEnd1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                        if (sentenceEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        int lineStart1 = text.indexOf(10, offset - 1);
                        if (lineStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((lineStart1 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineStart1;
                        int lineStart2 = text.indexOf(10, lineStart1);
                        if (lineStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = lineStart2 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart2);
                        break;
                    }
                    case 6: {
                        int lineEnd2;
                        int lineEnd1 = AccessibleObject.nextIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineEnd1;
                        endBounds = startBounds == length ? length : ((lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1)) == -1 ? length : lineEnd2);
                    }
                }
                OS.memmove(start_offset, new int[]{startBounds}, 4L);
                OS.memmove(end_offset, new int[]{++endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_text_after_offset != 0L) {
            return ATK.call(iface.get_text_after_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_at_offset: " + offset_value + " start: " + start_offset + " end: " + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = 0;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 1;
                        int i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        if (event.start <= 0) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = -1;
                        int i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        break;
                    }
                }
                OS.memmove(start_offset, new int[]{event.start}, 4L);
                OS.memmove(end_offset, new int[]{event.end}, 4L);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd1);
                        wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (wordEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                        startBounds = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceStart1);
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", startBounds);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (sentenceEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", offset) + 1;
                        int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", startBounds);
                        if (lineEnd2 < length) {
                            ++lineEnd2;
                        }
                        endBounds = lineEnd2;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = lineEnd1;
                        endBounds = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                    }
                }
                OS.memmove(start_offset, new int[]{startBounds}, 4L);
                OS.memmove(end_offset, new int[]{++endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_text_at_offset != 0L) {
            return ATK.call(iface.get_text_at_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_before_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = -1;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4L);
                OS.memmove(end_offset, new int[]{event.end}, 4L);
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 0;
                        int i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        i2 = 0;
                        while (i2 < length) {
                            listener = listeners.get(i2);
                            listener.getText(event);
                            ++i2;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        if (event.start <= 0) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = -2;
                        int i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        i3 = 0;
                        while (i3 < length) {
                            listener = listeners.get(i3);
                            listener.getText(event);
                            ++i3;
                        }
                        break;
                    }
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length < offset || offset <= 0) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int wordStart2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", endBounds);
                        if ((wordEnd2 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int sentenceStart2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", endBounds);
                        if ((sentenceEnd2 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int lineStart1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineStart1) + 1;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineEnd1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineEnd1);
                        if (startBounds != -1) break;
                        startBounds = 0;
                    }
                }
                OS.memmove(start_offset, new int[]{--startBounds}, 4L);
                OS.memmove(end_offset, new int[]{endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_text_before_offset != 0L) {
            return ATK.call(iface.get_text_before_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static void setGValue(long value, Number number) {
        if (number == null) {
            return;
        }
        if (OS.G_VALUE_TYPE(value) != 0L) {
            OS.g_value_unset(value);
        }
        if (number instanceof Double) {
            OS.g_value_init(value, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(value, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(value, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(value, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(value, OS.G_TYPE_INT64());
            OS.g_value_set_int64(value, number.longValue());
        } else {
            OS.g_value_init(value, OS.G_TYPE_INT());
            OS.g_value_set_int(value, number.intValue());
        }
    }

    static Number getGValue(long value) {
        long type = OS.G_VALUE_TYPE(value);
        if (type == 0L) {
            return null;
        }
        if (type == OS.G_TYPE_DOUBLE()) {
            return new Double(OS.g_value_get_double(value));
        }
        if (type == OS.G_TYPE_FLOAT()) {
            return new Float(OS.g_value_get_float(value));
        }
        if (type == OS.G_TYPE_INT64()) {
            return new Long(OS.g_value_get_int64(value));
        }
        return new Integer(OS.g_value_get_int(value));
    }

    static AtkValueIface getValueIface(long atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface iface = new AtkValueIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkValue_get_current_value(long atkObject, long value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_current_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_current_value != 0L) {
            ATK.call(iface.get_current_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                int i = 0;
                while (i < length) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getCurrentValue(event);
                    ++i;
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_maximum_value(long atkObject, long value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_maximum_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_maximum_value != 0L) {
            ATK.call(iface.get_maximum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                int i = 0;
                while (i < length) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getMaximumValue(event);
                    ++i;
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_minimum_value(long atkObject, long value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_minimum_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_minimum_value != 0L) {
            ATK.call(iface.get_minimum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                int i = 0;
                while (i < length) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getMinimumValue(event);
                    ++i;
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_set_current_value(long atkObject, long value) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_set_current_value");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                int i = 0;
                while (i < length) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.setCurrentValue(event);
                    ++i;
                }
                return event.value != null ? 1 : 0;
            }
        }
        long parentResult = 0L;
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.set_current_value != 0L) {
            parentResult = ATK.call(iface.set_current_value, atkObject, value);
        }
        return parentResult;
    }

    static AccessibleObject getAccessibleObject(long atkObject) {
        AccessibleObject object = AccessibleObjects.get(new LONG(atkObject));
        if (object == null) {
            return null;
        }
        if (object.accessible == null) {
            return null;
        }
        Control control = object.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return object;
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        if (childId == -2 || childId == -3) {
            return null;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                AccessibleObject child = this.children[i];
                if (child != null && child.id == childId) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        if (this.children != null && childIndex < this.children.length) {
            return this.children[childIndex];
        }
        return null;
    }

    String getText() {
        List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
        int length = AccessibleObject.size(listeners);
        if (length > 0) {
            long parentResult;
            long characterCount;
            String parentText = "";
            AtkTextIface iface = AccessibleObject.getTextIface(this.handle);
            if (iface != null && iface.get_character_count != 0L && (characterCount = ATK.call(iface.get_character_count, this.handle)) > 0L && iface.get_text != 0L && (parentResult = ATK.call(iface.get_text, this.handle, 0L, characterCount)) != 0L) {
                parentText = AccessibleObject.getString(parentResult);
                OS.g_free(parentResult);
            }
            AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
            event.childID = this.id;
            event.result = parentText;
            int i = 0;
            while (i < length) {
                AccessibleControlListener listener = listeners.get(i);
                listener.getValue(event);
                ++i;
            }
            return event.result;
        }
        return null;
    }

    static long gObjectClass_finalize(long atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->gObjectClass_finalize: " + atkObject);
        }
        long superType = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(atkObject));
        long gObjectClass = ATK.G_OBJECT_CLASS(superType);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove(objectClassStruct, gObjectClass);
        ATK.call(objectClassStruct.finalize, atkObject);
        AccessibleObject object = AccessibleObjects.get(new LONG(atkObject));
        if (object != null) {
            AccessibleObjects.remove(new LONG(atkObject));
        }
        return 0L;
    }

    static int toATKRelation(int relation) {
        switch (relation) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject object, int[] x, int[] y) {
        GtkAccessible gtkAccessible;
        long widget;
        if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
            widget = OS.gtk_accessible_get_widget(object.handle);
        } else {
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, object.handle);
            widget = gtkAccessible.widget;
        }
        while (widget == 0L && object.parent != null) {
            object = object.parent;
            if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
                widget = OS.gtk_accessible_get_widget(object.handle);
                continue;
            }
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, object.handle);
            widget = gtkAccessible.widget;
        }
        if (widget == 0L) {
            return;
        }
        long topLevel = ATK.gtk_widget_get_toplevel(widget);
        long window = OS.gtk_widget_get_window(topLevel);
        OS.gdk_window_get_origin(window, x, y);
    }

    static int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index != -1) {
                result = Math.min(result, index);
            }
            ++i;
        }
        return result;
    }

    static int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        int length = string.length();
        int index = startIndex;
        while (index < length) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            ++index;
        }
        return index;
    }

    static int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index != -1) {
                result = Math.max(result, index);
            }
            ++i;
        }
        return result;
    }

    static int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int index = startIndex - 1;
        while (index >= 0) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            --index;
        }
        return index;
    }

    void addRelation(int type, Accessible target) {
        OS.atk_object_add_relationship(this.handle, AccessibleObject.toATKRelation(type), target.getAccessibleObject().handle);
    }

    void release() {
        if (DEBUG) {
            AccessibleObject.print("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                AccessibleObject child = this.children[i];
                if (child != null) {
                    OS.g_object_unref(child.handle);
                }
                ++i;
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.handle);
        }
    }

    void removeRelation(int type, Accessible target) {
        OS.atk_object_remove_relationship(this.handle, AccessibleObject.toATKRelation(type), target.getAccessibleObject().handle);
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void sendEvent(int event, Object eventData) {
        block0 : switch (event) {
            case 32777: {
                OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
                break;
            }
            case 32788: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
                break;
            }
            case 32778: {
                if (!(eventData instanceof int[])) break;
                int[] array = (int[])eventData;
                int state = array[0];
                int value = array[1];
                int atkState = -1;
                switch (state) {
                    case 2: {
                        atkState = 21;
                        break;
                    }
                    case 0x200000: {
                        atkState = 20;
                        break;
                    }
                    case 0x1000000: {
                        atkState = 16;
                        break;
                    }
                    case 4: {
                        atkState = 11;
                        break;
                    }
                    case 0x100000: {
                        atkState = 10;
                        break;
                    }
                    case 8: {
                        atkState = 18;
                        break;
                    }
                    case 16: {
                        atkState = 4;
                        break;
                    }
                    case 512: {
                        atkState = 9;
                        break;
                    }
                    case 1024: {
                        atkState = 9;
                        break;
                    }
                    case 128: {
                        atkState = 2;
                        break;
                    }
                    case 2048: {
                        atkState = 3;
                        break;
                    }
                    case 64: {
                        atkState = 6;
                        break;
                    }
                    case 32768: {
                        atkState = 28;
                        break;
                    }
                    case 65536: {
                        atkState = 23;
                        break;
                    }
                    case 131072: {
                        atkState = 19;
                        break;
                    }
                    case 0x400000: {
                        break;
                    }
                    case 1: {
                        atkState = 7;
                        break;
                    }
                    case 0x4000000: {
                        atkState = 1;
                        break;
                    }
                    case 0x8000000: {
                        atkState = 24;
                        break;
                    }
                    case 0x10000000: {
                        atkState = 15;
                        break;
                    }
                    case 0x2000000: {
                        atkState = 32;
                        break;
                    }
                    case 0x20000000: {
                        atkState = 33;
                        break;
                    }
                    case 0x40000000: {
                        atkState = 34;
                    }
                }
                if (atkState == -1) break;
                ATK.atk_object_notify_state_change(this.handle, atkState, value != 0);
                break;
            }
            case 32779: {
                List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
                int length = AccessibleObject.size(listeners);
                GdkRectangle rect = new GdkRectangle();
                if (length > 0) {
                    AccessibleControlEvent e = new AccessibleControlEvent(this.accessible);
                    e.childID = this.id;
                    int i = 0;
                    while (i < length) {
                        AccessibleControlListener listener = listeners.get(i);
                        listener.getLocation(e);
                        ++i;
                    }
                    rect.x = e.x;
                    rect.y = e.y;
                    rect.width = e.width;
                    rect.height = e.height;
                }
                OS.g_signal_emit_by_name(this.handle, ATK.bounds_changed, rect);
                break;
            }
            case 32780: {
                OS.g_object_notify(this.handle, ATK.accessible_name);
                break;
            }
            case 32781: {
                OS.g_object_notify(this.handle, ATK.accessible_description);
                break;
            }
            case 32782: {
                OS.g_object_notify(this.handle, ATK.accessible_value);
                break;
            }
            case 261: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_complete);
                break;
            }
            case 262: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_stopped);
                break;
            }
            case 263: {
                OS.g_signal_emit_by_name(this.handle, ATK.reload);
                break;
            }
            case 273: {
                break;
            }
            case 274: {
                break;
            }
            case 256: {
                break;
            }
            case 264: {
                OS.g_object_notify(this.handle, ATK.end_index);
                break;
            }
            case 265: {
                OS.g_object_notify(this.handle, ATK.number_of_anchors);
                break;
            }
            case 266: {
                OS.g_object_notify(this.handle, ATK.selected_link);
                break;
            }
            case 269: {
                OS.g_object_notify(this.handle, ATK.start_index);
                break;
            }
            case 267: {
                OS.g_signal_emit_by_name(this.handle, ATK.link_activated);
                break;
            }
            case 268: {
                if (!(eventData instanceof Integer)) break;
                int index = (Integer)eventData;
                OS.g_signal_emit_by_name(this.handle, ATK.link_selected, index);
                break;
            }
            case 271: {
                OS.g_object_notify(this.handle, ATK.accessible_hypertext_nlinks);
                break;
            }
            case 512: {
                OS.g_signal_emit_by_name(this.handle, ATK.attributes_changed);
                break;
            }
            case 515: {
                OS.g_object_notify(this.handle, ATK.accessible_table_caption_object);
                break;
            }
            case 516: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_description);
                break;
            }
            case 517: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_header);
                break;
            }
            case 518: {
                if (!(eventData instanceof int[])) break;
                int[] array = (int[])eventData;
                int type = array[0];
                int rowStart = array[1];
                int rowCount = array[2];
                int columnStart = array[3];
                int columnCount = array[4];
                switch (type) {
                    case 1: {
                        if (rowCount > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_deleted, rowStart, rowCount);
                        }
                        if (columnCount <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_deleted, columnStart, columnCount);
                        break;
                    }
                    case 0: {
                        if (rowCount > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_inserted, rowStart, rowCount);
                        }
                        if (columnCount <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_inserted, columnStart, columnCount);
                    }
                }
                break;
            }
            case 519: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_description);
                break;
            }
            case 520: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_header);
                break;
            }
            case 521: {
                OS.g_object_notify(this.handle, ATK.accessible_table_summary);
                break;
            }
            case 522: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_attributes_changed);
                break;
            }
            case 283: 
            case 285: {
                int offset = 0;
                List<AccessibleTextExtendedListener> listeners = this.accessible.accessibleTextExtendedListeners;
                int length = AccessibleObject.size(listeners);
                AccessibleTextEvent e = new AccessibleTextEvent(this.accessible);
                if (length > 0) {
                    int i = 0;
                    while (i < length) {
                        AccessibleTextListener listener = listeners.get(i);
                        listener.getCaretOffset(e);
                        ++i;
                    }
                } else {
                    List<AccessibleTextListener> listeners2 = this.accessible.accessibleTextListeners;
                    length = AccessibleObject.size(listeners2);
                    if (length > 0) {
                        e.childID = this.id;
                        int i = 0;
                        while (i < length) {
                            AccessibleTextListener listener = listeners2.get(i);
                            listener.getCaretOffset(e);
                            ++i;
                        }
                    }
                }
                offset = e.offset;
                OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, offset);
                break;
            }
            case 524: {
                if (!(eventData instanceof Object[])) break;
                Object[] data = (Object[])eventData;
                int type = (Integer)data[0];
                int start = (Integer)data[1];
                int end = (Integer)data[2];
                switch (type) {
                    case 1: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, start, end - start);
                        break block0;
                    }
                    case 0: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, start, end - start);
                    }
                }
            }
        }
    }

    void sendEvent(int event, Object eventData, int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            accObject.sendEvent(event, eventData);
        }
    }

    void setFocus(int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            OS.g_signal_emit_by_name(accObject.handle, ATK.focus_event, 1L, 0L);
            ATK.atk_object_notify_state_change(accObject.handle, 11, true);
        }
    }

    void textCaretMoved(int index) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, index);
    }

    void textChanged(int type, int startIndex, int length) {
        if (type == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, startIndex, length);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, startIndex, length);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
        int length = AccessibleObject.size(listeners);
        AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
        event.childID = this.id;
        int i = 0;
        while (i < length) {
            AccessibleControlListener listener = listeners.get(i);
            listener.getChildren(event);
            ++i;
        }
        Object[] children = event.children;
        AccessibleObject[] oldChildren = this.children;
        int count = children != null ? children.length : 0;
        AccessibleObject[] newChildren = new AccessibleObject[count];
        int i2 = 0;
        while (i2 < count) {
            Object child = children[i2];
            AccessibleObject object = null;
            if (child instanceof Integer) {
                int id = (Integer)child;
                AccessibleObject accessibleObject = object = oldChildren != null && i2 < oldChildren.length ? oldChildren[i2] : null;
                if (object == null || object.id != id) {
                    event = new AccessibleControlEvent(this.accessible);
                    event.childID = id;
                    int j = 0;
                    while (j < length) {
                        AccessibleControlListener listener = listeners.get(j);
                        listener.getChild(event);
                        ++j;
                    }
                    if (event.accessible != null) {
                        object = event.accessible.getAccessibleObject();
                        if (object != null) {
                            OS.g_object_ref(object.handle);
                        }
                    } else {
                        object = AccessibleFactory.createChildAccessible(this.accessible, id);
                    }
                    object.id = id;
                } else {
                    OS.g_object_ref(object.handle);
                }
            } else if (child instanceof Accessible && (object = ((Accessible)child).getAccessibleObject()) != null) {
                OS.g_object_ref(object.handle);
            }
            if (object != null) {
                object.index = i2;
                object.parent = this;
                newChildren[i2] = object;
            }
            ++i2;
        }
        if (oldChildren != null) {
            i2 = 0;
            while (i2 < oldChildren.length) {
                AccessibleObject object = oldChildren[i2];
                if (object != null) {
                    OS.g_object_unref(object.handle);
                }
                ++i2;
            }
        }
        this.children = newChildren;
    }
}

