/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.URIList;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Module;

public abstract class AbstractModuleTest {
    private final CseService cseService;
    private final Module module;
    private String moduleUrl = null;

    public static List<String> getListFromStringArray(String array) {
        String toBeTransformed = array;
        if ((toBeTransformed = toBeTransformed.substring(1, toBeTransformed.length() - 1)).length() > 0) {
            String[] values = toBeTransformed.split(",");
            int i = 0;
            while (i < values.length) {
                values[i] = values[i].trim();
                ++i;
            }
            return Arrays.asList(values);
        }
        return new ArrayList<String>();
    }

    public AbstractModuleTest(CseService pCseService, Module pModule) {
        this.cseService = pCseService;
        this.module = pModule;
        try {
            this.moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {}
    }

    protected boolean checkModuleUrl(TestReport report) {
        if (this.moduleUrl == null) {
            report.setErrorMessage("unable to find out flexContainer for module " + this.module.getName());
            report.setState(TestReport.State.KO);
            return false;
        }
        return true;
    }

    protected String getModuleUrl() {
        return this.moduleUrl;
    }

    protected Module getModule() {
        return this.module;
    }

    protected CseService getCseService() {
        return this.cseService;
    }

    protected String getModuleFlexContainerUrl() throws FlexContainerNotFound {
        System.out.println("getModuleFlexContainerUrl() - module=" + this.module.getName());
        String url = null;
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("name/" + this.module.getName());
        ResponsePrimitive responsePrimitive = CSEUtil.discovery(this.cseService, labels, "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        if (responsePrimitive.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            URIList discoveryResult = (URIList)responsePrimitive.getContent();
            if (discoveryResult.getListOfUri().size() == 1) {
                url = (String)discoveryResult.getListOfUri().get(0);
            } else {
                System.out.println("too much discoveryResult = " + discoveryResult.getListOfUri().size());
            }
        }
        if (url == null) {
            System.out.println("getModuleFlexContainerUrl() - module=" + this.module.getName() + " - NOT FOUND");
            throw new FlexContainerNotFound();
        }
        System.out.println("getModuleFlexContainerUrl() - module=" + this.module.getName() + " - url =" + url);
        return url;
    }

    public List<TestReport> launchTests() {
        Method[] methods;
        ArrayList<TestReport> reports = new ArrayList<TestReport>();
        Method[] methodArray = methods = this.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("test") && method.getReturnType() == TestReport.class) {
                TestReport report = null;
                try {
                    report = (TestReport)method.invoke((Object)this, null);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    report = new TestReport("Test module " + this.module.getName());
                    report.setErrorMessage("exception when invoking method " + method.getName() + " : " + e.getMessage());
                    report.setState(TestReport.State.KO);
                    report.setException(e);
                }
                reports.add(report);
            }
            ++n2;
        }
        return reports;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean checkObject(Object o1, Object o2, TestReport report, String attributeName) {
        if (o1 == null) {
            if (o2 == null) return true;
            report.setErrorMessage("attribute " + attributeName + ": o1 is null and o2 is not null");
            report.setState(TestReport.State.KO);
            return false;
        }
        if (!(o1 instanceof List)) {
            if (o1.equals(o2)) return true;
            report.setErrorMessage("attribute " + attributeName + ": o1 (" + o1 + ", o1.class=" + o1.getClass() + ") is not equal to o2(" + o2 + ", o2.class=" + o2.getClass() + ")");
            report.setState(TestReport.State.KO);
            return false;
        }
        if (o2 == null) {
            report.setErrorMessage("attribute " + attributeName + ": o1 is a list (" + o1 + ", o1.class=" + o1.getClass() + ")  and o2 is null");
            report.setState(TestReport.State.KO);
            return false;
        }
        if (((List)o1).size() != ((List)o2).size()) {
            report.setErrorMessage("attribute " + attributeName + ": o1 list  (" + o1 + ", o1.size=" + ((List)o1).size() + ")  has a different size from o2 (" + o2 + ", o2.size=" + ((List)o2).size() + ")");
            report.setState(TestReport.State.KO);
            return false;
        }
        for (Object o : (List)o1) {
            if (((List)o2).contains(o)) continue;
            report.setErrorMessage("attribute " + attributeName + ": o1 list  (" + o1 + ", o1.size=" + ((List)o1).size() + ")  missing element compared to o2 (" + o2 + ", o1.size=" + ((List)o2).size() + ")");
            report.setState(TestReport.State.KO);
            return false;
        }
        return true;
    }
}

