/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfo;
import org.eclipse.om2m.commons.resource.AreaNwkInfo;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.DeviceInfo;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.MgmtObjWithChildren;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class MgmtObjMapper
extends EntityMapper<MgmtObjEntity, MgmtObj> {
    @Override
    protected void mapAttributes(MgmtObjEntity entity, MgmtObj resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setCreationTime(entity.getCreationTime());
        resource.setDescription(entity.getDescription());
        resource.setExpirationTime(entity.getExpirationTime());
        resource.setLastModifiedTime(entity.getLastModifiedTime());
        resource.setName(entity.getName());
        resource.setParentID(entity.getParentID());
        resource.setResourceID(entity.getResourceID());
        resource.setResourceType(entity.getResourceType());
        if (entity instanceof AreaNwkInfoEntity) {
            this.mapSpecificAttributes((AreaNwkInfoEntity)entity, (AreaNwkInfo)resource);
        } else if (entity instanceof AreaNwkDeviceInfoEntity) {
            this.mapSpecificAttributes((AreaNwkDeviceInfoEntity)entity, (AreaNwkDeviceInfo)resource);
        } else if (entity instanceof DeviceInfoEntity) {
            this.mapSpecificAttributes((DeviceInfoEntity)entity, (DeviceInfo)resource);
        }
    }

    private void mapSpecificAttributes(AreaNwkInfoEntity entity, AreaNwkInfo resource) {
        resource.setAreaNwkType(entity.getAreaNwkType());
        if (!entity.getListOfDevices().isEmpty()) {
            resource.getListOfDevices().addAll(entity.getListOfDevices());
        }
    }

    private void mapSpecificAttributes(AreaNwkDeviceInfoEntity entity, AreaNwkDeviceInfo resource) {
        resource.setAreaNwkId(entity.getAreaNwkId());
        resource.setDevID(entity.getDevID());
        resource.setSleepDuration(entity.getSleepDuration());
        resource.setSleepInterval(entity.getSleepInterval());
        resource.setStatus(entity.getStatus());
    }

    private void mapSpecificAttributes(DeviceInfoEntity entity, DeviceInfo resource) {
        resource.setDeviceLabel(entity.getDeviceLabel());
        resource.setModel(entity.getModel());
        resource.setManufacturer(entity.getManufacturer());
        resource.setDeviceType(entity.getDeviceType());
        resource.setDeviceName(entity.getDeviceName());
        resource.setFwVersion(entity.getFwVersion());
        resource.setSwVersion(entity.getSwVersion());
        resource.setHwVersion(entity.getHwVersion());
        resource.setOsVersion(entity.getOsVersion());
        resource.setManufacturerDetailsLink(entity.getManufacturerDetailsLink());
        resource.setManufacturingDate(entity.getManufacturingDate());
        resource.setSubModel(entity.getSubModel());
        resource.setCountry(entity.getCountry());
        resource.setLocation(entity.getLocation());
        resource.setSystemTime(entity.getSystemTime());
        resource.setSupportURL(entity.getSupportURL());
        resource.setPresentationURL(entity.getPresentationURL());
        resource.setProtocol(entity.getProtocol());
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(MgmtObjEntity entity, int level, int offset) {
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            ChildResourceRef child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(MgmtObjEntity entity, MgmtObj resource, int level, int offset) {
        ((MgmtObjWithChildren)resource).getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(MgmtObjEntity entity, MgmtObj resource, int level, int offset) {
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES, level - 1, offset - 1);
            ((MgmtObjWithChildren)resource).getSubscriptions().add(subRes);
        }
    }

    @Override
    protected MgmtObj createResource(MgmtObjEntity entity) {
        if (entity instanceof AreaNwkInfoEntity) {
            return new AreaNwkInfo();
        }
        if (entity instanceof AreaNwkDeviceInfoEntity) {
            return new AreaNwkDeviceInfo();
        }
        if (entity instanceof DeviceInfoEntity) {
            return new DeviceInfo();
        }
        return null;
    }

    @Override
    protected MgmtObj createResource() {
        return null;
    }
}

