/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Grinder
extends Module {
    private BooleanDataPoint useGrinder;
    private IntegerDataPoint coarseness;

    public Grinder(String name, Domain domain, BooleanDataPoint useGrinder, IntegerDataPoint coarseness) {
        super(name, domain, (Identifiers)ModuleType.grinder);
        this.setExtends(domain.getName(), "Grinder");
        if (useGrinder == null || !useGrinder.getShortDefinitionType().equals(DatapointType.useGrinder.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong useGrinder datapoint: " + useGrinder);
        }
        this.useGrinder = useGrinder;
        this.useGrinder.setDoc("The current status of the grinder enablement");
        this.addDataPoint((DataPoint)this.useGrinder);
        if (coarseness == null || !coarseness.getShortDefinitionType().equals(DatapointType.coarseness.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong coarseness datapoint: " + coarseness);
        }
        this.coarseness = coarseness;
        this.coarseness.setDoc("The current coarseness of the object after grinding.");
        this.addDataPoint((DataPoint)this.coarseness);
    }

    public Grinder(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.useGrinder.getShortName()), (IntegerDataPoint)dps.get(DatapointType.coarseness.getShortName()));
    }

    public boolean getUseGrinder() throws DataPointException, AccessException {
        return (Boolean)this.useGrinder.getValue();
    }

    public void setUseGrinder(boolean v) throws DataPointException, AccessException {
        this.useGrinder.setValue((Object)v);
    }

    public int getGrindCoarsenes() throws DataPointException, AccessException {
        return (Integer)this.coarseness.getValue();
    }

    public void setGrindCoarsenes(int v) throws DataPointException, AccessException {
        this.coarseness.setValue((Object)v);
    }
}

