/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class FaultDetection
extends Module {
    private BooleanDataPoint status;
    private IntegerDataPoint code;
    private StringDataPoint description;

    public FaultDetection(String name, Domain domain, BooleanDataPoint status) {
        super(name, domain, (Identifiers)ModuleType.faultDetection);
        if (status == null || !status.getShortDefinitionType().equals(DatapointType.status.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong status datapoint: " + status);
        }
        this.status = status;
        this.status.setWritable(false);
        this.status.setDoc("Status of fault detection");
        this.addDataPoint((DataPoint)this.status);
    }

    public FaultDetection(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.status.getShortName()));
        StringDataPoint description;
        IntegerDataPoint code = (IntegerDataPoint)dps.get(DatapointType.code.getShortName());
        if (code != null) {
            this.setCode(code);
        }
        if ((description = (StringDataPoint)dps.get(DatapointType.description.getShortName())) != null) {
            this.setDescription(description);
        }
    }

    public boolean getStatus() throws DataPointException, AccessException {
        return (Boolean)this.status.getValue();
    }

    public int getCode() throws DataPointException, AccessException {
        if (this.code == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.code.getValue();
    }

    public void setCode(IntegerDataPoint dp) {
        this.code = dp;
        this.code.setOptional(true);
        this.code.setWritable(false);
        this.code.setDoc("Code of the fault.");
        this.addDataPoint((DataPoint)this.code);
    }

    public String getDescription() throws DataPointException, AccessException {
        if (this.description == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.description.getValue();
    }

    public void setDescription(StringDataPoint dp) {
        this.description = dp;
        this.description.setOptional(true);
        this.description.setWritable(false);
        this.description.setDoc("Message of the fault.");
        this.addDataPoint((DataPoint)this.description);
    }
}

