/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.exceptions.ModuleException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Colour;
import org.eclipse.om2m.sdt.home.modules.ColourSaturation;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.RunMode;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class Light
extends GenericDevice {
    private FaultDetection faultDetection;
    private BinarySwitch binarySwitch;
    private RunMode runMode;
    private Colour colour;
    private ColourSaturation colourSaturation;

    public Light(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceLight, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof RunMode) {
            this.addModule((RunMode)module);
        } else if (module instanceof Colour) {
            this.addModule((Colour)module);
        } else if (module instanceof ColourSaturation) {
            this.addModule((ColourSaturation)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(Colour mod) {
        this.colour = mod;
        super.addModule((Module)this.colour);
    }

    public void addModule(ColourSaturation mod) {
        this.colourSaturation = mod;
        super.addModule((Module)this.colourSaturation);
    }

    public void addModule(FaultDetection mod) {
        this.faultDetection = mod;
        super.addModule((Module)this.faultDetection);
    }

    public void addModule(BinarySwitch mod) {
        this.binarySwitch = mod;
        super.addModule((Module)this.binarySwitch);
    }

    public void addModule(RunMode mod) {
        this.runMode = mod;
        super.addModule((Module)this.runMode);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public BinarySwitch getBinarySwitch() throws ModuleException {
        if (this.binarySwitch == null) {
            throw new ModuleException("Not implemented");
        }
        return this.binarySwitch;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public Colour getColour() {
        return this.colour;
    }

    public ColourSaturation getColourSaturation() {
        return this.colourSaturation;
    }
}

