/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoAnncEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity(name="NODEA")
public class NodeAnncEntity
extends AnnouncedResourceEntity {
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="NODANNC_ACP_JOIN", joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> linkedAcps;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedNodeAnncEntities")
    @JoinTable(name="NODANNC_DAC_JOIN", joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @Column(name="ni")
    protected String nodeID;
    @Column(name="hcl")
    protected String hostedCSELink;
    @Column(name="hsl")
    protected String hostedServiceLinks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CSB_NODANNC_CH_JOIN", joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCsb;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CSR_NODANNC_CH_JOIN", joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="NODANNC_SUB_JOIN", joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> childSubscriptions;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ANI_NODANNC_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkInfoAnncEntity> childAreaNwkInfoEntities;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ANDI_NODANNC_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkDeviceInfoAnncEntity> childAreaNwkDeviceInfoEntities;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="DVI_NODANNC_JOIN", inverseJoinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")})
    protected List<DeviceInfoAnncEntity> childDeviceInfoEntities;

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.linkedAcps == null) {
            this.linkedAcps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.linkedAcps;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.linkedAcps = accessControlPolicies;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public String getHostedCSELink() {
        return this.hostedCSELink;
    }

    public void setHostedCSELink(String hostedCSELink) {
        this.hostedCSELink = hostedCSELink;
    }

    public String getHostedServiceLinks() {
        return this.hostedServiceLinks;
    }

    public void setHostedServiceLinks(String hostedServiceLinks) {
        this.hostedServiceLinks = hostedServiceLinks;
    }

    public CSEBaseEntity getParentCsb() {
        return this.parentCsb;
    }

    public void setParentCsb(CSEBaseEntity parentCsb) {
        this.parentCsb = parentCsb;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<SubscriptionEntity> getChildSubscriptions() {
        return this.childSubscriptions;
    }

    public void setChildSubscriptions(List<SubscriptionEntity> childSubscriptions) {
        this.childSubscriptions = childSubscriptions;
    }

    public List<AreaNwkInfoAnncEntity> getChildAreaNwkInfoEntities() {
        if (this.childAreaNwkInfoEntities == null) {
            this.childAreaNwkInfoEntities = new ArrayList<AreaNwkInfoAnncEntity>();
        }
        return this.childAreaNwkInfoEntities;
    }

    public void setChildAreaNwkInfoAnncEntities(List<AreaNwkInfoAnncEntity> childAreaNwkInfoEntities) {
        this.childAreaNwkInfoEntities = childAreaNwkInfoEntities;
    }

    public List<AreaNwkDeviceInfoAnncEntity> getChildAreaNwkDeviceInfoEntities() {
        if (this.childAreaNwkDeviceInfoEntities == null) {
            this.childAreaNwkDeviceInfoEntities = new ArrayList<AreaNwkDeviceInfoAnncEntity>();
        }
        return this.childAreaNwkDeviceInfoEntities;
    }

    public void setChildAreaNwkDeviceInfoAnncEntities(List<AreaNwkDeviceInfoAnncEntity> childAreaNwkDeviceInfoEntities) {
        this.childAreaNwkDeviceInfoEntities = childAreaNwkDeviceInfoEntities;
    }

    public List<DeviceInfoAnncEntity> getChildDeviceInfoEntities() {
        if (this.childDeviceInfoEntities == null) {
            this.childDeviceInfoEntities = new ArrayList<DeviceInfoAnncEntity>();
        }
        return this.childDeviceInfoEntities;
    }

    public void setChildDeviceInfoAnncEntities(List<DeviceInfoAnncEntity> childDeviceInfoEntities) {
        this.childDeviceInfoEntities = childDeviceInfoEntities;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    public List<MgmtObjAnncEntity> getMgmtObjEntities() {
        ArrayList<MgmtObjAnncEntity> ret = new ArrayList<MgmtObjAnncEntity>();
        ret.addAll(this.getChildAreaNwkInfoEntities());
        ret.addAll(this.getChildAreaNwkDeviceInfoEntities());
        ret.addAll(this.getChildDeviceInfoEntities());
        return ret;
    }

    public void addMgmtObj(MgmtObjAnncEntity mgmtObj) {
        BigInteger mgmtDef = mgmtObj.getMgmtDefinition();
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.getChildAreaNwkInfoEntities().add((AreaNwkInfoAnncEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.getChildAreaNwkDeviceInfoEntities().add((AreaNwkDeviceInfoAnncEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.getChildDeviceInfoEntities().add((DeviceInfoAnncEntity)mgmtObj);
        }
    }

    public void removeMgmtObj(MgmtObjAnncEntity mgmtObj) {
        BigInteger mgmtDef = mgmtObj.getMgmtDefinition();
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.getChildAreaNwkInfoEntities().remove((AreaNwkInfoAnncEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.getChildAreaNwkDeviceInfoEntities().remove((AreaNwkDeviceInfoAnncEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.getChildDeviceInfoEntities().remove((DeviceInfoAnncEntity)mgmtObj);
        }
    }
}

