/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.IStatementsGenerator;

public abstract class AbstractStatementsGenerator
implements IStatementsGenerator {
    private List<Statement> prefixStats = null;

    @Override
    public void prepend(List<Statement> newStatements) {
        this.prefixStats = newStatements;
    }

    protected abstract boolean generateStatements(AbstractMethodDeclaration var1);

    @Override
    public boolean generateAllStatements(AbstractMethodDeclaration methodDecl) {
        if (!this.generateStatements(methodDecl)) {
            return false;
        }
        if (this.prefixStats == null) {
            return true;
        }
        int len1 = this.prefixStats.size();
        int len2 = methodDecl.statements.length;
        Statement[] newStats = new Statement[len1 + len2];
        this.prefixStats.toArray(newStats);
        System.arraycopy(methodDecl.statements, 0, newStats, len1, len2);
        methodDecl.statements = newStats;
        return true;
    }
}

