/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.GuardPredicateDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class RecoveredMethodMapping
extends RecoveredElement
implements TerminalTokens {
    public AbstractMethodMappingDeclaration methodMappingDeclaration;
    public RecoveredMethod[] baseMethods;
    int baseMethodCount = 0;
    public boolean foundBase = false;

    public RecoveredMethodMapping(AbstractMethodMappingDeclaration methodMapping, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(parent, bracketBalance, parser);
        this.methodMappingDeclaration = methodMapping;
        this.foundOpeningBrace = false;
    }

    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        if (this.methodMappingDeclaration.declarationSourceEnd > 0 && nestedBlockDeclaration.sourceStart > this.methodMappingDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(nestedBlockDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        AstGenerator gen = new AstGenerator(statement.sourceStart, statement.sourceEnd);
        GuardPredicateDeclaration predicate = null;
        if (this.methodMappingDeclaration instanceof CallinMappingDeclaration) {
            predicate = ((CallinMappingDeclaration)this.methodMappingDeclaration).predicate;
        }
        if (predicate == null) {
            predicate = new GuardPredicateDeclaration(this.methodMappingDeclaration.compilationResult, this.foundBase ? IOTConstants.BASE_PREDICATE_PREFIX : IOTConstants.PREDICATE_METHOD_NAME, this.foundBase, statement.sourceStart - 5, statement.sourceStart - 1);
            if (this.foundBase) {
                long poss = ((long)statement.sourceStart << 32) + (long)statement.sourceStart + 1L;
                Argument targetArg = new Argument(IOTConstants.BASE, poss, new SingleTypeReference("_OT$unknownBaseType".toCharArray(), poss), 16);
                predicate.arguments = new Argument[]{targetArg};
            }
            predicate.returnType = gen.typeReference(TypeBinding.BOOLEAN);
        }
        if (statement instanceof FieldDeclaration) {
            predicate.statements = new Statement[]{((FieldDeclaration)statement).initialization};
        } else if (statement instanceof Expression) {
            predicate.updatePredicateExpression((Expression)statement, statement.sourceEnd + 1);
        }
        this.parent.add(predicate, bracketBalanceValue);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecoveredElement add(AbstractMethodDeclaration methodDeclaration, int bracketBalanceValue) {
        Scanner scanner = this.parser().scanner;
        int saveCurrent = scanner.currentPosition;
        int saveStart = scanner.startPosition;
        try {
            int nextToken = scanner.getNextToken();
            switch (nextToken) {
                case 74: 
                case 75: 
                case 79: {
                    RecoveredElement recoveredElement = super.add(methodDeclaration, bracketBalanceValue);
                    return recoveredElement;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
        }
        finally {
            scanner.currentPosition = saveCurrent;
            scanner.startPosition = saveStart;
        }
        if (!(methodDeclaration instanceof MethodDeclaration)) {
            return this.parent;
        }
        if (this.baseMethods == null) {
            this.baseMethods = new RecoveredMethod[5];
            this.baseMethodCount = 0;
        } else if (this.baseMethodCount == this.baseMethods.length) {
            this.baseMethods = new RecoveredMethod[2 * this.baseMethodCount];
            System.arraycopy(this.baseMethods, 0, this.baseMethods, 0, this.baseMethodCount);
        }
        RecoveredMethod element = new RecoveredMethod(methodDeclaration, this, bracketBalanceValue, this.recoveringParser);
        this.baseMethods[this.baseMethodCount++] = element;
        if (methodDeclaration.declarationSourceEnd != 0) return this;
        return element;
    }

    public void addMethodSpec(MethodSpec methodSpec) {
        if (this.foundOpeningBrace) {
            return;
        }
        if (this.methodMappingDeclaration.isCallout()) {
            ((CalloutMappingDeclaration)this.methodMappingDeclaration).baseMethodSpec = methodSpec;
        } else {
            CallinMappingDeclaration mapping = (CallinMappingDeclaration)this.methodMappingDeclaration;
            if (this.baseMethodCount == 0) {
                mapping.baseMethodSpecs = new MethodSpec[]{methodSpec};
                ++this.baseMethodCount;
            } else {
                mapping.baseMethodSpecs = new MethodSpec[this.baseMethodCount + 1];
                System.arraycopy(mapping.baseMethodSpecs, 0, mapping.baseMethodSpecs, 0, this.baseMethodCount);
                mapping.baseMethodSpecs[this.baseMethodCount++] = methodSpec;
            }
        }
    }

    public RecoveredElement add(AbstractMethodMappingDeclaration methodMapping, int bracketBalanceValue) {
        if (this.foundOpeningBrace) {
            return this;
        }
        return super.add(methodMapping, bracketBalanceValue);
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        switch (this.parser().currentToken) {
            case 75: 
            case 79: {
                return this;
            }
        }
        return super.add(fieldDeclaration, bracketBalanceValue);
    }

    public ASTNode parseTree() {
        return this.methodMappingDeclaration;
    }

    public int sourceEnd() {
        return this.methodMappingDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered method mapping:\n");
        this.methodMappingDeclaration.print(tab + 1, result);
        int i = 0;
        while (i < this.baseMethodCount) {
            result.append(this.baseMethods[i].toString(tab + 1));
            ++i;
        }
        return result.toString();
    }

    public void updateBodyStart(int bodyStart) {
        this.foundOpeningBrace = true;
        this.methodMappingDeclaration.bodyStart = bodyStart;
    }

    public AbstractMethodMappingDeclaration updatedMethodMappingDeclaration(int bodyEnd) {
        MethodSpec[] baseMethodSpecs = this.methodMappingDeclaration.getBaseMethodSpecs();
        int existingCount = baseMethodSpecs == null ? null : Integer.valueOf(baseMethodSpecs.length);
        if (this.baseMethodCount > existingCount) {
            if (this.methodMappingDeclaration.isCallout()) {
                CalloutMappingDeclaration callout = (CalloutMappingDeclaration)this.methodMappingDeclaration;
                callout.baseMethodSpec = new MethodSpec(this.baseMethods[0].methodDeclaration);
            } else {
                CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)this.methodMappingDeclaration;
                callinMapping.baseMethodSpecs = new MethodSpec[this.baseMethodCount];
                int i = 0;
                while (i < this.baseMethodCount) {
                    callinMapping.baseMethodSpecs[i] = new MethodSpec(this.baseMethods[i].methodDeclaration);
                    ++i;
                }
            }
        }
        if (this.methodMappingDeclaration.declarationSourceEnd <= this.methodMappingDeclaration.declarationSourceStart && bodyEnd > this.methodMappingDeclaration.declarationSourceStart) {
            this.methodMappingDeclaration.declarationSourceEnd = bodyEnd;
        }
        if (this.methodMappingDeclaration.isCallin()) {
            CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)this.methodMappingDeclaration;
            if (callinDecl.predicate != null && callinDecl.predicate.bodyStart == 0) {
                Parser parser = this.parser();
                if (parser.expressionPtr > -1) {
                    parser.consumePredicateExpression();
                } else {
                    callinDecl.predicate.tagAsHavingErrors();
                }
            }
        }
        return this.methodMappingDeclaration;
    }

    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(braceStart, braceEnd);
    }

    public void updateParseTree() {
        this.updatedMethodMappingDeclaration(-1);
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        Parser parser = this.parser();
        if (this.baseMethodCount == 0 && parser.identifierPtr > -1) {
            MethodSpec baseSpec = null;
            if (this.methodMappingDeclaration.isCallin() || ((CalloutMappingDeclaration)this.methodMappingDeclaration).baseMethodSpec == null) {
                if (this.methodMappingDeclaration.hasSignature) {
                    boolean identifierAvailable;
                    if (parser.identifierPtr > 0) {
                        baseSpec = new MethodSpec(parser.identifierStack[parser.identifierPtr], parser.identifierPositionStack[parser.identifierPtr--]);
                        --parser.identifierLengthPtr;
                    } else {
                        baseSpec = new MethodSpec("missing".toCharArray(), parser.identifierPositionStack[parser.identifierPtr]);
                    }
                    baseSpec.hasSignature = true;
                    boolean bl = identifierAvailable = parser.identifierLengthPtr > -1 && parser.identifierLengthStack[parser.identifierLengthPtr] < 0 || parser.genericsIdentifiersLengthPtr > -1 && parser.genericsIdentifiersLengthStack[parser.genericsIdentifiersLengthPtr] > 0;
                    if (identifierAvailable) {
                        baseSpec.returnType = parser.getTypeReference(0);
                        baseSpec.declarationSourceStart = baseSpec.returnType.sourceStart;
                    }
                } else {
                    baseSpec = new MethodSpec(parser.identifierStack[parser.identifierPtr], parser.identifierPositionStack[parser.identifierPtr--]);
                    --parser.identifierLengthPtr;
                }
                this.methodMappingDeclaration.checkAddBasemethodSpec(baseSpec);
            }
        }
        if (!this.foundOpeningBrace) {
            this.updateSourceEndIfNecessary(braceStart - 1, braceStart - 1);
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return super.updateOnClosingBrace(braceStart, braceEnd);
    }

    public void updateSourceEndIfNecessary(int braceStart, int braceEnd) {
        MethodSpec[] baseMethodSpecs;
        if (this.methodMappingDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= braceEnd) {
                this.methodMappingDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodMappingDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodMappingDeclaration.declarationSourceEnd = braceEnd;
                this.methodMappingDeclaration.bodyEnd = braceStart - 1;
            }
        }
        if ((baseMethodSpecs = this.methodMappingDeclaration.getBaseMethodSpecs()) != null && baseMethodSpecs.length == 1) {
            MethodSpec baseMethod = baseMethodSpecs[0];
            if (baseMethod.sourceStart >= braceStart) {
                int start = baseMethod.sourceStart - 1;
                MethodSpec newSpec = this.parser().newMethodSpec(new char[0], ((long)start << 32) + (long)start);
                if (this.methodMappingDeclaration.isCallin()) {
                    ((CallinMappingDeclaration)this.methodMappingDeclaration).baseMethodSpecs = new MethodSpec[]{newSpec};
                } else {
                    ((CalloutMappingDeclaration)this.methodMappingDeclaration).baseMethodSpec = newSpec;
                }
            }
        }
    }

    public void setCallinModifier(int tokenID, int start, int end) {
        if (this.methodMappingDeclaration instanceof CallinMappingDeclaration) {
            CallinMappingDeclaration decl = (CallinMappingDeclaration)this.methodMappingDeclaration;
            decl.callinModifier = tokenID;
            decl.modifierStart = start;
            decl.modifierEnd = end;
        }
    }
}

