/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public final class ColumnChooserUtils {
    public static final String RENAMED_COLUMN_INDICATOR = "*";

    private ColumnChooserUtils() {
    }

    public static void hideColumnEntries(List<ColumnEntry> removedItems, ColumnHideShowLayer hideShowLayer) {
        MultiColumnHideCommand hideCommand = new MultiColumnHideCommand((ILayer)hideShowLayer, ObjectUtils.asIntArray(ColumnChooserUtils.getColumnEntryPositions(removedItems)));
        hideShowLayer.doCommand(hideCommand);
    }

    public static void hideColumnPositions(List<Integer> removedPositions, ColumnHideShowLayer hideShowLayer) {
        MultiColumnHideCommand hideCommand = new MultiColumnHideCommand((ILayer)hideShowLayer, ObjectUtils.asIntArray(removedPositions));
        hideShowLayer.doCommand(hideCommand);
    }

    public static void showColumnEntries(List<ColumnEntry> addedItems, ColumnHideShowLayer hideShowLayer) {
        hideShowLayer.doCommand(new MultiColumnShowCommand(ColumnChooserUtils.getColumnEntryIndexes(addedItems)));
    }

    public static void showColumnIndexes(List<Integer> addedColumnIndexes, ColumnHideShowLayer hideShowLayer) {
        hideShowLayer.doCommand(new MultiColumnShowCommand(addedColumnIndexes));
    }

    public static List<ColumnEntry> getHiddenColumnEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        int[] hiddenColumnIndexes = columnHideShowLayer.getHiddenColumnIndexesArray();
        ArrayList<ColumnEntry> hiddenColumnEntries = new ArrayList<ColumnEntry>();
        int[] nArray = hiddenColumnIndexes;
        int n = hiddenColumnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int hiddenColumnIndex = nArray[n2];
            String label = ColumnChooserUtils.getColumnLabel(columnHeaderLayer, columnHeaderDataLayer, hiddenColumnIndex);
            ColumnEntry columnEntry = new ColumnEntry(label, hiddenColumnIndex, -1);
            hiddenColumnEntries.add(columnEntry);
            ++n2;
        }
        return hiddenColumnEntries;
    }

    public static String getColumnLabel(ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, Integer columnIndex) {
        Object label = "";
        if (columnHeaderLayer.isColumnRenamed(columnIndex)) {
            label = columnHeaderLayer.getRenamedColumnLabelByIndex(columnIndex) + RENAMED_COLUMN_INDICATOR;
        } else {
            int position = columnHeaderDataLayer.getColumnPositionByIndex(columnIndex);
            label = columnHeaderDataLayer.getDataValueByPosition(position, 0).toString();
        }
        return label;
    }

    public static List<ColumnEntry> getVisibleColumnsEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        int visibleColumnCount = columnHideShowLayer.getColumnCount();
        ArrayList<ColumnEntry> visibleColumnEntries = new ArrayList<ColumnEntry>();
        int i = 0;
        while (i < visibleColumnCount) {
            int index = columnHideShowLayer.getColumnIndexByPosition(i);
            String label = ColumnChooserUtils.getColumnLabel(columnHeaderLayer, columnHeaderDataLayer, index);
            ColumnEntry columnEntry = new ColumnEntry(label, index, i);
            visibleColumnEntries.add(columnEntry);
            ++i;
        }
        return visibleColumnEntries;
    }

    public static ColumnEntry find(List<ColumnEntry> entries, int indexToFind) {
        return entries.stream().filter(entry -> entry.getIndex() == indexToFind).findFirst().orElse(null);
    }

    public static List<Integer> getColumnEntryPositions(List<ColumnEntry> columnEntries) {
        return columnEntries.stream().map(ColumnEntry::getPosition).collect(Collectors.toList());
    }

    public static List<Integer> getColumnEntryIndexes(List<ColumnEntry> columnEntries) {
        return columnEntries.stream().map(ColumnEntry::getIndex).collect(Collectors.toList());
    }

    public static boolean containsIndex(List<ColumnEntry> entries, int indexToFind) {
        return entries.stream().anyMatch(entry -> entry.getIndex() == indexToFind);
    }
}

