/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;

public class AggregateConfigLabelAccumulator
implements IConfigLabelProvider {
    private List<IConfigLabelAccumulator> accumulators = new ArrayList<IConfigLabelAccumulator>();

    public void add(IConfigLabelAccumulator r) {
        if (r == null) {
            throw new IllegalArgumentException("IConfigLabelAccumulator can not be null");
        }
        this.accumulators.add(r);
    }

    public void add(IConfigLabelAccumulator ... r) {
        if (r == null) {
            throw new IllegalArgumentException("IConfigLabelAccumulator can not be null");
        }
        this.accumulators.addAll(Arrays.asList(r));
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        for (IConfigLabelAccumulator accumulator : this.accumulators) {
            accumulator.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
        }
    }

    @Override
    public Collection<String> getProvidedLabels() {
        HashSet<String> result = new HashSet<String>();
        for (IConfigLabelAccumulator accumulator : this.accumulators) {
            if (!(accumulator instanceof IConfigLabelProvider)) continue;
            result.addAll(((IConfigLabelProvider)accumulator).getProvidedLabels());
        }
        return result;
    }
}

