/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.LongCharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.LongToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.primitive.ImmutableLongCharMap;
import org.eclipse.collections.api.map.primitive.LongCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongCharMap;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongCharPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharLongMaps;
import org.eclipse.collections.impl.factory.primitive.LongCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableCharValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableLongKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableLongMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableLongKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongCharMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableLongCharMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class LongCharHashMap
extends AbstractMutableCharValuesMap
implements MutableLongCharMap,
Externalizable,
MutableLongKeysMap {
    private static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableCharValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public LongCharHashMap() {
        this.allocateTable(16);
    }

    public LongCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public LongCharHashMap(LongCharMap map) {
        if (map instanceof LongCharHashMap && ((LongCharHashMap)map).occupiedWithSentinels == 0) {
            LongCharHashMap hashMap = (LongCharHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static LongCharHashMap newWithKeysValues(long key1, char value1) {
        return new LongCharHashMap(1).withKeyValue(key1, value1);
    }

    public static LongCharHashMap newWithKeysValues(long key1, char value1, long key2, char value2) {
        return new LongCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongCharHashMap newWithKeysValues(long key1, char value1, long key2, char value2, long key3, char value3) {
        return new LongCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongCharHashMap newWithKeysValues(long key1, char value1, long key2, char value2, long key3, char value3, long key4, char value4) {
        return new LongCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected char getEmptyValue() {
        return '\u0000';
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected char getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongCharMap)) {
            return false;
        }
        LongCharMap other = (LongCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += '\u0000' ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += '\u0001' ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0L).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1L).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongCharHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableCharIterator charIterator() {
        return new InternalCharIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, '\u0000');
    }

    @Override
    public void put(long key, char value) {
        if (LongCharHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(LongCharMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(LongCharToCharFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(long key) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(long key) {
        this.removeKey(key);
    }

    @Override
    public char removeKeyIfAbsent(long key, char value) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            char oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public char getIfAbsentPut(long key, char value) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getIfAbsentPut(long key, CharFunction0 function) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        char value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> char getIfAbsentPutWith(long key, CharFunction<? super P> function, P parameter) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.charValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.charValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        char value = function.charValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getIfAbsentPutWithKey(long key, LongToCharFunction function) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        char value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char addToValue(long key, char toBeAdded) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (char)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (char)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (char)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(long key, char value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1L;
        this.values[index] = '\u0000';
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        long[] copy = new long[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public char updateValue(long key, char initialValueIfAbsent, CharToCharFunction function) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        char value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public LongCharHashMap withKeyValue(long key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public LongCharHashMap withKeysValues(long key1, char value1, long key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongCharHashMap withKeysValues(long key1, char value1, long key2, char value2, long key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongCharHashMap withKeysValues(long key1, char value1, long key2, char value2, long key3, char value3, long key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public LongCharHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public LongCharHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableLongCharMap asUnmodifiable() {
        return new UnmodifiableLongCharMap(this);
    }

    @Override
    public MutableLongCharMap asSynchronized() {
        return new SynchronizedLongCharMap(this);
    }

    @Override
    public ImmutableLongCharMap toImmutable() {
        return LongCharMaps.immutable.ofAll(this);
    }

    @Override
    public char get(long key) {
        return this.getIfAbsent(key, '\u0000');
    }

    @Override
    public char getIfAbsent(long key, char ifAbsent) {
        if (LongCharHashMap.isEmptyKey(key) || LongCharHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private char getForSentinel(long key, char ifAbsent) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private char slowGetIfAbsent(long key, char ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private char fastGetIfAbsent(long key, char ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 4; ++i) {
            long keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0L) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private char slowGetIfAbsentTwo(long key, char ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public char getOrThrow(long key) {
        if (LongCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(long key) {
        if (LongCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(LongCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyLongIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<LongCharPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableCharLongMap flipUniqueValues() {
        MutableCharLongMap result = CharLongMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public LongCharHashMap select(LongCharPredicate predicate) {
        LongCharHashMap result = new LongCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public LongCharHashMap reject(LongCharPredicate predicate) {
        LongCharHashMap result = new LongCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(long element) {
        int index = this.mask((int)element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(long element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            long keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(long element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.longSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
        long keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(long element) {
        long code = SpreadFunctions.longSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(long element) {
        long code = SpreadFunctions.longSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongCharHashMap.isEmptyKey(key) && !LongCharHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !LongCharHashMap.isEmptyKey(this.keys[index]) && !LongCharHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableLongSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ long[] access$302(LongCharHashMap x0, long[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ char[] access$502(LongCharHashMap x0, char[] x1) {
        x0.values = x1;
        return x1;
    }

    private class InternalCharIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private long lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalCharIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < LongCharHashMap.this.size();
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongCharHashMap.this.containsKey(0L)) {
                    this.lastKey = 0L;
                    return LongCharHashMap.this.get(0L);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongCharHashMap.this.containsKey(1L)) {
                    this.lastKey = 1L;
                    return LongCharHashMap.this.get(1L);
                }
            }
            long[] keys = LongCharHashMap.this.keys;
            while (!LongCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            char result = LongCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            LongCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    extends AbstractMutableLongKeySet {
        private KeySet() {
        }

        @Override
        protected MutableLongKeysMap getOuter() {
            return LongCharHashMap.this;
        }

        @Override
        protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
            return LongCharHashMap.this.sentinelValues;
        }

        @Override
        protected long getKeyAtIndex(int index) {
            return LongCharHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return LongCharHashMap.this.keys.length;
        }

        @Override
        public MutableLongIterator longIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(LongIterable source) {
            int oldSize = LongCharHashMap.this.size();
            LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            LongCharHashMap retained = LongCharHashMap.this.select((long key, char value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                LongCharHashMap.access$302(LongCharHashMap.this, retained.keys);
                LongCharHashMap.access$502(LongCharHashMap.this, retained.values);
                LongCharHashMap.this.sentinelValues = retained.sentinelValues;
                LongCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(long ... source) {
            return this.retainAll(LongHashSet.newSetWith(source));
        }

        @Override
        public LongSet freeze() {
            LongCharHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (LongCharHashMap.this.sentinelValues != null) {
                containsZeroKey = ((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableLongMapKeySet(LongCharHashMap.this.keys, LongCharHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableLongSet newEmpty() {
            return new LongHashSet();
        }
    }

    private class KeySetIterator
    implements MutableLongIterator {
        private int count;
        private int position;
        private long lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < LongCharHashMap.this.size();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongCharHashMap.this.containsKey(0L)) {
                    this.lastKey = 0L;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongCharHashMap.this.containsKey(1L)) {
                    this.lastKey = 1L;
                    return this.lastKey;
                }
            }
            long[] keys = LongCharHashMap.this.keys;
            while (!LongCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            LongCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongCharPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super LongCharPair> procedure) {
            if (LongCharHashMap.this.sentinelValues != null) {
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.zeroValue));
                }
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongCharHashMap.this.keys.length; ++i) {
                if (!LongCharHashMap.isNonSentinel(LongCharHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(LongCharHashMap.this.keys[i], LongCharHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super LongCharPair> objectIntProcedure) {
            int index = 0;
            if (LongCharHashMap.this.sentinelValues != null) {
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongCharHashMap.this.keys.length; ++i) {
                if (!LongCharHashMap.isNonSentinel(LongCharHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(LongCharHashMap.this.keys[i], LongCharHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super LongCharPair, ? super P> procedure, P parameter) {
            if (LongCharHashMap.this.sentinelValues != null) {
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongCharHashMap.this.keys.length; ++i) {
                if (!LongCharHashMap.isNonSentinel(LongCharHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(LongCharHashMap.this.keys[i], LongCharHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<LongCharPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<LongCharPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongCharPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongCharHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongCharHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, ((LongCharHashMap)LongCharHashMap.this).sentinelValues.oneValue);
                    }
                }
                long[] keys = LongCharHashMap.this.keys;
                while (!LongCharHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongCharPair result = PrimitiveTuples.pair(keys[this.position], LongCharHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongCharHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        @Override
        public LongIterator longIterator() {
            return new UnmodifiableLongIterator(new KeySetIterator());
        }

        @Override
        public void each(LongProcedure procedure) {
            LongCharHashMap.this.forEachKey(procedure);
        }
    }

    private class ValuesCollection
    extends AbstractMutableCharValuesMap.AbstractCharValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableCharIterator charIterator() {
            return LongCharHashMap.this.charIterator();
        }

        @Override
        public boolean remove(char item) {
            int oldSize = LongCharHashMap.this.size();
            if (LongCharHashMap.this.sentinelValues != null) {
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsZeroKey && item == ((LongCharHashMap)LongCharHashMap.this).sentinelValues.zeroValue) {
                    LongCharHashMap.this.removeKey(0L);
                }
                if (((LongCharHashMap)LongCharHashMap.this).sentinelValues.containsOneKey && item == ((LongCharHashMap)LongCharHashMap.this).sentinelValues.oneValue) {
                    LongCharHashMap.this.removeKey(1L);
                }
            }
            for (int i = 0; i < LongCharHashMap.this.keys.length; ++i) {
                if (!LongCharHashMap.isNonSentinel(LongCharHashMap.this.keys[i]) || item != LongCharHashMap.this.values[i]) continue;
                LongCharHashMap.this.removeKey(LongCharHashMap.this.keys[i]);
            }
            return oldSize != LongCharHashMap.this.size();
        }

        @Override
        public boolean retainAll(CharIterable source) {
            int oldSize = LongCharHashMap.this.size();
            CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            LongCharHashMap retained = LongCharHashMap.this.select((long key, char value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                LongCharHashMap.access$302(LongCharHashMap.this, retained.keys);
                LongCharHashMap.access$502(LongCharHashMap.this, retained.values);
                LongCharHashMap.this.sentinelValues = retained.sentinelValues;
                LongCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableCharCollection newEmpty() {
            return new CharHashBag();
        }
    }
}

