/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories;

import java.io.Serializable;
import org.eclipse.nebula.widgets.nattable.columnCategories.Node;
import org.eclipse.nebula.widgets.nattable.columnCategories.Tree;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class ColumnCategoriesModel
implements Serializable {
    private static final long serialVersionUID = 4550L;
    private final Tree tree = new Tree();

    public Node addRootCategory(String rootCategoryName) {
        if (ObjectUtils.isNotNull(this.tree.getRootElement())) {
            throw new IllegalStateException("Root has been set already. Clear using (clear()) to reset.");
        }
        Node root = new Node(rootCategoryName, Node.Type.ROOT);
        this.tree.setRootElement(root);
        return root;
    }

    public Node addCategory(Node parentCategory, String newCategoryName) {
        if (this.tree.getRootElement() == null) {
            throw new IllegalStateException("Root node must be set (using addRootNode()) before children can be added");
        }
        Node newNode = new Node(newCategoryName, Node.Type.CATEGORY);
        parentCategory.addChild(newNode);
        return newNode;
    }

    public void addColumnsToCategory(Node parentCategory, int ... columnIndexes) {
        if (parentCategory.getType() != Node.Type.CATEGORY) {
            throw new IllegalStateException("Columns can be added to a category node only.");
        }
        int[] nArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer columnIndex = nArray[n2];
            parentCategory.addChild(new Node(String.valueOf(columnIndex), Node.Type.COLUMN));
            ++n2;
        }
    }

    public void removeColumnIndex(Integer hiddenColumnIndex) {
        this.tree.remove(String.valueOf(hiddenColumnIndex));
    }

    public Node getRootCategory() {
        return this.tree.getRootElement();
    }

    public String toString() {
        return this.tree.toString();
    }

    public void dispose() {
        this.tree.clear();
    }

    public void clear() {
        this.tree.clear();
    }
}

