/**
 * Copyright (c) 2007,2008 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation         - initial API and implementation
 *     Diego Sandin (Motorola) - Adapted code from org.eclipse.pde.ui
 */
package org.eclipse.mtj.internal.ui.editor;

/**
 * @since 0.9.1
 */
public interface IMTJDropParticipant {

    /**
     * @param targetObject The original target object
     * @param sourceObjects The original source objects
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     * @return
     */
    public boolean canDropCopy(Object targetObject, Object[] sourceObjects,
            int targetLocation);

    /**
     * @param targetObject The original target object
     * @param sourceObjects The original source objects
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     * @return
     */
    public boolean canDropLink(Object targetObject, Object[] sourceObjects,
            int targetLocation);

    /**
     * @param targetObject The original target object
     * @param sourceObjects The original source objects
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     * @return
     */
    public boolean canDropMove(Object targetObject, Object[] sourceObjects,
            int targetLocation);

    /**
     * @param targetObject The original target object
     * @param sourceObjects The serialized / deserialized source objects (need
     *            to be reconnected)
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     */
    public void doDropCopy(Object targetObject, Object[] sourceObjects,
            int targetLocation);

    /**
     * @param targetObject The original target object
     * @param sourceObjects The serialized / deserialized source objects (need
     *            to be reconnected)
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     */
    public void doDropLink(Object targetObject, Object[] sourceObjects,
            int targetLocation);

    /**
     * @param targetObject The original target object
     * @param sourceObjects The serialized / deserialized source objects (need
     *            to be reconnected)
     * @param targetLocation ViewerDropAdapter: LOCATION_ON, LOCATION_BEFORE,
     *            LOCATION_AFTER
     */
    public void doDropMove(Object targetObject, Object[] sourceObjects,
            int targetLocation);

}
