/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.util.Vector;

public class StringMatcher {
    protected static final char singleWildCard = '\u0000';
    protected int bound = 0;
    protected boolean hasLeadingStar;
    protected boolean hasTrailingStar;
    protected boolean ignoreCase;
    protected boolean ignoreWildCards;
    protected int length;
    protected String pattern;
    protected String[] segments;

    public StringMatcher(String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.ignoreCase = bl;
        this.ignoreWildCards = bl2;
        this.pattern = string;
        this.length = string.length();
        if (bl2) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n3 = string.length();
        if (n < 0) {
            n = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < 0 || n >= n2) {
            return null;
        }
        if (this.length == 0) {
            return new Position(n, n);
        }
        if (this.ignoreWildCards) {
            int n4 = this.posIn(string, n, n2);
            if (n4 < 0) {
                return null;
            }
            return new Position(n4, n4 + this.length);
        }
        int n5 = this.segments.length;
        if (n5 == 0) {
            return new Position(n, n2);
        }
        int n6 = n;
        int n7 = -1;
        int n8 = 0;
        while (n8 < n5 && n6 < n2) {
            String string2 = this.segments[n8];
            int n9 = this.regExpPosIn(string, n6, n2, string2);
            if (n9 < 0) {
                return null;
            }
            if (n8 == 0) {
                n7 = n9;
            }
            n6 = n9 + string2.length();
            ++n8;
        }
        if (n8 < n5) {
            return null;
        }
        return new Position(n7, n6);
    }

    public boolean match(String string) {
        return this.match(string, 0, string.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String var1_1, int var2_2, int var3_3) {
        if (var1_1 == null) {
            throw new IllegalArgumentException();
        }
        if (var2_2 > var3_3) {
            return false;
        }
        if (this.ignoreWildCards) {
            return var3_3 - var2_2 == this.length && this.pattern.regionMatches(this.ignoreCase, 0, var1_1, var2_2, this.length) != false;
        }
        var4_4 = this.segments.length;
        if (var4_4 == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
            return true;
        }
        if (var2_2 == var3_3) {
            return this.length == 0;
        }
        if (this.length == 0) {
            return var2_2 == var3_3;
        }
        var5_5 = var1_1.length();
        if (var2_2 < 0) {
            var2_2 = 0;
        }
        if (var3_3 > var5_5) {
            var3_3 = var5_5;
        }
        var6_6 = var2_2;
        var7_7 = var3_3 - this.bound;
        if (var7_7 < 0) {
            return false;
        }
        var8_8 = 0;
        var9_9 = this.segments[var8_8];
        var10_10 = var9_9.length();
        if (!this.hasLeadingStar) {
            if (!this.regExpRegionMatches(var1_1, var2_2, var9_9, 0, var10_10)) {
                return false;
            }
            ++var8_8;
            var6_6 += var10_10;
        }
        if (this.segments.length != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl39
        return var6_6 == var3_3;
lbl-1000:
        // 1 sources

        {
            var9_9 = this.segments[var8_8];
            var12_12 = var9_9.indexOf(0);
            if (var12_12 < 0 ? (var11_11 = this.textPosIn(var1_1, var6_6, var3_3, var9_9)) < 0 : (var11_11 = this.regExpPosIn(var1_1, var6_6, var3_3, var9_9)) < 0) {
                return false;
            }
            var6_6 = var11_11 + var9_9.length();
            ++var8_8;
lbl39:
            // 2 sources

            ** while (var8_8 < var4_4)
        }
lbl40:
        // 1 sources

        if (!this.hasTrailingStar && var6_6 != var3_3) {
            var11_11 = var9_9.length();
            return this.regExpRegionMatches(var1_1, var3_3 - var11_11, var9_9, 0, var11_11);
        }
        return var8_8 == var4_4;
    }

    private void parseNoWildCards() {
        this.segments = new String[1];
        this.segments[0] = this.pattern;
        this.bound = this.length;
    }

    private void parseWildCards() {
        if (this.pattern.startsWith("*")) {
            this.hasLeadingStar = true;
        }
        if (this.pattern.endsWith("*") && this.length > 1 && this.pattern.charAt(this.length - 2) != '\\') {
            this.hasTrailingStar = true;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block5: while (n < this.length) {
            char c = this.pattern.charAt(n++);
            switch (c) {
                case '\\': {
                    char c2;
                    if (n >= this.length) {
                        stringBuffer.append(c);
                        break;
                    }
                    if ((c2 = this.pattern.charAt(n++)) == '*' || c2 == '?' || c2 == '\\') {
                        stringBuffer.append(c2);
                        break;
                    }
                    stringBuffer.append(c);
                    stringBuffer.append(c2);
                    break;
                }
                case '*': {
                    if (stringBuffer.length() <= 0) continue block5;
                    vector.addElement(stringBuffer.toString());
                    this.bound += stringBuffer.length();
                    stringBuffer.setLength(0);
                    break;
                }
                case '?': {
                    stringBuffer.append('\u0000');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
            this.bound += stringBuffer.length();
        }
        this.segments = new String[vector.size()];
        vector.copyInto(this.segments);
    }

    protected int posIn(String string, int n, int n2) {
        int n3 = n2 - this.length;
        if (!this.ignoreCase) {
            int n4 = string.indexOf(this.pattern, n);
            if (n4 == -1 || n4 > n3) {
                return -1;
            }
            return n4;
        }
        int n5 = n;
        while (n5 <= n3) {
            if (string.regionMatches(true, n5, this.pattern, 0, this.length)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    protected int regExpPosIn(String string, int n, int n2, String string2) {
        int n3 = string2.length();
        int n4 = n2 - n3;
        int n5 = n;
        while (n5 <= n4) {
            if (this.regExpRegionMatches(string, n5, string2, 0, n3)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String string, int n, String string2, int n2, int n3) {
        while (n3-- > 0) {
            char c = string.charAt(n++);
            char c2 = string2.charAt(n2++);
            if (!this.ignoreWildCards && c2 == '\u0000' || c2 == c || this.ignoreCase && (Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String string, int n, int n2, String string2) {
        int n3 = string2.length();
        int n4 = n2 - n3;
        if (!this.ignoreCase) {
            int n5 = string.indexOf(string2, n);
            if (n5 == -1 || n5 > n4) {
                return -1;
            }
            return n5;
        }
        int n6 = n;
        while (n6 <= n4) {
            if (string.regionMatches(true, n6, string2, 0, n3)) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    public static class Position {
        int end;
        int start;

        public Position(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }
}

