/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.ui.editor.MTJDetails;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class L10nAbstractDetails
extends MTJDetails {
    private static final int NUM_COLUMNS = 3;
    private String fContextID;
    private Section fMainSection;
    private LocalesTreeSection fMasterSection;

    public L10nAbstractDetails(LocalesTreeSection localesTreeSection, String string) {
        this.fMasterSection = localesTreeSection;
        this.fContextID = string;
        this.fMainSection = null;
    }

    public void createContents(Composite composite) {
        this.configureParentLayout(composite);
        this.createDetails(composite);
        this.hookListeners();
    }

    public void createDetails(Composite composite) {
        int n = 256;
        if (this.getDetailsDescription() != null) {
            n |= 0x80;
        }
        this.fMainSection = this.getPage().createUISection(composite, this.getDetailsTitle(), this.getDetailsDescription(), n);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite composite2 = this.getPage().createUISectionContainer((Composite)this.fMainSection, 3);
        GridData gridData = new GridData(1808);
        this.fMainSection.setLayoutData((Object)gridData);
        this.createFields(composite2);
        this.getManagedForm().getToolkit().paintBordersFor(composite2);
        this.fMainSection.setClient((Control)composite2);
        this.markDetailsPart((Control)this.fMainSection);
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getMTJEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return this.fContextID;
    }

    public LocalesTreeSection getMasterSection() {
        return this.fMasterSection;
    }

    public MTJFormPage getPage() {
        return (MTJFormPage)((Object)this.getManagedForm().getContainer());
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public abstract void hookListeners();

    public boolean isEditable() {
        return this.fMasterSection.isEditable();
    }

    public boolean isEditableElement() {
        return this.fMasterSection.isEditable();
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
    }

    public abstract void updateFields();

    private void configureParentLayout(Composite composite) {
        composite.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
    }

    protected abstract void createFields(Composite var1);

    protected void createLabel(Composite composite, FormToolkit formToolkit, String string) {
        Label label = formToolkit.createLabel(composite, string, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    protected void createSpace(Composite composite) {
        this.createLabel(composite, this.getManagedForm().getToolkit(), "");
    }

    protected abstract String getDetailsDescription();

    protected abstract String getDetailsTitle();

    protected Object getFirstSelectedObject(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection == null) {
            return null;
        }
        return iStructuredSelection.getFirstElement();
    }
}

