/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.sdkprovidertestclamp2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp2.Plugin;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp2.Sdk;
import org.osgi.framework.Version;

public class Device
extends AbstractMIDPDevice
implements IManagedDevice,
Cloneable {
    private String identifier;
    private boolean isDuplicate;

    public Device() {
    }

    public Device(Sdk sdk, String string) {
        Properties properties = Plugin.getDefault().getProperties();
        this.identifier = properties.getProperty(String.valueOf(string) + ".id");
        this.setName(properties.getProperty(String.valueOf(string) + ".name"));
        this.setDescription(properties.getProperty(String.valueOf(string) + ".description"));
        this.setGroupName(sdk.getName());
        this.setClasspath(this.buildClasspath());
        this.setExecutable(new File("c:\\windows\\notepad.exe"));
        this.setBundle(Plugin.getDefault().getBundle().getSymbolicName());
        this.setPreverifier(null);
        this.setDeviceProperties(this.buildDeviceSymbols());
        this.setProtectionDomains(new String[0]);
        this.setDebugServer(false);
        ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)this);
        ISymbolSet iSymbolSet2 = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.buildDeviceSymbols());
        iSymbolSet.add(iSymbolSet2.getSymbols());
        iSymbolSet.setName(this.getName());
        this.setSymbolSet(iSymbolSet);
        this.setSDK((ISDK)sdk);
        this.setLaunchCommandTemplate("Fake launch command template");
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getWorkingDirectory() {
        return null;
    }

    private IDeviceClasspath buildClasspath() {
        ArrayList<MIDPLibrary> arrayList = new ArrayList<MIDPLibrary>();
        arrayList.add(this.buildLibrary1());
        arrayList.add(this.buildLibrary2());
        DeviceClasspath deviceClasspath = new DeviceClasspath();
        for (IMIDPLibrary iMIDPLibrary : arrayList) {
            deviceClasspath.addEntry((ILibrary)iMIDPLibrary);
        }
        return deviceClasspath;
    }

    private MIDPLibrary buildLibrary1() {
        Properties properties = Plugin.getDefault().getProperties();
        String string = properties.getProperty("library.cldc11");
        File file = new File("c:\\");
        File file2 = new File(string);
        ArrayList<MIDPAPI> arrayList = new ArrayList<MIDPAPI>();
        MIDPAPI mIDPAPI = new MIDPAPI();
        mIDPAPI.setIdentifier("CLDC");
        mIDPAPI.setName("Connected Limited Device Configuration");
        mIDPAPI.setType(MIDPAPIType.CONFIGURATION);
        mIDPAPI.setVersion(new Version("1.1"));
        arrayList.add(mIDPAPI);
        URL uRL = null;
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        return new MIDPLibrary(arrayList, uRL, file2, null, null, new ArrayList(0));
    }

    private MIDPLibrary buildLibrary2() {
        Properties properties = Plugin.getDefault().getProperties();
        String string = properties.getProperty("library.midp21");
        File file = new File("c:\\");
        File file2 = new File(string);
        ArrayList<MIDPAPI> arrayList = new ArrayList<MIDPAPI>();
        MIDPAPI mIDPAPI = new MIDPAPI();
        mIDPAPI.setIdentifier("MIDP");
        mIDPAPI.setName("Mobile Information Device Profile");
        mIDPAPI.setType(MIDPAPIType.PROFILE);
        mIDPAPI.setVersion(new Version("2.1"));
        arrayList.add(mIDPAPI);
        URL uRL = null;
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        return new MIDPLibrary(arrayList, uRL, file2, null, null, new ArrayList(0));
    }

    private Properties buildDeviceSymbols() {
        Properties properties = new Properties();
        properties.put("aFakeSymbolSet", "true");
        properties.put("aFakeVendor", "MTJ Corporation");
        properties.put("screen.isColor", "true");
        properties.put("hasTouchScreen", "false");
        return properties;
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        return "";
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setAsDuplicate() {
        this.isDuplicate = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        Device device = (Device)super.clone();
        device.identifier = this.identifier;
        device.isDuplicate = true;
        return device;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        this.identifier = iPersistenceProvider.loadString("identifier");
        this.isDuplicate = iPersistenceProvider.loadBoolean("isDuplicate");
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString("identifier", this.identifier);
        iPersistenceProvider.storeBoolean("isDuplicate", this.isDuplicate);
    }
}

