/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJBuildPropertiesResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        Object object;
        Object object2;
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        try {
            IProject iProject;
            object2 = new MTJBuildPropertiesVisitor();
            iResourceDelta.accept((IResourceDeltaVisitor)object2);
            object = ((MTJBuildPropertiesVisitor)object2).getBuildProperties();
            if (object != null && (iProject = object.getProject()) != null) {
                IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
                MTJBuildProperties.getBuildProperties(iMTJProject).load();
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        try {
            object2 = new AddsAndRemovesCollector();
            iResourceDelta.accept((IResourceDeltaVisitor)object2);
            object = this.filterResourceDeltas(((AddsAndRemovesCollector)object2).getResourceDeltas());
            this.updateBuildProperties((List<IResourceDelta>)object);
        }
        catch (Exception exception) {
            MTJLogger.log(4, exception);
        }
    }

    private void updateBuildProperties(List<IResourceDelta> list) throws IOException {
        for (IResourceDelta iResourceDelta : list) {
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = iResource.getProject();
            if (iProject == null) {
                return;
            }
            if (!MidletSuiteFactory.isMidletSuiteProject(iProject)) continue;
            IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
            MTJBuildProperties mTJBuildProperties = MTJBuildProperties.getBuildProperties(iMTJProject);
            MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
            boolean bl = false;
            for (MTJRuntime mTJRuntime : mTJRuntimeList) {
                boolean bl2;
                if (iResourceDelta.getKind() == 2) {
                    boolean bl3 = bl2 = (iResourceDelta.getFlags() & 0x2000) != 0;
                    if (bl2) continue;
                    mTJBuildProperties.deleteResource(iResource);
                    bl = true;
                    continue;
                }
                if (iResourceDelta.getKind() != 1) continue;
                boolean bl4 = bl2 = (iResourceDelta.getFlags() & 0x1000) != 0;
                if (bl2) continue;
                mTJBuildProperties.includeResource(iResource, mTJRuntime);
                bl = true;
            }
            if (!bl) continue;
            mTJBuildProperties.store();
        }
    }

    private List<IResourceDelta> filterResourceDeltas(List<IResourceDelta> list) throws CoreException {
        ArrayList<IResourceDelta> arrayList = new ArrayList<IResourceDelta>();
        for (IResourceDelta iResourceDelta : list) {
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = iResource.getProject();
            if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.jdt.core.javanature")) continue;
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IResource[] iResourceArray = Utils.getSourceFolders(iJavaProject);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource2 = iResourceArray[n2];
                if (iResource2.getProjectRelativePath().isPrefixOf(iResource.getProjectRelativePath())) {
                    arrayList.add(iResourceDelta);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddsAndRemovesCollector
    implements IResourceDeltaVisitor {
        private List<IResourceDelta> deltas = new ArrayList<IResourceDelta>();

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            int n = iResourceDelta.getKind();
            if ((n == 1 || n == 2) && iResource.getProject() != null && iResource.getType() == 1) {
                this.deltas.add(iResourceDelta);
            }
            return true;
        }

        public List<IResourceDelta> getResourceDeltas() {
            return this.deltas;
        }
    }

    class MTJBuildPropertiesVisitor
    implements IResourceDeltaVisitor {
        private IResource properties;

        MTJBuildPropertiesVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource;
            IResource iResource2;
            IProject iProject;
            boolean bl;
            boolean bl2 = bl = (iResourceDelta.getFlags() & 0x100) != 0;
            if (iResourceDelta.getKind() == 4 && bl && (iProject = (iResource2 = iResourceDelta.getResource()).getProject()) != null && iProject.hasNature("org.eclipse.mtj.core.nature") && (iResource = iProject.findMember("build.properties")) != null && iResource.equals((Object)iResource2)) {
                this.properties = iResource2;
            }
            return this.properties == null;
        }

        public IResource getBuildProperties() {
            return this.properties;
        }
    }
}

