/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class EntryTrackingJarOutputStream
extends JarOutputStream {
    private Set<String> addedEntryNames = new HashSet<String>();

    public EntryTrackingJarOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public EntryTrackingJarOutputStream(OutputStream outputStream, Manifest manifest) throws IOException {
        super(outputStream);
        this.addManifest(manifest);
    }

    public boolean alreadyAdded(ZipEntry zipEntry) {
        return this.addedEntryNames.contains(zipEntry.getName());
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        super.putNextEntry(zipEntry);
        this.addedEntryNames.add(zipEntry.getName());
    }

    private void addManifest(Manifest manifest) throws IOException {
        if (manifest == null) {
            throw new NullPointerException("man");
        }
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(zipEntry);
        manifest.write(new BufferedOutputStream(this));
        this.closeEntry();
    }
}

