/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import org.eclipse.mtj.internal.core.text.DocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;

public class L10nDocumentFactory
extends DocumentNodeFactory
implements IDocumentNodeFactory {
    private L10nModel fModel;

    public L10nDocumentFactory(L10nModel l10nModel) {
        this.fModel = l10nModel;
    }

    public IDocumentElementNode createDocumentNode(String string, IDocumentElementNode iDocumentElementNode) {
        if (this.isLocales(string)) {
            return this.createL10nLocales();
        }
        if (this.isEntry(string)) {
            return this.createL10nEntry(iDocumentElementNode);
        }
        if (this.isLocale(string)) {
            return this.createL10nLocale(iDocumentElementNode);
        }
        return super.createDocumentNode(string, iDocumentElementNode);
    }

    public L10nEntry createL10nEntry(IDocumentElementNode iDocumentElementNode) {
        L10nEntry l10nEntry = null;
        try {
            l10nEntry = this.fModel.getLocales().getLocale(iDocumentElementNode).createEntry();
        }
        catch (Exception exception) {}
        return l10nEntry;
    }

    public L10nLocale createL10nLocale(IDocumentElementNode iDocumentElementNode) {
        return this.fModel.getLocales().createlLocale();
    }

    public L10nLocales createL10nLocales() {
        return new L10nLocales(this.fModel);
    }

    private boolean isEntry(String string) {
        return this.isL10nElement(string, "entry");
    }

    private boolean isL10nElement(String string, String string2) {
        return string.equals(string2);
    }

    private boolean isLocale(String string) {
        return this.isL10nElement(string, "locale");
    }

    private boolean isLocales(String string) {
        return this.isL10nElement(string, "locales");
    }
}

