/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.SDKProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedDeviceRegistry {
    ManagedDeviceRegistry() {
    }

    List<IDevice> getAllDevices() throws PersistenceException {
        return this.getAllDevicesInternal(false, null);
    }

    IDevice getDevice(String string, String string2) throws PersistenceException {
        IDevice iDevice = null;
        List<ISDKProvider> list = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider iSDKProvider : list) {
            List<ISDK> list2 = iSDKProvider.getSDKs();
            for (ISDK iSDK : list2) {
                List<IDevice> list3;
                if (iSDK == null || !iSDK.getName().equals(string)) continue;
                try {
                    list3 = iSDK.getDeviceList();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    continue;
                }
                for (IDevice iDevice2 : list3) {
                    String string3;
                    if (iDevice2 == null || !(string3 = iDevice2.getName()).equals(string2)) continue;
                    return iDevice2;
                }
            }
        }
        return iDevice;
    }

    int getDeviceCount() throws PersistenceException {
        int n = 0;
        List<ISDKProvider> list = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider iSDKProvider : list) {
            List<ISDK> list2 = iSDKProvider.getSDKs();
            for (ISDK iSDK : list2) {
                List<IDevice> list3;
                if (iSDK == null) continue;
                try {
                    list3 = iSDK.getDeviceList();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    continue;
                }
                for (IDevice iDevice : list3) {
                    if (iDevice == null) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    List<IDevice> getDevices(String string) throws PersistenceException {
        List<IDevice> list = this.getAllDevicesInternal(true, string);
        return list.isEmpty() ? null : list;
    }

    List<String> getSDKNames() throws PersistenceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ISDKProvider> list = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider iSDKProvider : list) {
            List<ISDK> list2 = iSDKProvider.getSDKs();
            for (ISDK iSDK : list2) {
                if (iSDK == null) continue;
                arrayList.add(iSDK.getName());
            }
        }
        return arrayList;
    }

    private List<IDevice> getAllDevicesInternal(boolean bl, String string) throws PersistenceException {
        if (!bl && string != null) {
            throw new IllegalArgumentException("If filterByGroupName is false, groupName should be null");
        }
        if (bl && string == null) {
            throw new IllegalArgumentException("If filterByGroupName is true, groupName cannot be null");
        }
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        List<ISDKProvider> list = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider iSDKProvider : list) {
            List<ISDK> list2 = iSDKProvider.getSDKs();
            for (ISDK iSDK : list2) {
                List<IDevice> list3;
                if (iSDK == null || bl && !iSDK.getName().equals(string)) continue;
                try {
                    list3 = iSDK.getDeviceList();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    continue;
                }
                for (IDevice iDevice : list3) {
                    if (iDevice == null) continue;
                    arrayList.add(iDevice);
                }
            }
        }
        return arrayList;
    }
}

