/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceClasspath
implements IDeviceClasspath {
    private ArrayList<ILibrary> entries = new ArrayList();

    @Override
    public void addEntry(ILibrary iLibrary) {
        this.entries.add(iLibrary);
    }

    @Override
    public List<IClasspathEntry> asClasspathEntries() {
        List<ILibrary> list = this.getEntries();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(list.size());
        int n = 0;
        while (n < list.size()) {
            arrayList.add(list.get(n).toClasspathEntry());
            ++n;
        }
        return arrayList;
    }

    @Override
    public boolean equals(IDeviceClasspath iDeviceClasspath) {
        List<ILibrary> list = this.getEntries();
        List<ILibrary> list2 = iDeviceClasspath.getEntries();
        boolean bl = list.size() == list2.size();
        int n = 0;
        while (bl && n < list.size()) {
            bl = list.get(n).equals(list2.get(n));
            ++n;
        }
        return bl;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DeviceClasspath) {
            bl = this.equals((IDeviceClasspath)object);
        }
        return bl;
    }

    @Override
    public List<ILibrary> getEntries() {
        return this.entries;
    }

    @Override
    public int hashCode() {
        List<ILibrary> list = this.getEntries();
        int n = list.size() << 24;
        for (ILibrary iLibrary : list) {
            n ^= iLibrary.hashCode();
        }
        return n;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.entries.clear();
        int n = iPersistenceProvider.loadInteger("entryCount");
        int n2 = 0;
        while (n2 < n) {
            this.entries.add((ILibrary)iPersistenceProvider.loadPersistable("entry" + n2));
            ++n2;
        }
    }

    @Override
    public void removeEntry(ILibrary iLibrary) {
        this.entries.remove(iLibrary);
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeInteger("entryCount", this.entries.size());
        int n = 0;
        for (ILibrary iLibrary : this.entries) {
            iPersistenceProvider.storePersistable("entry" + n++, iLibrary);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<ILibrary> list = this.getEntries();
        int n = 0;
        while (n < list.size()) {
            if (n != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(list.get(n).toFile());
            ++n;
        }
        return stringBuffer.toString();
    }
}

