/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJBuildProperties
extends Properties {
    public static final String FILE_NAME = "build.properties";
    private static final long serialVersionUID = -3576616481147533654L;
    private static Map<IMTJProject, MTJBuildProperties> map;
    private Map<MTJRuntime, RuntimeBuildProperties> runtimeProperties;
    private List<MTJBuildPropertiesChangeListener> listeners;
    private IMTJProject mtjProject;
    private Object mutex;

    public static synchronized MTJBuildProperties getBuildProperties(IMTJProject iMTJProject) {
        MTJBuildProperties mTJBuildProperties;
        if (map == null) {
            map = new HashMap<IMTJProject, MTJBuildProperties>();
        }
        if ((mTJBuildProperties = map.get(iMTJProject)) == null) {
            mTJBuildProperties = new MTJBuildProperties(iMTJProject);
            map.put(iMTJProject, mTJBuildProperties);
        }
        return mTJBuildProperties;
    }

    private MTJBuildProperties(IMTJProject iMTJProject) {
        if (iMTJProject == null) {
            throw new IllegalArgumentException(Messages.MTJBuildProperties_invalidMTJProject);
        }
        this.listeners = new ArrayList<MTJBuildPropertiesChangeListener>();
        this.mtjProject = iMTJProject;
        this.mutex = new Object();
        this.runtimeProperties = new HashMap<MTJRuntime, RuntimeBuildProperties>();
        for (MTJRuntime mTJRuntime : this.mtjProject.getRuntimeList()) {
            RuntimeBuildProperties runtimeBuildProperties = new RuntimeBuildProperties();
            this.runtimeProperties.put(mTJRuntime, runtimeBuildProperties);
        }
        this.loadFromFile();
    }

    public void load() {
        this.loadFromFile();
        this.notifyListeners();
    }

    private synchronized void loadFromFile() {
        IFile iFile = this.getBuildPropertyFile();
        if (iFile.exists()) {
            try {
                this.doLoad(new FileInputStream(iFile.getLocation().toOSString()));
            }
            catch (IOException iOException) {
                MTJLogger.log(4, iOException);
            }
        }
    }

    private void doLoad(InputStream inputStream) throws IOException {
        super.load(inputStream);
        MTJRuntimeList mTJRuntimeList = this.mtjProject.getRuntimeList();
        for (MTJRuntime mTJRuntime : mTJRuntimeList) {
            String string = this.getProperty(NLS.bind((String)"{0}.includes", (Object)mTJRuntime.getName()));
            String string2 = this.getProperty(NLS.bind((String)"{0}.excludes", (Object)mTJRuntime.getName()));
            RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
            if (runtimeBuildProperties == null) continue;
            runtimeBuildProperties.clear();
            if (string == null && string2 == null) {
                this.includeDefaultResources(runtimeBuildProperties.includes);
                continue;
            }
            this.parseResourcesList(runtimeBuildProperties.includes, string);
            this.parseResourcesList(runtimeBuildProperties.excludes, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertiesChangeListener(MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(mTJBuildPropertiesChangeListener)) {
                this.listeners.add(mTJBuildPropertiesChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertiesChangeListener(MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(mTJBuildPropertiesChangeListener)) {
                this.listeners.remove(mTJBuildPropertiesChangeListener);
            }
        }
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    @Override
    public synchronized void loadFromXML(InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeDefaultResources(List<IResource> list) {
        Object object = this.mutex;
        synchronized (object) {
            list.clear();
            IResource[] iResourceArray = Utils.getSourceFolders(this.mtjProject.getJavaProject());
            try {
                list.addAll(Arrays.asList(iResourceArray));
            }
            catch (Exception exception) {
                MTJLogger.log(4, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResourcesList(List<IResource> list, String string) {
        if (string != null) {
            String string2 = System.getProperty("line.separator");
            string = string.replaceAll(string2, "");
            Object object = this.mutex;
            synchronized (object) {
                String[] stringArray;
                IProject iProject = this.mtjProject.getProject();
                String[] stringArray2 = stringArray = string.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = stringArray2[n2];
                    IResource iResource = iProject.findMember(string3);
                    if (iResource != null) {
                        list.add(iResource);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void store(Writer writer, String string) throws IOException {
        PrintWriter printWriter = null;
        printWriter = !(writer instanceof PrintWriter) ? new PrintWriter(writer) : (PrintWriter)writer;
        try {
            this.writeProperties(printWriter, string);
            printWriter.flush();
            printWriter.close();
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.store(printWriter, string);
    }

    public void store() throws IOException {
        IFile iFile = this.getBuildPropertyFile();
        PrintWriter printWriter = new PrintWriter(new FileWriter(iFile.getLocation().toFile()));
        this.store(printWriter, Messages.MTJBuildProperties_mtjBuildPropertiesComment);
        try {
            if (!MTJCore.getWorkspace().isTreeLocked()) {
                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
    }

    public IFile getBuildPropertyFile() {
        return this.mtjProject.getProject().getFile(FILE_NAME);
    }

    public IMTJProject getMTJProject() {
        return this.mtjProject;
    }

    public void setContent(InputStream inputStream) throws IOException {
        this.doLoad(inputStream);
    }

    public StringBuffer getContent() {
        StringWriter stringWriter = new StringWriter();
        this.writeProperties(new PrintWriter(stringWriter), null);
        return stringWriter.getBuffer();
    }

    public void deleteResource(IResource iResource) {
        for (MTJRuntime mTJRuntime : this.mtjProject.getRuntimeList()) {
            RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
            if (runtimeBuildProperties == null) continue;
            this.removeResourceAndChildren(runtimeBuildProperties.includes, iResource);
            this.removeResourceAndChildren(runtimeBuildProperties.excludes, iResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResourceAndChildren(List<IResource> list, IResource iResource) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        for (IResource object2 : list) {
            IPath iPath = object2.getProjectRelativePath();
            IPath iPath2 = iResource.getProjectRelativePath();
            if (!iPath2.isPrefixOf(iPath) && !iPath2.equals((Object)iPath)) continue;
            arrayList.add(object2);
        }
        Object object = this.mutex;
        synchronized (object) {
            list.removeAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void includeResource(IResource iResource, MTJRuntime mTJRuntime) {
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.removeResourceAndChildren(runtimeBuildProperties.excludes, iResource);
                this.removeResourceAndChildren(runtimeBuildProperties.includes, iResource);
                if (!this.isResourceIncludedByParent(iResource, mTJRuntime)) {
                    runtimeBuildProperties.includes.add(iResource);
                }
            }
        }
    }

    private boolean isResourceIncludedByParent(IResource iResource, MTJRuntime mTJRuntime) {
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties == null) {
            return false;
        }
        boolean bl = false;
        IPath iPath = iResource.getFullPath();
        List<IResource> list = runtimeBuildProperties.includes;
        for (IResource iResource2 : list) {
            IPath iPath2 = iResource2.getFullPath();
            if (!iPath2.isPrefixOf(iPath)) continue;
            bl = true;
            List<IResource> list2 = runtimeBuildProperties.excludes;
            for (IResource iResource3 : list2) {
                IPath iPath3 = iResource3.getFullPath();
                if (!iPath2.isPrefixOf(iPath3) || !iPath3.isPrefixOf(iPath)) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void excludeResource(IResource iResource, MTJRuntime mTJRuntime) {
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.removeResourceAndChildren(runtimeBuildProperties.includes, iResource);
                this.removeResourceAndChildren(runtimeBuildProperties.excludes, iResource);
                if (!this.isResourceExcludedByParent(iResource, mTJRuntime)) {
                    runtimeBuildProperties.excludes.add(iResource);
                }
            }
        }
    }

    private boolean isResourceExcludedByParent(IResource iResource, MTJRuntime mTJRuntime) {
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties == null) {
            return false;
        }
        boolean bl = false;
        IPath iPath = iResource.getFullPath();
        List<IResource> list = runtimeBuildProperties.excludes;
        for (IResource iResource2 : list) {
            IPath iPath2 = iResource2.getFullPath();
            if (!iPath2.isPrefixOf(iPath)) continue;
            bl = true;
            List<IResource> list2 = runtimeBuildProperties.includes;
            for (IResource iResource3 : list2) {
                IPath iPath3 = iResource3.getFullPath();
                if (!iPath2.isPrefixOf(iPath3) || !iPath3.isPrefixOf(iPath)) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getIncludes(MTJRuntime mTJRuntime) {
        IResource[] iResourceArray = new IResource[]{};
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties == null) {
            this.addRuntime(mTJRuntime);
            runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        }
        Object object = this.mutex;
        synchronized (object) {
            iResourceArray = runtimeBuildProperties.includes.toArray(new IResource[0]);
        }
        return iResourceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getExcludes(MTJRuntime mTJRuntime) {
        IResource[] iResourceArray = new IResource[]{};
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties == null) {
            this.addRuntime(mTJRuntime);
            runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        }
        Object object = this.mutex;
        synchronized (object) {
            iResourceArray = runtimeBuildProperties.excludes.toArray(new IResource[0]);
        }
        return iResourceArray;
    }

    private void addRuntime(MTJRuntime mTJRuntime) {
        RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
        if (runtimeBuildProperties == null) {
            runtimeBuildProperties = new RuntimeBuildProperties();
            this.includeDefaultResources(runtimeBuildProperties.includes);
            this.runtimeProperties.put(mTJRuntime, runtimeBuildProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(PrintWriter printWriter, String string) {
        printWriter.println(string == null ? Messages.MTJBuildProperties_mtjBuildPropertiesComment : string);
        Object object = this.mutex;
        synchronized (object) {
            for (MTJRuntime mTJRuntime : this.mtjProject.getRuntimeList()) {
                RuntimeBuildProperties runtimeBuildProperties = this.runtimeProperties.get(mTJRuntime);
                if (runtimeBuildProperties == null) continue;
                String string2 = null;
                String string3 = null;
                string2 = NLS.bind((String)"{0}.includes", (Object)mTJRuntime.getName());
                string3 = this.format(this.getResourcesString(runtimeBuildProperties.includes));
                printWriter.println(NLS.bind((String)"{0}={1}", (Object[])new String[]{string2, string3}));
                string2 = NLS.bind((String)"{0}.excludes", (Object)mTJRuntime.getName());
                string3 = this.format(this.getResourcesString(runtimeBuildProperties.excludes));
                printWriter.println(NLS.bind((String)"{0}={1}", (Object[])new String[]{string2, string3}));
            }
        }
    }

    private String format(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(NLS.bind((String)"{0}\\{1}", (Object[])new String[]{string3, string2}));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private String getResourcesString(List<IResource> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (IResource iResource : list) {
            String string = iResource.getProjectRelativePath().toString();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void notifyListeners() {
        for (MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener : this.listeners) {
            mTJBuildPropertiesChangeListener.propertiesChanged(this);
        }
    }

    private class RuntimeBuildProperties {
        List<IResource> includes = new ArrayList<IResource>();
        List<IResource> excludes = new ArrayList<IResource>();

        public void clear() {
            this.includes.clear();
            this.excludes.clear();
        }
    }
}

