/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;

public class BuildConsoleProxy
implements IBuildConsoleProxy {
    private static final BuildConsoleProxy instance = new BuildConsoleProxy();
    private static NullOutputStream nullStream = new NullOutputStream();
    private IBuildConsoleProxy proxy;
    private PrintWriter traceWriter;

    public static synchronized BuildConsoleProxy getInstance() {
        return instance;
    }

    private BuildConsoleProxy() {
    }

    public void addConsoleStreamListener(IBuildConsoleProxy.Stream stream, IStreamMonitor iStreamMonitor) {
        final PrintWriter printWriter = this.getConsoleWriter(stream);
        iStreamMonitor.addListener(new IStreamListener(){

            public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                printWriter.print(string);
                printWriter.flush();
            }
        });
        printWriter.print(iStreamMonitor.getContents());
        printWriter.flush();
    }

    public PrintWriter getConsoleWriter(IBuildConsoleProxy.Stream stream) {
        return this.proxy == null ? new PrintWriter(nullStream) : this.proxy.getConsoleWriter(stream);
    }

    public void setProxy(IBuildConsoleProxy iBuildConsoleProxy) {
        this.proxy = iBuildConsoleProxy;
        this.traceWriter = null;
    }

    public void trace(String string) {
        if (this.traceWriter == null) {
            this.traceWriter = this.getConsoleWriter(IBuildConsoleProxy.Stream.TRACE);
        }
        this.traceWriter.print(string);
        this.traceWriter.flush();
    }

    public void traceln(String string) {
        this.trace(String.valueOf(string) + "\n");
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }
}

