/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceAccessor {
    public static final PreferenceAccessor instance = new PreferenceAccessor();
    public static final String MULTI_VALUE_SEPARATOR = "|";
    private IEclipsePreferences defaultPreferences = new DefaultScope().getNode("org.eclipse.mtj.core");
    private IEclipsePreferences instancePreferences = new InstanceScope().getNode("org.eclipse.mtj.core");

    private PreferenceAccessor() {
    }

    public String getDefaultProguardOptions() {
        return this.defaultPreferences.get("proguard_options", "");
    }

    public boolean getAutoversionPackage(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "pkg_autoversion");
        return iEclipsePreferences.getBoolean("pkg_autoversion", false);
    }

    public String[] getExcludedManifestProperties(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "pkg_excluded_props");
        String string = iEclipsePreferences.get("pkg_excluded_props", "MIDlet-Jar-URL|MIDlet-Jar-Size");
        return this.parseMultiValuedPreferenceValue(string);
    }

    public String getPreprecessorDebuglevel(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "preprocess_use_project", "preprocess_debuglevel");
        String string = iEclipsePreferences.get("preprocess_debuglevel", "debug");
        return string;
    }

    public Version getPreverificationConfigurationVersion(IProject iProject) throws CoreException {
        Version version = null;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "preverify_config_location");
        String string = iEclipsePreferences.get("preverify_config_location", "platform");
        if ("jad".equals(string)) {
            IApplicationDescriptor iApplicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
            version = iApplicationDescriptor.getConfigurationSpecificationVersion();
        } else if ("platform".equals(string)) {
            IMIDPAPI iMIDPAPI;
            version = new Version("1.0");
            IMIDPDevice iMIDPDevice = (IMIDPDevice)iMidletSuiteProject.getRuntimeList().getActiveMTJRuntime().getDevice();
            if (iMIDPDevice != null && (iMIDPAPI = iMIDPDevice.getCLDCAPI()) != null) {
                version = iMIDPAPI.getVersion();
            }
        } else {
            String[] stringArray;
            String string2 = iEclipsePreferences.get("preverify_config_value", "");
            if (string2.startsWith("CLDC") && (stringArray = string2.split("-")).length == 2) {
                string2 = stringArray[1];
            }
            version = new Version(string2);
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    public String[] getProguardKeepExpressions(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_keep");
        String string = iEclipsePreferences.get("proguard_keep", "public class * extends javax.microedition.midlet.MIDlet");
        return this.parseMultiValuedPreferenceValue(string);
    }

    public String getSpecifiedProguardOptions(IProject iProject) {
        String string = null;
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_options");
        string = iEclipsePreferences.get("proguard_options", "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
        if (iEclipsePreferences.getBoolean("obfuscate_use_project", false)) {
            String[] stringArray;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray2 = stringArray = string.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (Pattern.matches("@.+", string2)) {
                    String string3 = string2.substring(1);
                    string2 = NLS.bind((String)"@{0}", (Object)iProject.getLocation().append(string3).toOSString());
                }
                stringBuffer.append(" ").append(string2);
                ++n2;
            }
            string = stringBuffer.toString().trim();
        }
        return string;
    }

    public boolean isUseSpecifiedProguardOptions(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "obfuscate_use_project", "proguard_use_specified");
        return iEclipsePreferences.getBoolean("proguard_use_specified", false);
    }

    public String getPreverifierType(IProject iProject) {
        IEclipsePreferences iEclipsePreferences = this.getProjectPreferences(iProject, "pkg_use_project", "preverify_type");
        return iEclipsePreferences.get("preverify_type", "preverify_emulator");
    }

    private IEclipsePreferences getProjectPreferences(IProject iProject, String string, String string2) {
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
        boolean bl = iEclipsePreferences.getBoolean(string, false);
        IEclipsePreferences iEclipsePreferences2 = iEclipsePreferences = bl ? iEclipsePreferences : this.instancePreferences;
        if (iEclipsePreferences.get(string2, null) == null) {
            iEclipsePreferences = this.defaultPreferences;
        }
        return iEclipsePreferences;
    }

    private String[] parseMultiValuedPreferenceValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, MULTI_VALUE_SEPARATOR);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public String getString(String string) {
        String string2 = this.instancePreferences.get(string, null);
        return string2 != null ? string2 : this.defaultPreferences.get(string, "");
    }

    public boolean getBoolean(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getBoolean(string, false);
        }
        return this.defaultPreferences.getBoolean(string, false);
    }

    public int getInt(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getInt(string, 0);
        }
        return this.defaultPreferences.getInt(string, 0);
    }

    private boolean containsKey(IEclipsePreferences iEclipsePreferences, String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        try {
            stringArray = iEclipsePreferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

