/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolUtils {
    public static final String PROP_UEI_VERSION = "uei.version";
    public static final String PROP_UEI_ARGUMENTS = "uei.arguments";
    public static final String PROP_DEVICE_LIST = "device.list";
    public static final String PROP_SECURITY_DOMAINS = "security.domains";
    public static final String PROP_BOOTCLASSPATH = "bootclasspath";
    public static final String PROP_APIS = "apis";
    public static final String PROP_DESCRIPTION = "description";
    private static List<String> excludedProperties = new ArrayList<String>();
    private static final String J2MEPOLISH_CAPABILITY_SEPARATOR = ",";

    static {
        excludedProperties.add(PROP_UEI_VERSION);
        excludedProperties.add(PROP_UEI_ARGUMENTS);
        excludedProperties.add(PROP_DEVICE_LIST);
        excludedProperties.add(PROP_SECURITY_DOMAINS);
        excludedProperties.add(PROP_BOOTCLASSPATH);
        excludedProperties.add(PROP_APIS);
        excludedProperties.add(PROP_DESCRIPTION);
    }

    public static String getSafeSymbolValue(String string) {
        if (string == null || string.trim().length() == 0) {
            string = Boolean.TRUE.toString();
        }
        if (!string.startsWith("\"") && !string.startsWith("'")) {
            string = "'" + string + "'";
        }
        return string;
    }

    public static ISymbolSet createSymbolSet(IDevice iDevice) {
        ISymbolSet iSymbolSet = SymbolSetFactory.getInstance().createSymbolSet("Default");
        SymbolUtils.addLibrarySymbols(iSymbolSet, iDevice);
        return iSymbolSet;
    }

    public static ISymbolSet createSymbolSet(Properties properties) {
        ISymbolSet iSymbolSet = SymbolSetFactory.getInstance().createSymbolSet("Properties");
        SymbolUtils.populateSymbolSetFromProperties(iSymbolSet, properties);
        return iSymbolSet;
    }

    public static String replaceFirstNonLetterChar(String string) {
        string = string.replaceFirst("^[^a-zA-Z].+", "a_" + string);
        return string;
    }

    public static List<ISymbolSet> importFromJ2MEPolishFormat(IProgressMonitor iProgressMonitor, InputStream inputStream, InputStream inputStream2) throws PersistenceException, ParserConfigurationException, SAXException, IOException {
        Vector<ISymbolSet> vector = new Vector<ISymbolSet>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Document document2 = documentBuilder.parse(inputStream2);
        HashMap<String, Element> hashMap = SymbolUtils.prepareGroups(document2);
        NodeList nodeList = document.getElementsByTagName("device");
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Importing...", nodeList.getLength());
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Object object2;
            Object object3;
            Element element;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            Element element2 = (Element)nodeList.item(n);
            String string = ((Element)element2.getElementsByTagName("identifier").item(0)).getTextContent();
            Element element3 = (Element)element2.getElementsByTagName("features").item(0);
            if (element3 != null) {
                String string2 = element3.getTextContent();
                hashMap2.put("features", string2);
            }
            if ((element = (Element)element2.getElementsByTagName("groups").item(0)) != null) {
                object3 = new StringTokenizer(element.getTextContent(), J2MEPOLISH_CAPABILITY_SEPARATOR);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken().trim();
                    HashMap<String, String> hashMap3 = SymbolUtils.getGroupCapabilities(hashMap, (String)object2);
                    SymbolUtils.copyCapabilities(hashMap2, hashMap3);
                }
                hashMap2.put("groups", element.getTextContent().toLowerCase());
            }
            object3 = element2.getElementsByTagName("capability");
            int n2 = 0;
            while (n2 < object3.getLength()) {
                object = (Element)object3.item(n2);
                SymbolUtils.copyCapability(hashMap2, object.getAttribute("name"), object.getAttribute("value"));
                ++n2;
            }
            hashMap2.put(string, "true");
            object2 = new StringTokenizer(string, J2MEPOLISH_CAPABILITY_SEPARATOR);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
                object = ((String)object).replace('/', '_');
                object = ((String)object).replace('(', '_');
                object = ((String)object).replace(')', '_');
                ISymbolSet iSymbolSet = SymbolUtils.createSymbolDefinitionSet((String)object, hashMap2);
                vector.add(iSymbolSet);
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            ++n;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
        return vector;
    }

    private static void addLibrarySymbols(ISymbolSet iSymbolSet, IDevice iDevice) {
        if (iDevice == null) {
            return;
        }
        List<ILibrary> list = iDevice.getClasspath().getEntries();
        if (list != null) {
            for (ILibrary iLibrary : list) {
                for (IAPI iAPI : iLibrary.getAPIs()) {
                    String string = iAPI.getIdentifier().replace(' ', '_');
                    string = SymbolUtils.replaceFirstNonLetterChar(string);
                    String string2 = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{iAPI.getVersion().getMajor(), iAPI.getVersion().getMinor()});
                    iSymbolSet.add(string, string2);
                }
            }
        }
    }

    private static void populateSymbolSetFromProperties(ISymbolSet iSymbolSet, Properties properties) {
        Properties properties2 = properties;
        Set<Map.Entry<Object, Object>> set = properties2.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String string = String.valueOf(entry.getKey());
            if (excludedProperties.contains(string)) continue;
            string = SymbolUtils.replaceFirstNonLetterChar(string);
            String string2 = String.valueOf(entry.getValue());
            iSymbolSet.add(string, string2);
        }
    }

    private static ISymbolSet createSymbolDefinitionSet(String string, HashMap<String, String> hashMap) {
        SymbolSet symbolSet = new SymbolSet();
        symbolSet.setName(string);
        symbolSet.add(string);
        for (String string2 : hashMap.keySet()) {
            try {
                String string3 = hashMap.get(string2);
                symbolSet.add(string2, string3);
            }
            catch (RuntimeException runtimeException) {
                MTJLogger.log(4, runtimeException);
            }
        }
        return symbolSet;
    }

    private static void copyCapabilities(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        for (String string : hashMap2.keySet()) {
            SymbolUtils.copyCapability(hashMap, string, hashMap2.get(string));
        }
    }

    private static void copyCapability(HashMap<String, String> hashMap, String string, String string2) {
        String string3 = hashMap.get(string);
        if (string3 == null || string3.equals("")) {
            hashMap.put(string, string2);
        } else {
            String string4 = SymbolUtils.mergeCapabilities(string3, string2);
            hashMap.put(string, string4);
        }
    }

    private static HashMap<String, String> getGroupCapabilities(HashMap<String, Element> hashMap, String string) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Element element = hashMap.get(string);
        if (element != null) {
            Element element2;
            Object object;
            NodeList nodeList = element.getElementsByTagName("parent");
            if (nodeList != null && nodeList.getLength() > 0 && (object = (element2 = (Element)nodeList.item(0)).getTextContent()) != null && !element2.getTextContent().equals("")) {
                HashMap<String, String> hashMap3 = SymbolUtils.getGroupCapabilities(hashMap, element2.getTextContent());
                SymbolUtils.copyCapabilities(hashMap2, hashMap3);
            }
            if ((nodeList = element.getElementsByTagName("capability")) != null && nodeList.getLength() > 0) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    object = (Element)nodeList.item(n);
                    hashMap2.put(object.getAttribute("name"), object.getAttribute("value"));
                    ++n;
                }
            }
        }
        return hashMap2;
    }

    private static String mergeCapabilities(String string, String string2) {
        String string3;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        stringTokenizer = new StringTokenizer(string2, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (vector.indexOf(string3) != -1) continue;
            vector.add(string3);
        }
        string3 = "";
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                string3 = string3.concat(J2MEPOLISH_CAPABILITY_SEPARATOR);
            }
            string3 = string3.concat((String)vector.elementAt(n));
            ++n;
        }
        return string3;
    }

    private static HashMap<String, Element> prepareGroups(Document document) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        NodeList nodeList = document.getElementsByTagName("group");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = ((Element)element.getElementsByTagName("name").item(0)).getTextContent();
            hashMap.put(string, element);
            ++n;
        }
        return hashMap;
    }
}

