/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;
import org.eclipse.mtj.internal.core.sign.PermissionsGroupsRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPermissionsScanner
extends SearchRequestor {
    private List<PermissionsGroup> permissions = new ArrayList<PermissionsGroup>();
    private IMidletSuiteProject midletSuiteProject;
    private PermissionsGroup currentPermission;

    public SecurityPermissionsScanner(IMidletSuiteProject iMidletSuiteProject) {
        this.midletSuiteProject = iMidletSuiteProject;
    }

    public List<PermissionsGroup> getRequiredPermissions() {
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.midletSuiteProject.getJavaProject()}, (int)9);
        int n = 8;
        SearchParticipant[] searchParticipantArray = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        List<PermissionsGroup> list = PermissionsGroupsRegistry.getInstance().getPermissions();
        SearchEngine searchEngine = new SearchEngine();
        Iterator<PermissionsGroup> iterator = list.iterator();
        while (iterator.hasNext()) {
            PermissionsGroup permissionsGroup;
            this.currentPermission = permissionsGroup = iterator.next();
            SearchPattern searchPattern = SearchPattern.createPattern((String)permissionsGroup.getClassName(), (int)0, (int)2, (int)n);
            try {
                searchEngine.search(searchPattern, searchParticipantArray, iJavaSearchScope, (SearchRequestor)this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                MTJLogger.log(2, "Error while scanning for permissions", coreException);
            }
        }
        return this.permissions;
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        if (!this.permissions.contains(this.currentPermission)) {
            this.permissions.add(this.currentPermission);
        }
    }
}

