/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
implements IApplicationDescriptor {
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ColonDelimitedProperties manifestProperties;
    private List<IMidletDefinition> midletDefinitions;
    private File sourceFile;

    public ApplicationDescriptor(File file) throws IOException {
        this.sourceFile = file;
        this.midletDefinitions = new ArrayList<IMidletDefinition>();
        this.parseDescriptor(file);
    }

    @Override
    public void addMidletDefinition(IMidletDefinition iMidletDefinition) {
        this.midletDefinitions.add(iMidletDefinition);
    }

    @Override
    public Version getConfigurationSpecificationVersion() throws CoreException {
        String[] stringArray;
        Version version = null;
        String string = this.manifestProperties.getProperty("MicroEdition-Configuration");
        if (string != null && (stringArray = string.split("-")).length == 2) {
            version = new Version(stringArray[1]);
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    @Override
    public ColonDelimitedProperties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    public String getMicroEditionConfiguration() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MicroEdition-Configuration");
        }
        return string;
    }

    @Override
    public String getMicroEditionProfile() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MicroEdition-Profile");
        }
        return string;
    }

    @Override
    public int getMidletCount() {
        return this.midletDefinitions.size();
    }

    @Override
    public String getMIDletDataSize() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Data-Size");
        }
        return string;
    }

    @Override
    public List<IMidletDefinition> getMidletDefinitions() {
        return this.midletDefinitions;
    }

    @Override
    public String getMIDletDeleteConfirm() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Delete-Confirm");
        }
        return string;
    }

    @Override
    public String getMIDletDeleteNotify() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Delete-Notify");
        }
        return string;
    }

    @Override
    public String getMIDletDescription() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Description");
        }
        return string;
    }

    @Override
    public String getMIDletIcon() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Icon");
        }
        return string;
    }

    @Override
    public String getMIDletInfoURL() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Info-URL");
        }
        return string;
    }

    @Override
    public String getMIDletInstallNotify() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Install-Notify");
        }
        return string;
    }

    @Override
    public String getMIDletJarSize() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Jar-Size");
        }
        return string;
    }

    @Override
    public String getMIDletJarURL() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Jar-URL");
        }
        return string;
    }

    @Override
    public String getMIDletName() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Name");
        }
        return string;
    }

    @Override
    public String getMIDletPermissions() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Permissions");
        }
        return string;
    }

    @Override
    public String getMIDletPermissionsOpt() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Permissions-Opt");
        }
        return string;
    }

    @Override
    public String getMIDletVendor() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Vendor");
        }
        return string;
    }

    @Override
    public Version getMIDletVersion() {
        String string;
        Version version = Version.emptyVersion;
        if (this.manifestProperties != null && (string = this.manifestProperties.getProperty("MIDlet-Jar-URL")) != null) {
            try {
                version = new Version(string);
            }
            catch (Exception exception) {}
        }
        return version;
    }

    @Override
    public void setMicroEditionConfiguration(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MicroEdition-Configuration", string);
        }
    }

    @Override
    public void setMicroEditionProfile(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MicroEdition-Profile", string);
        }
    }

    @Override
    public void setMIDletDataSize(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Data-Size", string);
        }
    }

    @Override
    public void setMIDletDeleteConfirm(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Delete-Confirm", string);
        }
    }

    @Override
    public void setMIDletDeleteNotify(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Delete-Notify", string);
        }
    }

    @Override
    public void setMIDletDescription(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Description", string);
        }
    }

    @Override
    public void setMIDletIcon(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Icon", string);
        }
    }

    @Override
    public void setMIDletInfoURL(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Info-URL", string);
        }
    }

    @Override
    public void setMIDletInstallNotify(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Install-Notify", string);
        }
    }

    @Override
    public void setMIDletJarSize(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Jar-Size", string);
        }
    }

    @Override
    public void setMIDletJarURL(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Jar-URL", string);
        }
    }

    @Override
    public void setMIDletName(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Name", string);
        }
    }

    @Override
    public void setMIDletPermissions(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Permissions", string);
        }
    }

    @Override
    public void setMIDletPermissionsOpt(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Permissions-Opt", string);
        }
    }

    @Override
    public void setMIDletVendor(String string) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Vendor", string);
        }
    }

    @Override
    public void setMIDletVersion(Version version) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Version", version.toString());
        }
    }

    @Override
    public void store() throws IOException {
        this.store(this.sourceFile);
    }

    @Override
    public void store(File file) throws IOException {
        ColonDelimitedProperties colonDelimitedProperties = this.copyProperties();
        for (IMidletDefinition object2 : this.midletDefinitions) {
            String throwable = MIDLET_PREFIX + object2.getNumber();
            String string = object2.toString();
            colonDelimitedProperties.setProperty(throwable, string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            colonDelimitedProperties.store(fileOutputStream, "MIDlet Property Definitions");
        }
        catch (Throwable throwable) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    private ColonDelimitedProperties copyProperties() {
        ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
        for (String string : this.manifestProperties.keySet()) {
            String string2 = this.manifestProperties.getProperty(string);
            colonDelimitedProperties.setProperty(string, string2);
        }
        return colonDelimitedProperties;
    }

    private void parseDescriptor(File file) throws IOException {
        this.manifestProperties = new ColonDelimitedProperties();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.manifestProperties.load(fileInputStream);
            this.parseMidletDefinitions();
        }
    }

    private void parseMidletDefinitions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.manifestProperties.size());
        for (Object object : this.manifestProperties.keySet()) {
            if (!((String)object).startsWith(MIDLET_PREFIX)) continue;
            int n = -1;
            try {
                n = Integer.parseInt(((String)object).substring(MIDLET_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {}
            if (n == -1) continue;
            String string = this.manifestProperties.getProperty((String)object);
            this.midletDefinitions.add(new MidletDefinition(n, string));
            arrayList.add(object);
        }
        for (String string : arrayList) {
            this.manifestProperties.remove(string);
        }
    }

    public static class MidletDefinition
    implements IMidletDefinition {
        private String className;
        private String icon;
        private String name;
        private int number;

        public MidletDefinition(int n, String string, String string2, String string3) {
            this.number = n;
            this.name = string;
            this.icon = string2;
            this.className = string3;
        }

        MidletDefinition(int n, String string) {
            int n2 = 0;
            this.number = n;
            this.name = "";
            this.icon = "";
            this.className = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(",")) {
                    ++n2;
                    continue;
                }
                switch (n2) {
                    case 0: {
                        this.name = string2;
                        break;
                    }
                    case 1: {
                        this.icon = string2;
                        break;
                    }
                    case 2: {
                        this.className = string2;
                    }
                }
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setIcon(String string) {
            this.icon = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(',');
            stringBuffer.append(this.icon).append(',');
            stringBuffer.append(this.className);
            return stringBuffer.toString();
        }
    }
}

