/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.model.security;

public class ProtectionDomain {
    private ProtectionDomainType protectionDomain = ProtectionDomainType.UNTRUSTED;

    public ProtectionDomain(ProtectionDomainType protectionDomainType) {
        this.protectionDomain = protectionDomainType;
    }

    public ProtectionDomain(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Domain string must not be null");
        }
        this.protectionDomain = ProtectionDomainType.getProtectionDomainType(string);
    }

    public ProtectionDomainType getProtectionDomainType() {
        return this.protectionDomain;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.protectionDomain == null ? 0 : this.protectionDomain.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ProtectionDomain)) {
            return false;
        }
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        return !(this.protectionDomain == null ? protectionDomain.protectionDomain != null : !this.protectionDomain.equals((Object)protectionDomain.protectionDomain));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtectionDomainType {
        MANUFACTURER,
        OPERATOR,
        THIRD_PARTY,
        UNTRUSTED;

        private static final String MANUFACTURER_KEY = "MANUFACTURER";
        private static final String OPERATOR_KEY = "OPERATOR";
        private static final String THIRD_PARTY_KEY = "THIRD_PARTY";
        private static final String UNTRUSTED_KEY = "UNTRUSTED";

        public static ProtectionDomainType getProtectionDomainType(String string) throws IllegalArgumentException {
            if (string.equals(MANUFACTURER_KEY)) {
                return MANUFACTURER;
            }
            if (string.equals(OPERATOR_KEY)) {
                return OPERATOR;
            }
            if (string.equals(THIRD_PARTY_KEY)) {
                return THIRD_PARTY;
            }
            if (string.equals(UNTRUSTED_KEY)) {
                return UNTRUSTED;
            }
            throw new IllegalArgumentException("Protection  Domain string must be one of the following: MANUFACTURER | OPERATOR | THIRD_PARTY | UNTRUSTED");
        }
    }
}

