/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Version;

public class LibraryApiEditorDialog
extends Dialog {
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_identifier_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_version_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_type_columnInfo, 20.0f, null), new TableColumnInfo(MTJUIMessages.LibraryApiEditorDialog_name_columnInfo, 50.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_IDENTIFIER = "identifier";
    private static final String PROP_NAME = "name";
    private static final String PROP_TYPE = "type";
    private static final String PROP_VERSION = "version";
    private static final String[] PROPERTIES = new String[]{"identifier", "version", "type", "name"};
    private List<IAPI> apis;
    private TableViewer viewer;

    public LibraryApiEditorDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    public LibraryApiEditorDialog(Shell shell) {
        super(shell);
    }

    public IAPI[] getAPIs() {
        return this.apis == null ? null : this.apis.toArray(new IAPI[this.apis.size()]);
    }

    public void setAPIs(IAPI[] iAPIArray) {
        this.apis = new ArrayList<IAPI>();
        this.apis.addAll(Arrays.asList(iAPIArray));
    }

    private TableViewer createTableViewer(Composite composite) {
        String[] stringArray = new String[]{MIDPAPIType.CONFIGURATION.toString(), MIDPAPIType.PROFILE.toString(), MIDPAPIType.OPTIONAL.toString(), MIDPAPIType.UNKNOWN.toString()};
        int n = 68098;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new LibraryApiContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new APILabelProvider());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("librayApiViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        tableViewer.setCellModifier((ICellModifier)new CellModifier());
        tableViewer.setColumnProperties(PROPERTIES);
        tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, stringArray), new TextCellEditor((Composite)table)});
        tableViewer.setInput(new Object());
        return tableViewer;
    }

    private IAPI getSelectedAPI() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        return (IAPI)iStructuredSelection.getFirstElement();
    }

    private void handleAddButton() {
        MIDPAPI mIDPAPI = new MIDPAPI();
        this.apis.add((IAPI)mIDPAPI);
        this.viewer.refresh();
    }

    private void handleRemoveButton() {
        IAPI iAPI = this.getSelectedAPI();
        if (iAPI != null) {
            this.apis.remove(iAPI);
            this.viewer.refresh();
        }
    }

    protected void buttonPressed(int n) {
        if (n == 1) {
            this.apis = null;
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String string = MTJUIMessages.LibraryApiEditorDialog_title;
        shell.setText(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(composite2);
        this.viewer.getTable().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, true));
        composite3.setLayoutData((Object)new GridData(1040));
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText(MTJUIMessages.LibraryApiEditorDialog_addButton_label_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LibraryApiEditorDialog.this.handleAddButton();
            }
        });
        final Button button2 = new Button(composite3, 8);
        button2.setEnabled(false);
        button2.setLayoutData((Object)new GridData(768));
        button2.setText(MTJUIMessages.LibraryApiEditorDialog_removeButton_label_text);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LibraryApiEditorDialog.this.handleRemoveButton();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IAPI iAPI = LibraryApiEditorDialog.this.getSelectedAPI();
                button2.setEnabled(iAPI != null);
            }
        });
        return composite2;
    }

    private static class APILabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private APILabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            IMIDPAPI iMIDPAPI = (IMIDPAPI)object;
            String string = "";
            switch (n) {
                case 0: {
                    string = iMIDPAPI.getIdentifier();
                    break;
                }
                case 1: {
                    string = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{iMIDPAPI.getVersion().getMajor(), iMIDPAPI.getVersion().getMinor()});
                    break;
                }
                case 2: {
                    string = iMIDPAPI.getType().toString();
                    break;
                }
                case 3: {
                    string = iMIDPAPI.getName();
                }
            }
            return string;
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            Object object2 = null;
            IMIDPAPI iMIDPAPI = (IMIDPAPI)object;
            switch (this.getColumnIndex(string)) {
                case 0: {
                    object2 = iMIDPAPI.getIdentifier();
                    break;
                }
                case 1: {
                    object2 = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{iMIDPAPI.getVersion().getMajor(), iMIDPAPI.getVersion().getMinor()});
                    break;
                }
                case 2: {
                    object2 = iMIDPAPI.getType().getTypecode();
                    break;
                }
                case 3: {
                    object2 = iMIDPAPI.getName();
                }
            }
            return object2;
        }

        public void modify(Object object, String string, Object object2) {
            TableItem tableItem = (TableItem)object;
            IMIDPAPI iMIDPAPI = (IMIDPAPI)tableItem.getData();
            switch (this.getColumnIndex(string)) {
                case 0: {
                    iMIDPAPI.setIdentifier((String)object2);
                    break;
                }
                case 1: {
                    iMIDPAPI.setVersion(new Version((String)object2));
                    break;
                }
                case 2: {
                    Integer n = (Integer)object2;
                    iMIDPAPI.setType(MIDPAPIType.getMIDPAPITypeByCode((int)n));
                    break;
                }
                case 3: {
                    iMIDPAPI.setName((String)object2);
                }
            }
            LibraryApiEditorDialog.this.viewer.refresh((Object)iMIDPAPI, true);
        }

        private int getColumnIndex(String string) {
            int n = -1;
            int n2 = 0;
            while (n2 < PROPERTIES.length) {
                if (PROPERTIES[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }
    }

    private class LibraryApiContentProvider
    implements IStructuredContentProvider {
        private LibraryApiContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            if (LibraryApiEditorDialog.this.apis != null) {
                objectArray = LibraryApiEditorDialog.this.apis.toArray(new IAPI[LibraryApiEditorDialog.this.apis.size()]);
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

