/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarEntry;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;

public class TarInputStream
extends FilterInputStream {
    private int nextEntry = 0;
    private int nextEOF = 0;
    private int filepos = 0;
    private int bytesread = 0;
    private TarEntry firstEntry = null;
    private String longLinkName = null;

    public TarInputStream(InputStream inputStream) throws TarException, IOException {
        super(inputStream);
        this.firstEntry = this.getNextEntry();
    }

    TarInputStream(InputStream inputStream, TarEntry tarEntry) throws TarException, IOException {
        super(inputStream);
        this.skipToEntry(tarEntry);
    }

    private long headerChecksum(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < 512) {
            l += (long)(byArray[n] & 0xFF);
            ++n;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    boolean skipToEntry(TarEntry var1_1) throws TarException, IOException {
        var2_2 = var1_1.filepos - this.bytesread;
        if (var2_2 >= 0) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = this.in.skip(var2_2);
            if (var3_3 < 0L) {
                throw new IOException("early end of stream");
            }
            var2_2 = (int)((long)var2_2 - var3_3);
            this.bytesread = (int)((long)this.bytesread + var3_3);
lbl9:
            // 2 sources

            ** while (var2_2 > 0)
        }
lbl10:
        // 1 sources

        this.filepos = var1_1.filepos;
        this.nextEntry = 0;
        this.nextEOF = 0;
        this.getNextEntry();
        return true;
    }

    private boolean isValidTarHeader(byte[] byArray) {
        long l;
        int n = 148;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < 8) {
            if (byArray[n + n2] != 32) {
                if (byArray[n + n2] == 0 || !Character.isDigit((char)byArray[n + n2])) break;
                stringBuffer.append((char)byArray[n + n2]);
            }
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            return false;
        }
        if (stringBuffer.charAt(0) != '0') {
            stringBuffer.insert(0, '0');
        }
        try {
            l = Long.decode(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        n2 = 0;
        while (n2 < 8) {
            byArray[n + n2] = 32;
            ++n2;
        }
        long l2 = this.headerChecksum(byArray);
        return l == l2;
    }

    /*
     * Unable to fully structure code
     */
    TarEntry getNextEntryInternal() throws TarException, IOException {
        var1_1 = new byte[512];
        var2_2 = 0;
        if (this.firstEntry == null) ** GOTO lbl12
        var4_3 = this.firstEntry;
        this.firstEntry = null;
        return var4_3;
lbl-1000:
        // 1 sources

        {
            var4_4 = this.in.skip(this.nextEntry);
            if (var4_4 < 0L) {
                throw new IOException("early end of stream");
            }
            this.nextEntry = (int)((long)this.nextEntry - var4_4);
            this.bytesread = (int)((long)this.bytesread + var4_4);
lbl12:
            // 2 sources

            ** while (this.nextEntry > 0)
        }
lbl13:
        // 1 sources

        var4_5 = 512;
        while (var4_5 > 0) {
            var5_6 = super.read(var1_1, 512 - var4_5, var4_5);
            if (var5_6 < 0) {
                throw new IOException("early end of stream");
            }
            var4_5 -= var5_6;
            this.bytesread += var5_6;
        }
        if (this.headerChecksum(var1_1) == 0L) {
            if (this.filepos > 0) {
                return null;
            }
            throw new TarException("not in tar format");
        }
        if (this.isValidTarHeader(var1_1)) ** GOTO lbl28
        throw new TarException("not in tar format");
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl28:
            // 2 sources

            ** while (var2_2 < 100 && var1_1[var2_2] != 0)
        }
lbl29:
        // 1 sources

        var5_7 = new String(var1_1, 0, var2_2, "UTF8");
        var2_2 = 345;
        if (var1_1[var2_2] != 0) {
            while (var2_2 < 500 && var1_1[var2_2] != 0) {
                ++var2_2;
            }
            var6_8 = new String(var1_1, 345, var2_2 - 345, "UTF8");
            var5_7 = String.valueOf(var6_8) + "/" + var5_7;
        }
        if (this.longLinkName != null) {
            var6_8 = new TarEntry(this.longLinkName, this.filepos);
            this.longLinkName = null;
        } else {
            var6_8 = new TarEntry(var5_7, this.filepos);
        }
        if (var1_1[156] != 0) {
            var6_8.setFileType(var1_1[156]);
        }
        var2_2 = 100;
        var7_9 = new StringBuffer();
        var3_10 = 0;
        while (var3_10 < 8) {
            if (var1_1[var2_2 + var3_10] == 0) break;
            if (var1_1[var2_2 + var3_10] != 32) {
                var7_9.append((char)var1_1[var2_2 + var3_10]);
            }
            ++var3_10;
        }
        if (var7_9.length() > 0 && var7_9.charAt(0) != '0') {
            var7_9.insert(0, '0');
        }
        try {
            var8_11 = Long.decode(var7_9.toString());
            var6_8.setMode(var8_11);
        }
        catch (NumberFormatException var8_12) {
            throw new TarException(ProjectImporterMessage.TarImport_invalid_tar_format, var8_12);
        }
        var2_2 = 124;
        var8_13 = new StringBuffer();
        var3_10 = 0;
        while (var3_10 < 12) {
            if (var1_1[var2_2 + var3_10] == 0) break;
            if (var1_1[var2_2 + var3_10] != 32) {
                var8_13.append((char)var1_1[var2_2 + var3_10]);
            }
            ++var3_10;
        }
        if (var8_13.charAt(0) != '0') {
            var8_13.insert(0, '0');
        }
        try {
            var9_14 = Integer.decode(var8_13.toString());
        }
        catch (NumberFormatException var10_15) {
            throw new TarException(ProjectImporterMessage.TarImport_invalid_tar_format, var10_15);
        }
        var6_8.setSize(var9_14);
        this.nextEOF = var9_14;
        this.nextEntry = var9_14 % 512 > 0 ? var9_14 + (512 - var9_14 % 512) : var9_14;
        this.filepos += this.nextEntry + 512;
        return var6_8;
    }

    public TarEntry getNextEntry() throws TarException, IOException {
        TarEntry tarEntry = this.getNextEntryInternal();
        if (tarEntry != null && tarEntry.getName().equals("././@LongLink")) {
            int n;
            byte[] byArray = new byte[(int)tarEntry.getSize()];
            int n2 = 0;
            while (n2 < byArray.length) {
                n = this.read(byArray, n2, byArray.length - n2);
                if (n < 0) {
                    throw new IOException("early end of stream");
                }
                n2 += n;
            }
            n = 0;
            while (n < byArray.length && byArray[n] != 0) {
                ++n;
            }
            this.longLinkName = new String(byArray, 0, n, "UTF8");
            return this.getNextEntryInternal();
        }
        return tarEntry;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.nextEOF == 0) {
            return -1;
        }
        if (n2 > this.nextEOF) {
            n2 = this.nextEOF;
        }
        int n3 = super.read(byArray, n, n2);
        this.nextEntry -= n3;
        this.nextEOF -= n3;
        this.bytesread += n3;
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n < 0) {
            return n;
        }
        return byArray[0];
    }
}

