/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.forms.blocks.ButtonBarBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.DetailPage;
import org.eclipse.mtj.internal.ui.forms.blocks.MasterLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrolledPropertiesBlock
extends MasterDetailsBlock {
    private ButtonBarBlock buttonBarBlock = null;
    private ISelection currentSelectedItem;
    private List<DetailPage> detailPages;
    private IStructuredContentProvider masterContentProvider;
    private MasterLabelProvider masterLabelProvider;
    private FormPage page;
    private TableViewer viewer;

    public ScrolledPropertiesBlock(FormPage formPage, IStructuredContentProvider iStructuredContentProvider, MasterLabelProvider masterLabelProvider, List<DetailPage> list) {
        this.page = formPage;
        this.masterContentProvider = iStructuredContentProvider;
        this.masterLabelProvider = masterLabelProvider;
        this.detailPages = list;
    }

    public ButtonBarBlock getButtonBarBlock() {
        return this.buttonBarBlock;
    }

    public ISelection getCurrentSelectedItem() {
        return this.currentSelectedItem;
    }

    public IStructuredContentProvider getMasterContentProvider() {
        return this.masterContentProvider;
    }

    public MasterLabelProvider getMasterLabelProvider() {
        return this.masterLabelProvider;
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void setCurrentSelectedItem(ISelection iSelection) {
        this.viewer.setSelection(iSelection);
    }

    public void setMasterContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.masterContentProvider = iStructuredContentProvider;
    }

    public void setMasterLabelProvider(MasterLabelProvider masterLabelProvider) {
        this.masterLabelProvider = masterLabelProvider;
    }

    protected void createMasterPart(final IManagedForm iManagedForm, Composite composite) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        section.setText(MTJUIMessages.ScrolledPropertiesBlock_midlet_list_section_title);
        section.setDescription(MTJUIMessages.ScrolledPropertiesBlock_midlet_list_section_description);
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite composite2 = formToolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0);
        new Label(composite2, 0);
        Table table = formToolkit.createTable(composite2, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 20;
        gridData.widthHint = 100;
        table.setLayoutData((Object)gridData);
        formToolkit.paintBordersFor(composite2);
        Composite composite3 = formToolkit.createComposite(composite2);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 3;
        composite3.setLayout((Layout)fillLayout);
        this.buttonBarBlock = new ButtonBarBlock(composite3, formToolkit, 30);
        section.setClient((Control)composite2);
        final SectionPart sectionPart = new SectionPart(section);
        iManagedForm.addPart((IFormPart)sectionPart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ScrolledPropertiesBlock.this.currentSelectedItem = selectionChangedEvent.getSelection();
                iManagedForm.fireSelectionChanged((IFormPart)sectionPart, selectionChangedEvent.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.masterContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.masterLabelProvider);
        this.viewer.setInput((Object)this.page.getEditor().getEditorInput());
    }

    protected void createToolBarActions(IManagedForm iManagedForm) {
        final ScrolledForm scrolledForm = iManagedForm.getForm();
        Action action = new Action("hor", 8){

            public void run() {
                ScrolledPropertiesBlock.this.sashForm.setOrientation(256);
                scrolledForm.reflow(true);
            }
        };
        action.setChecked(true);
        action.setToolTipText(MTJUIMessages.ScrolledPropertiesBlock_hor_action_toolTipText);
        action.setImageDescriptor(MTJUIPluginImages.DESC_HORIZONTAL);
        Action action2 = new Action("ver", 8){

            public void run() {
                ScrolledPropertiesBlock.this.sashForm.setOrientation(512);
                scrolledForm.reflow(true);
            }
        };
        action2.setChecked(false);
        action2.setToolTipText(MTJUIMessages.ScrolledPropertiesBlock_ver_action_toolTipText);
        action2.setImageDescriptor(MTJUIPluginImages.DESC_VERTICAL);
        scrolledForm.getToolBarManager().add((IAction)action);
        scrolledForm.getToolBarManager().add((IAction)action2);
    }

    protected void registerPages(DetailsPart detailsPart) {
        Iterator<DetailPage> iterator = this.detailPages.iterator();
        while (iterator.hasNext()) {
            DetailPage detailPage;
            DetailPage detailPage2 = detailPage = iterator.next();
            detailsPart.registerPage(detailPage2.getObjectClass(), detailPage2.getDetailsPage());
        }
    }
}

