/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.forms.blocks.ButtonBarBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericListBlock<T extends GenericListBlockItem> {
    private List<GenericListBlockListener<T>> listeners;
    private ButtonBarBlock buttonBar;
    private int buttons;
    private TableViewer viewer;
    private List<T> input;

    public GenericListBlock(Composite composite, int n, int n2, List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Input can not be null.");
        }
        this.listeners = new ArrayList<GenericListBlockListener<T>>();
        this.input = list;
        this.createControl(composite, n, n2);
    }

    public void addGenericListBlockListener(GenericListBlockListener<T> genericListBlockListener) {
        this.listeners.add(genericListBlockListener);
    }

    public void removeGenericListBlockListener(GenericListBlockListener<T> genericListBlockListener) {
        this.listeners.remove(genericListBlockListener);
    }

    private void createControl(Composite composite, int n, int n2) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(composite2, n);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new AdvancedListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdvancedListLabelProvider());
        this.viewer.setInput(this.input);
        this.createButtons(composite2, n2);
    }

    private void createButtons(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        composite2.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 3;
        composite2.setLayout((Layout)fillLayout);
        this.buttons = n | 8 | 0x10;
        this.buttonBar = new ButtonBarBlock(composite2, this.buttons);
        if ((n & 2) != 0) {
            this.buttonBar.setEnabled(0, true);
            this.buttonBar.getButton(0).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseDown(MouseEvent mouseEvent) {
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    for (GenericListBlockListener genericListBlockListener : GenericListBlock.this.listeners) {
                        genericListBlockListener.addButtonPressed();
                    }
                    GenericListBlock.this.updateButtonsStates();
                    GenericListBlock.this.viewer.refresh();
                }
            });
        }
        if ((n & 0x20) != 0) {
            this.buttonBar.setEnabled(4, true);
            this.buttonBar.getButton(4).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseDown(MouseEvent mouseEvent) {
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    for (GenericListBlockListener genericListBlockListener : GenericListBlock.this.listeners) {
                        genericListBlockListener.scan();
                    }
                }
            });
        }
        if ((n & 4) != 0) {
            this.buttonBar.setEnabled(1, this.input.size() > 0);
            this.buttonBar.getButton(1).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseDown(MouseEvent mouseEvent) {
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    ISelection iSelection = GenericListBlock.this.viewer.getSelection();
                    if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    List list = iStructuredSelection.toList();
                    if (list.size() == 0) {
                        return;
                    }
                    for (Object object : list) {
                        GenericListBlock.this.input.remove(object);
                    }
                    GenericListBlock.this.updateButtonsStates();
                    GenericListBlock.this.viewer.refresh();
                    for (Object object : GenericListBlock.this.listeners) {
                        object.itemsRemoved(list);
                    }
                }
            });
        }
        if (this.input.size() > 1) {
            this.buttonBar.setEnabled(2, true);
            this.buttonBar.setEnabled(3, true);
        }
        this.buttonBar.getButton(2).addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                ISelection iSelection = GenericListBlock.this.viewer.getSelection();
                if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                List list = iStructuredSelection.toList();
                if (list.size() > 1) {
                    return;
                }
                GenericListBlockItem genericListBlockItem = (GenericListBlockItem)iStructuredSelection.getFirstElement();
                int n = GenericListBlock.this.input.indexOf(genericListBlockItem);
                if (n > 0) {
                    GenericListBlock.this.input.remove(n);
                    GenericListBlock.this.input.add(--n, genericListBlockItem);
                    GenericListBlock.this.viewer.refresh();
                }
                for (GenericListBlockListener genericListBlockListener : GenericListBlock.this.listeners) {
                    genericListBlockListener.upButtonPressed();
                }
            }
        });
        this.buttonBar.getButton(3).addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                ISelection iSelection = GenericListBlock.this.viewer.getSelection();
                if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                List list = iStructuredSelection.toList();
                if (list.size() > 1) {
                    return;
                }
                GenericListBlockItem genericListBlockItem = (GenericListBlockItem)iStructuredSelection.getFirstElement();
                int n = GenericListBlock.this.input.indexOf(genericListBlockItem);
                if (n < GenericListBlock.this.input.size() - 1) {
                    GenericListBlock.this.input.remove(n);
                    GenericListBlock.this.input.add(++n, genericListBlockItem);
                    GenericListBlock.this.viewer.refresh();
                }
                for (GenericListBlockListener genericListBlockListener : GenericListBlock.this.listeners) {
                    genericListBlockListener.downButtonPressed();
                }
            }
        });
    }

    private void updateButtonsStates() {
        if (this.viewer.getControl().isEnabled()) {
            if ((this.buttons & 4) != 0) {
                this.buttonBar.setEnabled(1, this.input.size() > 0);
            }
            this.buttonBar.setEnabled(2, this.input.size() > 1);
            this.buttonBar.setEnabled(3, this.input.size() > 1);
        }
    }

    public void update() {
        this.updateButtonsStates();
        this.viewer.refresh();
    }

    public void setEnabled(boolean bl) {
        this.viewer.getControl().setEnabled(bl);
        this.buttonBar.setEnabled(bl);
        this.updateButtonsStates();
    }

    private class AdvancedListContentProvider
    implements IStructuredContentProvider {
        private AdvancedListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            viewer.refresh();
        }

        public Object[] getElements(Object object) {
            if (object instanceof List) {
                List list = (List)object;
                return list.toArray(new GenericListBlockItem[list.size()]);
            }
            return null;
        }

        public void dispose() {
        }
    }

    private class AdvancedListLabelProvider
    extends LabelProvider {
        private AdvancedListLabelProvider() {
        }

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof GenericListBlockItem) {
                image = ((GenericListBlockItem)object).getImage();
            }
            return image;
        }

        public String getText(Object object) {
            String string = null;
            if (object instanceof GenericListBlockItem) {
                string = ((GenericListBlockItem)object).getText();
            }
            return string;
        }
    }
}

