/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJMasterDetailsBlock;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesBlock;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nSourcePage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LocalizationPage
extends MTJFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "localizationPage";
    private LocalesBlock fBlock = new LocalesBlock(this);

    public LocalizationPage(FormEditor formEditor) {
        super(formEditor, PAGE_ID, MTJUIMessages.LocalizationPage_title);
    }

    public void dispose() {
        L10nModel l10nModel = (L10nModel)this.getModel();
        if (l10nModel != null) {
            l10nModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public MTJMasterDetailsBlock getBlock() {
        return this.fBlock;
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        this.fBlock.modelChanged(iModelChangedEvent);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl) {
            L10nLocales l10nLocales;
            L10nModel l10nModel;
            IFormPage iFormPage = this.getMTJEditor().findPage("l10n-context");
            if (iFormPage instanceof L10nSourcePage && ((L10nSourcePage)iFormPage).getInputContext().isInSourceMode()) {
                l10nModel = ((L10nSourcePage)iFormPage).getViewer();
                if (l10nModel == null) {
                    return;
                }
                l10nLocales = l10nModel.getTextWidget();
                if (l10nLocales == null) {
                    return;
                }
                int n = l10nLocales.getCaretOffset();
                if (n < 0) {
                    return;
                }
                IDocumentRange iDocumentRange = ((L10nSourcePage)iFormPage).getRangeElement(n, true);
                if (iDocumentRange instanceof IDocumentAttributeNode) {
                    iDocumentRange = ((IDocumentAttributeNode)iDocumentRange).getEnclosingElement();
                } else if (iDocumentRange instanceof IDocumentTextNode) {
                    iDocumentRange = ((IDocumentTextNode)iDocumentRange).getEnclosingElement();
                }
                if (iDocumentRange instanceof L10nObject) {
                    this.fBlock.getMasterSection().setSelection((ISelection)new StructuredSelection((Object)iDocumentRange));
                }
            }
            if ((l10nModel = (L10nModel)this.getModel()) != null && (l10nLocales = l10nModel.getLocales()) != null && l10nLocales.getDefaultLocale() == null) {
                IMessageManager iMessageManager = this.getManagedForm().getMessageManager();
                iMessageManager.addMessage((Object)this, MTJUIMessages.L10nLocaleDetails_noDefaultLocale, null, 2);
            }
        }
    }

    private void createErrorContent(IManagedForm iManagedForm, L10nModel l10nModel) {
        this.createFormErrorContent(iManagedForm, MTJUIMessages.LocalizationPage_formErrorContent_title, MTJUIMessages.LocalizationPage_formErrorContent_message);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        L10nModel l10nModel = (L10nModel)this.getModel();
        if (l10nModel == null || !l10nModel.isLoaded()) {
            this.createErrorContent(iManagedForm, l10nModel);
            return;
        }
        super.createFormContent(iManagedForm);
        scrolledForm.setText(MTJUIMessages.LocalizationPage_text);
        this.fBlock.createContent(iManagedForm);
        this.fBlock.getMasterSection().fireSelection();
        l10nModel.addModelChangedListener((IModelChangedListener)this);
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/localization/l10nEditorPage.html";
    }
}

