/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesPage;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesSourcePage;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADEditorPageConfigElement;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.JADSourceEditorPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.OverviewEditorPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.SigningJADEditorPage;
import org.eclipse.mtj.internal.ui.util.ManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IInPlaceEditor;
import org.eclipse.ui.IInPlaceEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileInPlaceEditorInput;

public class JADFormEditor
extends FormEditor
implements IInPlaceEditor {
    private static JADEditorPageConfigElement[] jadEditorPageConfigElements;
    private boolean cleanRequired;
    private List<AbstractJADEditorPage> configPages = new ArrayList<AbstractJADEditorPage>();
    private IFile jadFile;
    private long modificationStamp;
    private ManifestPreferenceStore preferenceStore;
    private JADSourceEditorPage sourceEditor;
    private IFormPage[] buildPropertiesPages;

    public void doSave(IProgressMonitor iProgressMonitor) {
        AbstractJADEditorPage abstractJADEditorPage2;
        iProgressMonitor.beginTask(MTJUIMessages.JADFormEditor_save_jad_task_name, this.getPageCount() + 1);
        boolean bl = this.sourceEditor.isDirty();
        int n = 0;
        for (AbstractJADEditorPage abstractJADEditorPage2 : this.configPages) {
            AbstractJADEditorPage abstractJADEditorPage3;
            if (abstractJADEditorPage2 instanceof IFormPage && (abstractJADEditorPage3 = abstractJADEditorPage2) != null && abstractJADEditorPage3.getPartControl() != null) {
                if (abstractJADEditorPage3.isDirty() && !bl) {
                    abstractJADEditorPage3.doSave(iProgressMonitor);
                    iProgressMonitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_save_jad_subtask_name, (Object)abstractJADEditorPage3.getTitle()));
                } else {
                    iProgressMonitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_ignore_save_jad_subtask_name, (Object)abstractJADEditorPage3.getTitle()));
                    abstractJADEditorPage3.setDirty(false);
                }
            }
            iProgressMonitor.worked(n + 1);
        }
        if (this.buildPropertiesPages != null) {
            IFormPage[] iFormPageArray = this.buildPropertiesPages;
            int n2 = this.buildPropertiesPages.length;
            int n3 = 0;
            while (n3 < n2) {
                abstractJADEditorPage2 = iFormPageArray[n3];
                abstractJADEditorPage2.doSave(iProgressMonitor);
                ++n3;
            }
        }
        if (bl) {
            this.sourceEditor.doSave(iProgressMonitor);
            this.updateEditorInput();
            iProgressMonitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_save_jad_subtask_name, (Object)this.sourceEditor.getTitle()));
            iProgressMonitor.worked(n + 1);
        }
        try {
            if (this.jadFile.exists() && this.jadFile.isReadOnly()) {
                abstractJADEditorPage2 = this.jadFile.getResourceAttributes();
                abstractJADEditorPage2.setReadOnly(false);
                this.jadFile.setResourceAttributes((ResourceAttributes)abstractJADEditorPage2);
            }
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, iProgressMonitor);
            }
            if (this.jadFile != null && this.cleanRequired) {
                this.jadFile.getProject().build(15, iProgressMonitor);
            }
        }
        catch (IOException iOException) {
            MTJLogger.log((int)4, (Throwable)iOException);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
        iProgressMonitor.done();
        this.editorDirtyStateChanged();
        this.reloadLocalFile();
    }

    public void doSaveAs() {
    }

    public IFile getJadFile() {
        return this.jadFile;
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public boolean isDirty() {
        boolean bl = false;
        for (Object e : this.pages) {
            IFormPage iFormPage;
            if (!(e instanceof IFormPage) || (iFormPage = (IFormPage)e) == null || iFormPage.getPartControl() == null || !iFormPage.isDirty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isUserDefinedPropertyKey(String string) {
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            if (abstractJADEditorPage == null || !abstractJADEditorPage.isManagingProperty(string)) continue;
            return false;
        }
        return true;
    }

    public void setCleanRequired(boolean bl) {
        this.cleanRequired = bl;
    }

    public void setFocus() {
        File file = this.getLocalFile();
        if (file != null && file.lastModified() > this.modificationStamp && this.shouldReloadLocalFile()) {
            this.reloadLocalFile();
        }
        super.setFocus();
    }

    public void sourceChanged(IInPlaceEditorInput iInPlaceEditorInput) {
        this.getSite().getPage().closeEditor((IEditorPart)this, true);
    }

    public void sourceDeleted() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    private JADEditorPageConfigElement[] getAllEditorPageConfigElements() {
        if (jadEditorPageConfigElements == null) {
            jadEditorPageConfigElements = this.readAllVendorSpecJADAttributes();
        }
        return jadEditorPageConfigElements;
    }

    private File getLocalFile() {
        File file = null;
        try {
            file = this.jadFile.getLocation().toFile();
        }
        catch (Exception exception) {
            MTJLogger.log((int)4, (Throwable)exception);
        }
        return file;
    }

    private JADEditorPageConfigElement[] readAllVendorSpecJADAttributes() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, "jadeditorpage");
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = new JADEditorPageConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            jADEditorPageConfigElementArray[n] = new JADEditorPageConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return jADEditorPageConfigElementArray;
    }

    private void reloadLocalFile() {
        this.updateEditorInput();
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            if (abstractJADEditorPage == null) continue;
            abstractJADEditorPage.editorInputChanged();
        }
    }

    private boolean shouldReloadLocalFile() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MTJUIMessages.JADFormEditor_shouldReloadLocalFile_dialod_title, (String)MTJUIMessages.JADFormEditor_shouldReloadLocalFile_dialog_message);
    }

    private void updateEditorInput() {
        File file = this.getLocalFile();
        this.modificationStamp = file.lastModified();
        String string = file.toString();
        this.preferenceStore = new ManifestPreferenceStore(string);
        try {
            this.preferenceStore.load();
        }
        catch (IOException iOException) {
            MTJLogger.log((int)2, (Throwable)iOException);
        }
    }

    protected void addPages() {
        Object object;
        super.setPartName(this.jadFile.getProject().getName());
        IFormPage iFormPage = this.getAllEditorPageConfigElements();
        Arrays.sort(iFormPage, new Comparator<JADEditorPageConfigElement>(){

            @Override
            public int compare(JADEditorPageConfigElement jADEditorPageConfigElement, JADEditorPageConfigElement jADEditorPageConfigElement2) {
                return jADEditorPageConfigElement.getPriority() - jADEditorPageConfigElement2.getPriority();
            }
        });
        try {
            object = new OverviewEditorPage(this);
            this.addPage((IFormPage)object);
            this.configPages.add((AbstractJADEditorPage)((Object)object));
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        IFormPage iFormPage2 = iFormPage;
        int n = ((JADEditorPageConfigElement[])iFormPage2).length;
        int n2 = 0;
        while (n2 < n) {
            object = iFormPage2[n2];
            try {
                AbstractJADEditorPage abstractJADEditorPage = ((JADEditorPageConfigElement)object).getJADEditorPage();
                abstractJADEditorPage.initialize(this);
                this.addPage((IFormPage)abstractJADEditorPage);
                this.configPages.add(abstractJADEditorPage);
            }
            catch (Exception exception) {
                MTJLogger.log((int)4, (Throwable)exception);
            }
            ++n2;
        }
        try {
            object = new SigningJADEditorPage(this);
            this.addPage((IFormPage)object);
            this.configPages.add((AbstractJADEditorPage)((Object)object));
        }
        catch (PartInitException partInitException) {
            MTJLogger.log((int)4, (Throwable)partInitException);
        }
        try {
            IMidletSuiteProject iMidletSuiteProject;
            MTJBuildProperties mTJBuildProperties;
            object = JavaCore.create((IProject)this.jadFile.getProject());
            if (object != null && (mTJBuildProperties = MTJBuildProperties.getBuildProperties((IMTJProject)(iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)object)))).getBuildPropertyFile().exists()) {
                IFormPage[] iFormPageArray = this.buildPropertiesPages = new IFormPage[]{new BuildPropertiesPage(this, mTJBuildProperties), new BuildPropertiesSourcePage(this, mTJBuildProperties)};
                int n3 = this.buildPropertiesPages.length;
                int n4 = 0;
                while (n4 < n3) {
                    iFormPage2 = iFormPageArray[n4];
                    this.addPage(iFormPage2);
                    ++n4;
                }
            }
        }
        catch (PartInitException partInitException) {
            MTJLogger.log((int)4, (Throwable)partInitException);
        }
        this.sourceEditor = new JADSourceEditorPage(this);
        try {
            this.addPage((IEditorPart)this.sourceEditor, super.getEditorInput());
        }
        catch (PartInitException partInitException) {
            MTJLogger.log((int)4, (Throwable)partInitException);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        FileInPlaceEditorInput fileInPlaceEditorInput;
        if (iEditorInput instanceof FileEditorInput) {
            fileInPlaceEditorInput = new FileInPlaceEditorInput(((FileEditorInput)iEditorInput).getFile());
            fileInPlaceEditorInput.setInPlaceEditor((IInPlaceEditor)this);
            super.setInput((IEditorInput)fileInPlaceEditorInput);
        } else {
            super.setInput(iEditorInput);
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            fileInPlaceEditorInput = (IStorageEditorInput)iEditorInput;
            try {
                IPath iPath = fileInPlaceEditorInput.getStorage().getFullPath();
                if (iPath != null) {
                    IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
                    this.jadFile = iWorkspaceRoot.getFile(iPath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        this.updateEditorInput();
                    }
                }
            }
            catch (Exception exception) {
                MTJLogger.log((int)2, (Throwable)exception);
            }
        }
    }
}

