/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.device.pages;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceBasicEditorPage
extends AbstractDeviceEditorPage {
    private static final Boolean[] BOOLEAN_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private ComboViewer debugServerCombo;
    private Text descriptionText;
    private Button executableBrowseButton;
    private Text executableText;
    private Text groupText;
    private boolean javaExecutableDevice;
    private Text launchCommandText;
    private Text nameText;
    private boolean preverifierEnabled;
    private Button preverifyBrowseButton;
    private Text preverifyExecutableText;

    public DeviceBasicEditorPage(Composite composite, boolean bl, int n) {
        super(composite, n);
        this.javaExecutableDevice = bl;
        this.preverifierEnabled = true;
    }

    public void commitDeviceChanges() throws CoreException {
        File file;
        this.editDevice.setName(this.nameText.getText());
        this.editDevice.setGroupName(this.groupText.getText());
        this.editDevice.setDescription(this.descriptionText.getText());
        if (!this.javaExecutableDevice) {
            this.editDevice.setExecutable(new File(this.executableText.getText()));
        }
        this.editDevice.setDebugServer(this.getBooleanSelection(this.debugServerCombo));
        this.editDevice.setLaunchCommandTemplate(this.launchCommandText.getText());
        if (this.preverifierEnabled && (file = new File(this.preverifyExecutableText.getText())).exists()) {
            IPreverifier iPreverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file);
            this.editDevice.setPreverifier(iPreverifier);
        }
    }

    public String getDescription() {
        return MTJUIMessages.DeviceBasicEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceBasicEditorPage_title;
    }

    public void setDevice(IMIDPDevice iMIDPDevice) {
        super.setDevice(iMIDPDevice);
        this.initializeDeviceState();
    }

    private ComboViewer createBooleanComboViewer(Composite composite) {
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setContentProvider((IContentProvider)new BooleanContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new BooleanLabelProvider());
        comboViewer.setInput(new Object());
        return comboViewer;
    }

    private boolean getBooleanSelection(ComboViewer comboViewer) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)comboViewer.getSelection();
        Boolean bl = (Boolean)iStructuredSelection.getFirstElement();
        return bl;
    }

    private void initializeDeviceState() {
        if (this.nameText != null && this.editDevice != null) {
            this.nameText.setText(this.editDevice.getName());
            this.groupText.setText(this.editDevice.getSDKName());
            this.descriptionText.setText(this.editDevice.getDescription());
            String string = this.javaExecutableDevice ? "Java" : this.editDevice.getExecutable().toString();
            this.executableText.setText(string);
            this.executableText.setEnabled(!this.javaExecutableDevice);
            this.executableBrowseButton.setEnabled(!this.javaExecutableDevice);
            this.setBooleanSelection(this.debugServerCombo, this.editDevice.isDebugServer());
            this.launchCommandText.setText(this.editDevice.getLaunchCommandTemplate());
            this.preverifierEnabled = true;
            IPreverifier iPreverifier = this.editDevice.getPreverifier();
            this.preverifierEnabled = true;
            this.preverifyExecutableText.setText(iPreverifier != null ? iPreverifier.getPreverifierExecutable().toString() : "");
            this.preverifyBrowseButton.setEnabled(this.preverifierEnabled);
            this.preverifyExecutableText.setEnabled(this.preverifierEnabled);
        }
    }

    private void setBooleanSelection(ComboViewer comboViewer, boolean bl) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)bl);
        comboViewer.setSelection((ISelection)structuredSelection, true);
    }

    private void updateState() {
        String string = null;
        if (this.nameText.getText().length() == 0) {
            string = MTJUIMessages.DeviceBasicEditorPage_error_no_device_name;
        } else if (this.groupText.getText().length() == 0) {
            string = MTJUIMessages.DeviceBasicEditorPage_error_no_device_group;
        } else if (this.launchCommandText.getText().length() == 0) {
            string = MTJUIMessages.DeviceBasicEditorPage_error_no_launch_command;
        } else {
            File file = new File(this.executableText.getText());
            if (!this.javaExecutableDevice && !file.exists()) {
                string = MTJUIMessages.DeviceBasicEditorPage_error_invalid_executable;
            } else {
                file = new File(this.preverifyExecutableText.getText());
                if (!file.exists() && !(file = new File(String.valueOf(this.preverifyExecutableText.getText()) + ".exe")).exists()) {
                    string = MTJUIMessages.DeviceBasicEditorPage_error_invalid_preverifier;
                }
            }
        }
        this.setErrorMessage(string);
        this.setValid(string == null);
    }

    protected void addPageControls(Composite composite) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DeviceBasicEditorPage.this.updateState();
            }
        };
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_name_label);
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(modifyListener);
        this.nameText.setEditable(false);
        new Label(composite, 0);
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_group_label);
        this.groupText = new Text(composite, 2048);
        this.groupText.setLayoutData((Object)new GridData(768));
        this.groupText.addModifyListener(modifyListener);
        this.groupText.setEditable(false);
        new Label(composite, 0);
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_description_label);
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_executable_label);
        this.executableText = new Text(composite, 2048);
        this.executableText.setLayoutData((Object)new GridData(768));
        this.executableText.addModifyListener(modifyListener);
        this.executableBrowseButton = new Button(composite, 8);
        this.executableBrowseButton.setText(MTJUIMessages.DeviceBasicEditorPage_executableBrowseButton_label);
        this.executableBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.executableText);
            }
        });
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_preverifier_label);
        this.preverifyExecutableText = new Text(composite, 2048);
        this.preverifyExecutableText.setLayoutData((Object)new GridData(768));
        this.preverifyExecutableText.addModifyListener(modifyListener);
        this.preverifyBrowseButton = new Button(composite, 8);
        this.preverifyBrowseButton.setText(MTJUIMessages.DeviceBasicEditorPage_preverifyBrowseButton_label);
        this.preverifyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.preverifyExecutableText);
            }
        });
        new Label(composite, 0);
        Label label = new Label(composite, 64);
        label.setText(MTJUIMessages.DeviceBasicEditorPage_preverifierTip);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
        new Label(composite, 0).setText(MTJUIMessages.DeviceBasicEditorPage_debug_server_label);
        this.debugServerCombo = this.createBooleanComboViewer(composite);
        this.debugServerCombo.getCombo().setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        Label label3 = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label3.setLayoutData((Object)gridData);
        Label label4 = new Label(composite, 0);
        label4.setText(MTJUIMessages.DeviceBasicEditorPage_launchCommand_label);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label4.setLayoutData((Object)gridData);
        this.launchCommandText = new Text(composite, 2114);
        this.launchCommandText.setTextLimit(1000);
        this.launchCommandText.addModifyListener(modifyListener);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 500;
        gridData.heightHint = 300;
        this.launchCommandText.setLayoutData((Object)gridData);
        this.initializeDeviceState();
    }

    protected void browseForExecutable(Text text) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(MTJUIMessages.DeviceBasicEditorPage_browseForExecutable_dialog_title);
        File file = new File(text.getText());
        while (file != null) {
            if (file.exists()) {
                fileDialog.setFileName(file.toString());
                break;
            }
            file = file.getParentFile();
        }
        String string = fileDialog.open();
        if (string != null) {
            text.setText(string);
        }
    }

    private static class BooleanContentProvider
    implements IStructuredContentProvider {
        private BooleanContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return BOOLEAN_VALUES;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class BooleanLabelProvider
    extends LabelProvider {
        private BooleanLabelProvider() {
        }

        public String getText(Object object) {
            Boolean bl = (Boolean)object;
            return bl != false ? MTJUIMessages.DeviceBasicEditorPage_yes_label : MTJUIMessages.DeviceBasicEditorPage_no_label;
        }
    }
}

