/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.mtj.internal.ui.editor.text.IControlHoverContentProvider;
import org.eclipse.mtj.internal.ui.editor.text.MTJDefaultInformationControl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class MTJTextHover
implements ITextHoverExtension,
ITextHover {
    public static void addHoverListenerToControl(final IInformationControl iInformationControl, final Control control, final IControlHoverContentProvider iControlHoverContentProvider) {
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
                if (iInformationControl instanceof MTJDefaultInformationControl && ((MTJDefaultInformationControl)iInformationControl).isDisposed()) {
                    return;
                }
                iInformationControl.setVisible(false);
            }

            public void mouseHover(MouseEvent mouseEvent) {
                if (iInformationControl instanceof MTJDefaultInformationControl && ((MTJDefaultInformationControl)iInformationControl).isDisposed()) {
                    return;
                }
                String string = iControlHoverContentProvider.getHoverContent(control);
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                MTJTextHover.updateHover(iInformationControl, string);
                iInformationControl.setLocation(control.toDisplay(new Point(10, 25)));
                iInformationControl.setVisible(true);
            }
        });
    }

    public static IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new MTJDefaultInformationControl(shell, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public static void updateHover(IInformationControl iInformationControl, String string) {
        iInformationControl.setInformation(string);
        Point point = iInformationControl.computeSizeHint();
        iInformationControl.setSize(point.x, point.y);
        if (string == null || string.trim().length() == 0) {
            iInformationControl.setVisible(false);
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return MTJTextHover.getInformationControlCreator();
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        return new Region(n, 0);
    }
}

